<?php
/**
 * prime-industry Theme Customizer
 *
 * @package prime-industry
 */

 // Custom Controls.
require get_template_directory() . '/inc/custom-control/custom-control.php';

// Sanitize callback.
require get_template_directory() . '/inc/customizer/sanitize-callback.php';

// Default
require get_template_directory() . '/inc/customizer/default.php';

// Load customize sanitize.
include get_template_directory() . '/inc/customizer/active-callback.php';


// Theme section.
// require get_template_directory() . '/inc/customizer/theme-section.php';

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function prime_industry_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'prime_industry_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'prime_industry_customize_partial_blogdescription',
			)
		);
	}
	// Front Page Link
	require get_template_directory() . '/inc/customizer/home-section.php';

	require get_template_directory() . '/inc/customizer/section-pro.php';

	// Theme Page Link
	require get_template_directory() . '/inc/customizer/theme-options.php';
}
add_action( 'customize_register', 'prime_industry_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function prime_industry_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function prime_industry_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function prime_industry_customize_preview_js() {
	wp_enqueue_script( 'prime_industry-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), prime_industry_S_VERSION, true );
}
add_action( 'customize_preview_init', 'prime_industry_customize_preview_js' );

/**
 *
 */
function prime_industry_customize_backend_scripts() {

	wp_enqueue_style( 'prime-industry-fontawesome-all', get_template_directory_uri() . '/assets/css/all.css' );

	wp_enqueue_style( 'prime-industry-main-css', get_template_directory_uri() . '/assets/css/output.css' );

	wp_enqueue_style( 'prime-industry-admin-customizer-style', get_template_directory_uri() . '/inc/customizer/css/customizer-style.css' );

	wp_enqueue_script( 'prime-industry-admin-customizer', get_template_directory_uri() . '/inc/customizer/js/customizer-script.js', array( 'jquery', 'customize-controls' ), '20151215', true );
	wp_enqueue_script( 'prime-industry-admin-customizer-control', get_template_directory_uri() . '/inc/customizer/js/customize-controls.js', array( 'jquery', 'customize-controls' ), '', true );
}
add_action( 'customize_controls_enqueue_scripts', 'prime_industry_customize_backend_scripts', 10 );

/**
 * Enqueue the stylesheet.
 */
function prime_industry_customizer_stylesheet() {

    wp_register_style( 'prime-industry-admin-css', get_template_directory_uri() . '/inc/customizer/css/customize-controls.css', NULL, NULL, 'all' );
    wp_enqueue_style( 'prime-industry-admin-css' );
}
add_action( 'customize_controls_print_styles', 'prime_industry_customizer_stylesheet' );

///////////////////////////// customize  color 

function prime_industry_customize_css()
{
?>
<style type="text/css">
/* ///////////////////////////  color.php /////////////////////////// */
/* ---------------## Theme Option Section Color Start ##------------- */
#section-header {
    background-color: <?php echo esc_html(get_theme_mod('headermenu_bg_color', '#000000')); ?>;
}

#site-navigation .logo {
    color: <?php echo esc_html(get_theme_mod('quote_bg_color'));
    ?>;
}
.topheader p {
    color: <?php echo esc_html(get_theme_mod('EmailId_color'));
    ?>;
}

.topheader .icon,
.iconshade {
    color: <?php echo esc_html(get_theme_mod('Email_icon_color'));
    ?>;
}

.topheader .social-links .socialicon {
    color: <?php echo esc_html(get_theme_mod('social_icon_color'));
    ?>;
}
.topheader .contact-info a .icon{
    color: <?php echo esc_html(get_theme_mod('info_icon_color'));
    ?>;
}
.bottomheader .contact-info .email_info a p{
    color: <?php echo esc_html(get_theme_mod('info_text_color'));?>;
}
#site-navigation ul li a{
    color: <?php echo esc_html(get_theme_mod('menu_text_color'));?>;
}

.widget .widget-title, .widget .wp-block-heading, .widget .wp-block-search__label{
    background-color: <?php echo esc_html(get_theme_mod('Sidebar_background_color'));
    ?>;
}


/* ---------------## Slider Section Color Start ##------------- */
#featured-slider .entry-container h4 {
    color: <?php echo esc_html(get_theme_mod('slider_title_color'));
    ?>;
}

#featured-slider .entry-container .content {
    color: <?php echo esc_html(get_theme_mod('slider_subtitle_color'));
    ?>;
}

#featured-slider .content a,
#featured-slider code,
.wp-block-buttons .wp-block-button__link,
.singlepage #submit {
    background: <?php echo esc_html(get_theme_mod('slider_readmore_color'));
    ?>;
}

#featured-slider .content a,
#featured-slider code,
.wp-block-buttons .wp-block-button__link,
.singlepage #submit {
    color: <?php echo esc_html(get_theme_mod('slider_readmoretxt_color'));
    ?> !important;
}

#featured-slider .slick-dots li {
    background: <?php echo esc_html(get_theme_mod('slider_slickdot_color'));
    ?>;
}

#featured-slider .slick-dots li.slick-active {
    background: <?php echo esc_html(get_theme_mod('slider_activeslickdot_color'));
    ?>;
}

#featured-slider .sliderbut2 a {
    color: <?php echo esc_html(get_theme_mod('slider_buttontext2_color'));
    ?>;
}

#featured-slider .sliderbut2 {
    background: <?php echo esc_html(get_theme_mod('slider_buttonbg2_color'));
    ?>;
}

/* ---------------## Slider Section Color End ##------------- */

/* ---------------## About us Section Color Start ##------------- */
#featured-about {
    background-color: <?php echo esc_html(get_theme_mod('featured_about_section_bg_color'));
    ?>;
}

#featured-about .title-section h5 {
    color: <?php echo esc_html(get_theme_mod('about_maintitle_color'));
    ?>;
}

#featured-about .title-section h1 {
    color: <?php echo esc_html(get_theme_mod('about_title_color'));
    ?>;
}

#featured-about p {
    color: <?php echo esc_html(get_theme_mod('about_subtitle_color'));
    ?>;
}

#featured-about .title-section .row i,
#featured-about .title-section .row svg {
    color: <?php echo esc_html(get_theme_mod('about_bx1icn_clr'));
    ?>;
}

#featured-about .title-section .row h3 {
    color: <?php echo esc_html(get_theme_mod('about_bxtitleclr_clr'));
    ?>;
}

#featured-about .plans p {
    color: <?php echo esc_html(get_theme_mod('about_bxtexteclr_clr'));
    ?>;
}

#featured-about .title-section .about_facility p,
#featured-about .title-section .about_facility p::before {
    color: <?php echo esc_html(get_theme_mod('about_facility_clr'));
    ?>;
}

#featured-about .title-section .button a {
    background-color: <?php echo esc_html(get_theme_mod('about_button_bgclr'));
    ?>;
}

#featured-about .title-section .button a {
    color: <?php echo esc_html(get_theme_mod('about_button_textclr'));
    ?>;
}

#featured-about .about-img-box h2 {
    color: <?php echo esc_html(get_theme_mod('about_image_upper_textclr'));
    ?>;
}

#featured-about .about-img-box h3 {
    color: <?php echo esc_html(get_theme_mod('about_image_below_textclr'));
    ?>;
}

/* ---------------## About us Section Color End ##------------- */

/* ---------------## What we Offer Section Color Start ##------------- */
.featured-whatweoffer {
    background: <?php echo esc_html(get_theme_mod('whatweoffer_background_color'));
    ?>;
}

.featured-whatweoffer .head-title {
    color: <?php echo esc_html(get_theme_mod('whatweoffer_title_color'));
    ?>;
}

.featured-whatweoffer .head-subtitle {
    color: <?php echo esc_html(get_theme_mod('whatweoffer_subtitle_color'));
    ?>;
}

.featured-whatweoffer .title a {
    color: <?php echo esc_html(get_theme_mod('whatweoffer_cardtitle_color'));
    ?>;
}

/* ---------------## What we Offer Section Color End ##------------- */
</style>

<?php
}
add_action('wp_head', 'prime_industry_customize_css');