<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package prime-industry
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">

    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>
    <div id="page" class="site header">
        <a class="skip-link screen-reader-text"
            href="#primaryid"><?php esc_html_e( 'Skip to content', 'prime-industry' ); ?></a>
        <header id="masthead" class="site-header">
            <div id="section-header" class="section-header">

                <div class="bottomheader stickyheader <?php echo esc_attr(prime_industry_sticky_header()); ?>">
                    <div class="container-fluid p-0">
                        <div class="row header-row">
                            <nav id="site-navigation" class="main-navigation navbar navbar-expand-lg">
                                <div class="col-xl-2 col-lg-2 col-md-12 col-12 pd-0 logo">
                                    <div class="sitenave">
                                        <div class="site-branding">
                                            <?php
                                        if (has_custom_logo()) {
                                            the_custom_logo();
                                        } else {
                                            if (is_front_page() && is_home()): ?>
                                            <h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"
                                                    rel="home"><?php bloginfo('name'); ?></a></h1>
                                            <?php else: ?>
                                            <div class="business-box">
                                                <div class="business-title-container">
                                                    <h1 class="site-title"><a
                                                            href="<?php echo esc_url(home_url('/')); ?>"
                                                            rel="home"><?php bloginfo('name'); ?></a></h1>
                                                </div>
                                            </div>
                                            <?php endif; ?>

                                            <?php
                                        $the_prime_industry_description = get_bloginfo('description', 'display');
                                        if ($the_prime_industry_description || is_customize_preview()): ?>
                                            <p class="site-description">
                                                <?php echo $the_prime_industry_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                                            </p>
                                            <?php endif; 
                                    } ?>
                                        </div>
                                        <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                                            <i class="fa-solid fa-bars mobile-nav-icon bars"></i>
                                            <i class="fa-solid fa-xmark mobile-nav-icon close"></i>
                                        </button>
                                    </div>
                                </div>

                                <div class="col-xl-10 col-lg-10 col-md-12 col-sm-10 pd-0">

                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="topheader justify-content-md-between">
                                                <div
                                                    class="d-flex align-items-center justify-content-center justify-content-md-between">

                                                    <div
                                                        class="contact-info d-flex align-items-center d-none d-md-flex">
                                                        <div class="email_info " style="display: contents;">
                                                            <a href="#"
                                                                class="d-flex justify-content-center align-item-center">
                                                                <i
                                                                    class="fa-solid <?php echo esc_html(get_theme_mod('prime_industry_location_icon', __('fa-location-dot', 'prime-industry'))) ?> icon me-2"></i>
                                                                <p class="mb-0 mt-1">
                                                                    <?php echo esc_html(get_theme_mod('prime_industry_head_locationtitle', __('Lorem ipsum dolor New York', 'prime-industry')))?>
                                                                </p>
                                                            </a>
                                                            <a href="#"
                                                                class="d-flex justify-content-center align-item-center ">
                                                                <i
                                                                    class="fa-solid <?php echo esc_html(get_theme_mod('prime_industry_email_icon', __('fa-envelope', 'prime-industry'))) ?> icon me-3"></i>
                                                                <p class="mb-0 mt-1">
                                                                    <?php echo esc_html(get_theme_mod('prime_industry_head_emailtitle', __('info@example.com', 'prime-industry')))?>
                                                                </p>
                                                            </a>
                                                            <a href="#"
                                                                class="d-flex justify-content-center align-item-center ">
                                                                <i
                                                                    class="fa-solid <?php echo esc_html(get_theme_mod('prime_industry_time_icon', __('fa-clock', 'prime-industry'))) ?> icon me-3"></i>
                                                                <p class="mb-0 mt-1">
                                                                    <?php echo esc_html(get_theme_mod('prime_industry_head_timetitle', __('Mon - Sat 10.00 - 18.00', 'prime-industry')))?>
                                                                </p>
                                                            </a>
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-2 col-lg-2 col-md-2 col-12 laptop">
                                                        <div class="social-links" style="font-size: 20px;">
                                                            <a href="#" class="me-4">
                                                                <i
                                                                    class="fa-brands socialicon <?php echo esc_html(get_theme_mod('prime_industry_facebook_icon', __('fa-facebook-f', 'prime-industry'))) ?>"></i>
                                                            </a>
                                                            <a href="#" class="me-4">
                                                                <i
                                                                    class="fa-brands socialicon <?php echo esc_html(get_theme_mod('prime_industry_youtube_icon', __('fa-youtube', 'prime-industry'))) ?>">"></i>
                                                            </a>
                                                            <a href="#">
                                                                <i
                                                                    class="fa-brands socialicon <?php echo esc_html(get_theme_mod('prime_industry_twitter_icon', __('fa-twitter', 'prime-industry'))) ?>"></i>
                                                            </a>
                                                            <a href="#" class="me-4">
                                                                <i
                                                                    class="fa-brands socialicon <?php echo esc_html(get_theme_mod('prime_industry_instagram_icon', __('fa-instagram', 'prime-industry'))) ?>">"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-9">
                                            <?php
                                    wp_nav_menu(
                                        array(
                                            'theme_location' => 'menu-1',
                                            'menu_id'        => 'primary-menu',
                                        )
                                    );
                           
     ?>

                                        </div>
                                        <div class="col-lg-3">
                                            <?php
                                                // Get dynamic contact link and button text
                                                $contact_url = get_theme_mod('contact_link_url', '#');
                                                $contact_button_text = prime_industry_get_option('contact_button_text', 'Contact');
                                                ?>

                                            <li class="menu-item search-trigger d-flex align-items-center">
                                                <!-- Search Button -->
                                                <button type="button" id="formButton" class="search-toggle-btn"
                                                    aria-label="Search">
                                                    <svg width="20" height="20" viewBox="0 0 30 30" fill="currentColor"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M13 3C7.49 3 3 7.49 3 13s4.49 10 10 10c2.4 0 4.6-.85 6.32-2.26l5.97 5.97a1 1 0 0 0 1.41-1.41l-5.97-5.97A9.94 9.94 0 0 0 23 13c0-5.51-4.49-10-10-10zm0 2c4.43 0 8 3.57 8 8s-3.57 8-8 8-8-3.57-8-8 3.57-8 8-8z" />
                                                    </svg>
                                                </button>

                                               
                                            </li>
                                            <div class="top-form">
                                                <div id="form1" class="search-overlay" style="display: none;">
                                                    <div class="search-box">
                                                        <?php get_search_form(); ?>
                                                        <span id="closeForm" class="close-btn"
                                                            aria-label="Close Search">×</span>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>


                            </nav><!-- #site-navigation -->
                        </div>
                    </div>
                </div>
            </div>


        </header><!-- #masthead -->