<?php
/**
 * prime-industry functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package prime-industry
 */

if ( ! defined( 'prime_industry_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'prime_industry_S_VERSION', '1.0.0' );
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function prime_industry_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on prime-industry, use a find and replace
		* to change 'prime-industry' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'prime-industry', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/**
 * Enable support for Post Thumbnails on posts and pages.
 *
 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
 */
	add_theme_support('post-thumbnails');


	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'prime-industry' ),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'prime_industry_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'prime_industry_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $prime_industry_content_width_global
 */
function prime_industry_content_width() {
	$GLOBALS['prime_industry_content_width_global'] = apply_filters( 'prime_industry_content_width', 640 );
}
add_action( 'after_setup_theme', 'prime_industry_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function prime_industry_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'prime-industry' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'prime-industry' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
	array(
		'name' => sprintf(esc_html__('Footer %d', 'prime-industry'), 1),
		'id' => 'footer-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	));
register_sidebar(
	array(
		'name' => sprintf(esc_html__('Footer %d', 'prime-industry'), 2),
		'id' => 'footer-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	));
register_sidebar(
	array(
		'name' => sprintf(esc_html__('Footer %d', 'prime-industry'), 3),
		'id' => 'footer-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	));
register_sidebar(
	array(
		'name' => sprintf(esc_html__('Footer %d', 'prime-industry'), 4),
		'id' => 'footer-4',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	));
}
add_action( 'widgets_init', 'prime_industry_widgets_init' );

/**
 * Register custom fonts.
 */
function prime_industry_fonts_url()
{
	$fonts_url = '';
	$fonts = array();
	$subsets = 'latin,latin-ext';

	/* translators: If there are characters in your language that are not supported by Lora, translate this to 'off'. Do not translate into your own language. */
	if ('off' !== _x('on', 'Lora: on or off', 'prime-industry')) {
		$fonts[] = 'Lora:400,600,700';
	}

	if ('off' !== _x('on', 'Space Grotesk: on or off', 'prime-industry')) {
		$fonts[] = 'Space Grotesk:300,400,500,600,700';
	}

	if ($fonts) {
		$fonts_url = add_query_arg(
			array(
				'family' => urlencode(implode('|', $fonts)),
				'subset' => urlencode($subsets),
			), 'https://fonts.googleapis.com/css');
	}

	return esc_url_raw($fonts_url);
}

/**
 * Function that returns if the menu is sticky
 */
if (!function_exists('prime_industry_sticky_header')):
    function prime_industry_sticky_header()
    {
        $is_sticky = get_theme_mod('prime_industry_sticky_header', false);

        if ($is_sticky == false):
            return 'not-sticky';
        else:
            return 'is-sticky-on';
        endif;
    }
endif;

/**
 * Enqueue scripts and styles.
 */
function prime_industry_scripts() {
	wp_enqueue_style( 'prime-industry-style', get_stylesheet_uri(), array(), prime_industry_S_VERSION );
	wp_style_add_data( 'prime-industry-style', 'rtl', 'replace' );

	wp_enqueue_style('prime-industry-all.css', get_stylesheet_directory_uri() . "/assets/css/all.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-responsive.css', get_stylesheet_directory_uri() . "/assets/css/responsive.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-all.min.css', get_stylesheet_directory_uri() . "/assets/css/all.min.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-animate-3.5.2.css', get_stylesheet_directory_uri() . "/assets/css/animate-3.5.2.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-animate.css', get_stylesheet_directory_uri() . "/assets/css/animate.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-output.css', get_stylesheet_directory_uri() . "/assets/css/output.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-blocks.css', get_stylesheet_directory_uri() . "/assets/css/blocks.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-blocks.min.css', get_stylesheet_directory_uri() . "/assets/css/blocks.min.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-bootstrap.min.css', get_stylesheet_directory_uri() . "/assets/css/bootstrap.min.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-slick-theme.css', get_stylesheet_directory_uri() . "/assets/css/slick-theme.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-slick-theme.min.css', get_stylesheet_directory_uri() . "/assets/css/slick-theme.min.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-slick.css', get_stylesheet_directory_uri() . "/assets/css/slick.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-slick.min.css', get_stylesheet_directory_uri() . "/assets/css/slick.min.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-pe-customize-controls.css', get_stylesheet_directory_uri() . "/assets/css/pe-customize-controls.css", '', prime_industry_S_VERSION);
	wp_enqueue_style('prime-industry-swiper-bundle.min.css', get_stylesheet_directory_uri() . "/assets/css/swiper-bundle.min.css", '', prime_industry_S_VERSION);
	// wp_enqueue_style('prime-industry-fontawesome.css', get_stylesheet_directory_uri() . "/assets/css/fontawesome.css", '', prime_industry_S_VERSION);


	wp_enqueue_script( 'prime-industry-navigation', get_template_directory_uri() . '/js/navigation.js', array(), prime_industry_S_VERSION, true );
	wp_enqueue_script( 'prime-industry-all.min.js', get_template_directory_uri() . '/assets/js/all.min.js', array(), prime_industry_S_VERSION, true );	
	wp_enqueue_script( 'prime-industry-jquery.min.js', get_template_directory_uri() . '/assets/js/jquery.min.js', array(), prime_industry_S_VERSION, true );	
	wp_enqueue_script( 'prime-industry-bootstrap.bundle.min.js', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array(), prime_industry_S_VERSION, true );
	wp_enqueue_script( 'prime-industry-custom.js', get_template_directory_uri() . '/assets/js/custom.js', array(), prime_industry_S_VERSION, true );
	wp_enqueue_script( 'prime-industry-jquery.counterup.min.js', get_template_directory_uri() . '/assets/js/jquery.counterup.min.js', array(), prime_industry_S_VERSION, true );
	wp_enqueue_script( 'prime-industry-slick.js', get_template_directory_uri() . '/assets/js/slick.js', array(), prime_industry_S_VERSION, true );
	wp_enqueue_script( 'prime-industry-slick.min.js', get_template_directory_uri() . '/assets/js/slick.min.js', array(), prime_industry_S_VERSION, true );
	wp_enqueue_script( 'prime-industry-swiper-bundle.min.js', get_template_directory_uri() . '/assets/js/swiper-bundle.min.js', array(), prime_industry_S_VERSION, true );
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'prime_industry_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';
/**
 * Color customizer.
 */
// require get_template_directory() . '/inc/custom-colors.php';


/**
 * Custom functions that act independently of the theme templates.
 */
// require get_template_directory() . '/inc/extras.php';
if ( ! function_exists( 'prime_industry_the_excerpt' ) ) :

	function prime_industry_the_excerpt( $length = 0, $post_obj = null ) {

		global $post;

		if ( is_null( $post_obj ) ) {
			$post_obj = $post;
		}

		$length = absint( $length );

		if ( 0 === $length ) {
			return;
		}

		$source_content = $post_obj->post_content;

		if ( ! empty( $post_obj->post_excerpt ) ) {
			$source_content = $post_obj->post_excerpt;
		}

		$source_content = preg_replace( '`\[[^\]]*\]`', '', $source_content );
		$trimmed_content = wp_trim_words( $source_content, $length, '&hellip;' );
		return $trimmed_content;

	}

endif;
/**
 * Load Hooks.
 */
require get_template_directory() . '/inc/hook/structure.php';
require get_template_directory() . '/inc/hook/custom.php'; 
require get_template_directory() . '/inc/hook/basic.php';
/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}


////////////////////////////////////////////////////////////////////////////////////////////////////////
// Integer sanitization
if ( ! function_exists( 'prime_industry_sanitize_integer' ) ) {
    function prime_industry_sanitize_integer( $input ) {
        return (int) $input;
    }
}
function prime_industry_customizer_script() {
    wp_enqueue_script(
        'prime_industry-customizer-script',
        get_template_directory_uri() . '/assets/js/customizer-button.js',
        ['customize-controls'],
        '1.0',
        true
    );
}
add_action( 'customize_controls_enqueue_scripts', 'prime_industry_customizer_script' );







if ( ! function_exists( 'prime_industry_footer_sidebar_class' ) ) {
function prime_industry_footer_sidebar_class() {
$data = array();
$active_sidebar = array();
$count = 0;

if ( is_active_sidebar( 'footer-1' ) ) {
  $active_sidebar[] = 'footer-1';
  $count++;
}
if ( is_active_sidebar( 'footer-2' ) ) {
  $active_sidebar[] = 'footer-2';
  $count++;
}
if ( is_active_sidebar( 'footer-3' ) ) {
  $active_sidebar[] = 'footer-3';
  $count++;
}
if ( is_active_sidebar( 'footer-4' ) ) {
  $active_sidebar[] = 'footer-4';
  $count++;
}

$class = 'grid xl:grid-cols-4 lg:grid-cols-4 md:grid-cols-2 sm:grid-cols-12 gap-16';

$data['active_sidebar'] = $active_sidebar;
$data['class'] = $class;

return $data;
}
}
