<?php
/**
 * Template part for displaying Slider Section
 *
 * @package prime-home-renovation
 */

$prime_home_renovation_data_slick_speed = prime_home_renovation_get_option('data_slick_speed');
$prime_home_renovation_data_slick_infinite = prime_home_renovation_get_option('data_slick_infinite');
$prime_home_renovation_data_slick_dots = prime_home_renovation_get_option('data_slick_dots');
$prime_home_renovation_data_slick_autoplay = prime_home_renovation_get_option('data_slick_autoplay');
$prime_home_renovation_data_slick_draggable = prime_home_renovation_get_option('data_slick_draggable');
$prime_home_renovation_data_slick_fade = prime_home_renovation_get_option('data_slick_fade');
$prime_home_renovation_featured_slider_content_type = prime_home_renovation_get_option('featured_slider_content_type');
$prime_home_renovation_number_of_featured_slider_items = prime_home_renovation_get_option('number_of_featured_slider_items');
// $slider_enable_section               = get_theme_mod('slider_enable_section', 'on');

?>
<?php if (!get_theme_mod('slider_enable_section', true)) {
    return;
} ?>

<?php
// Convert numeric options to boolean strings for slick carousel
$prime_home_renovation_data_slick_infinite = $prime_home_renovation_data_slick_infinite ? 'true' : 'false';
$prime_home_renovation_data_slick_dots = $prime_home_renovation_data_slick_dots ? 'true' : 'false';
$prime_home_renovation_data_slick_autoplay = $prime_home_renovation_data_slick_autoplay ? 'true' : 'false';
$prime_home_renovation_data_slick_draggable = $prime_home_renovation_data_slick_draggable ? 'true' : 'false';
$prime_home_renovation_data_slick_fade = $prime_home_renovation_data_slick_fade ? 'true' : 'false';
?>

<div id="featured-slider">
    <div class="section-content"
        data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": <?php echo esc_attr($prime_home_renovation_data_slick_infinite); ?>, "speed": <?php echo esc_attr($prime_home_renovation_data_slick_speed); ?>, "dots": <?php echo esc_attr($prime_home_renovation_data_slick_dots); ?>, "autoplay": <?php echo esc_attr($prime_home_renovation_data_slick_autoplay); ?>, "draggable": <?php echo esc_attr($prime_home_renovation_data_slick_draggable); ?>, "fade": <?php echo esc_attr($prime_home_renovation_data_slick_fade); ?> }'>

        <?php
        $prime_home_renovation_number_of_featured_slider_items = absint(get_theme_mod('number_of_featured_slider_items', 5)); // Ensure the value is an integer
        
        // Ensure the number of posts starts from 1, and not showing any extras
        if ($prime_home_renovation_number_of_featured_slider_items < 1) {
            $prime_home_renovation_number_of_featured_slider_items = 1; // Ensure minimum value is 1
        }

        ?> <?php $prime_home_renovation_slider_pages = array();
         for ($prime_home_renovation_count = 1; $prime_home_renovation_count <= 4; $prime_home_renovation_count++) {
             $prime_home_renovation_mod = intval(get_theme_mod('select_post_slider' . $prime_home_renovation_count));
             if ('page-none-selected' != $prime_home_renovation_mod) {
                 $prime_home_renovation_slider_pages[] = $prime_home_renovation_mod;
             }
         }
         if (!empty($prime_home_renovation_slider_pages)):
             $prime_home_renovation_args = array(
                 'post_type' => 'post',
                 'post__in' => $prime_home_renovation_slider_pages,
                 'posts_per_page' => $prime_home_renovation_number_of_featured_slider_items,
                 'orderby' => 'post__in'
             );
             $prime_home_renovation_catquery = new WP_Query($prime_home_renovation_args);

             $prime_home_renovation_catquery_counter = 0; // Initialize counter
             while ($prime_home_renovation_catquery->have_posts() && $prime_home_renovation_catquery_counter < $prime_home_renovation_number_of_featured_slider_items):
                 $prime_home_renovation_catquery->the_post();
                 $prime_home_renovation_catquery_counter++;
                 ?>
                <article>
                    <div class="opbg">
                        <div class="slide-inner slide-bg-image">
                            <div class="sliderimg">
                                <?php if (has_post_thumbnail()): ?>
                                    <?php $prime_home_renovation_total_slider_image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); ?>
                                    <img class="slide-mainimg" alt="<?php echo esc_attr(get_the_title()); ?>"
                                        src="<?php echo esc_url($prime_home_renovation_total_slider_image[0]); ?>">
                                <?php endif; ?>

                                <div class="position-absolute" style="bottom:0;right:0;justify-items:flex-end;z-index:1;">
                                        <?php
                                                            $prime_home_renovation_rightimage = get_theme_mod('prime_home_renovation_image_rightside');

                                                            if ($rightimage) {
                                                                echo '<img  class="imgbox2" src="' . esc_url($prime_home_renovation_rightimage) . '" alt="">';
                                                            } else {
                                                                echo '<img  class="imgbox2" src="' . esc_url(get_template_directory_uri() . '/assets/images/imgbg.png') . '" alt="Default">';
                                                            }
                                                            ?>


                                    <img class="imgbox1"
                                        src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/img1.png') ?>"
                                        alt="">
                                </div>
                            </div>
                            <div class="row d-flex align-items-center">
                                <div class="slider-inner-mainbox">
                                    <?php if (get_theme_mod('featured_slider_overlayimg_enable', true)): ?>
                                        <!-- Additional content if enabled -->
                                    <?php endif; ?>
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 leftcontentbox <?php echo esc_attr(get_theme_mod('prime_home_renovation_featured_slider_onload_effects', 'wow zoomIn')); ?>"
                                        data-wow-duration="2s">
                                        <div class="wrapper animated <?php echo esc_attr(get_theme_mod('prime_home_renovation_featured_slider_onload_effects', 'wow Bounce In Up')); ?>"
                                            data-wow-duration="2s">
                                            <div class="entry-container"
                                                style="text-align: <?php echo (get_theme_mod('featured_slider_box_align', 'Left') == 'Left') ? 'left' : ((get_theme_mod('featured_slider_box_align', 'Center') == 'Center') ? 'center' : 'right'); ?>">
                                                <header class="entry-header header">
                                                    <div class="read-more me-4">
                                                        <img class="imgarrow"
                                                            src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/Group 6.svg') ?>"
                                                            alt="">
                                                        <h2 class="entry-title"
                                                            style="text-transform : <?php if (get_theme_mod('featured_slider_title_case', 'Uppercase') == 'Uppercase') { ?> Uppercase <?php } elseif (get_theme_mod('featured_slider_title_case', 'Capitalize') == 'Capitalize') { ?> Capitalize <?php } elseif (get_theme_mod('featured_slider_title_case', 'Lowercase') == 'Lowercase') { ?> Lowercase <?php } elseif (get_theme_mod('featured_slider_title_case', 'None') == 'None') { ?> none <?php } ?>">
                                                            <?php the_title(); ?>
                                                        </h2>

                                                    </div>

                                                </header>
                                                <div class="hrdiv"></div>
                                                <div class="sliderparaimg">
                                                    <div class="row">
                                                        <div class="col-sm-1 col-year">
                                                            <?php
                                                            $prime_home_renovation_image = get_theme_mod('prime_home_renovation_image_leftside');

                                                            if ($prime_home_renovation_image) {
                                                                echo '<img src="' . esc_url($prime_home_renovation_image) . '" alt="">';
                                                            } else {
                                                                echo '<img src="' . esc_url(get_template_directory_uri() . '/assets/images/Group 11.svg') . '" alt="Default">';
                                                            }
                                                            ?>
                                                        </div>
                                                        <div class="col-sm-11 entry-content content"
                                                            style="text-align: <?php echo (get_theme_mod('featured_slider_box_align', 'Left') == 'Left') ? 'left' : ((get_theme_mod('featured_slider_box_align', 'Center') == 'Center') ? 'center' : 'right'); ?>">
                                                            <?php $prime_home_renovation_excerpt = prime_home_renovation_the_excerpt(25);
                                                            echo wp_kses_post(wpautop($prime_home_renovation_excerpt)); ?>

                                                            <div class="d-flex mt-5">
                                                                <div class="sliderbut1 animated flipInY d-flex">
                                                                    
                                                                <a href="<?php echo esc_url(get_theme_mod('prime_home_renovation_button1_url', '#')); ?>" class="btn1 btn-custom1 rounded1">
                                                                    <?php echo esc_html(get_theme_mod('prime_home_renovation_button1_text', 'Free Consultations')); ?>
                                                                </a>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>



                                                </div><!-- .entry-container -->
                                            </div><!-- .wrapper -->
                                        </div><!-- .leftcontentbox -->
                                    </div><!-- .slider-inner-mainbox -->
                                </div><!-- .row -->
                            </div><!-- .slide-inner -->
                        </div><!-- .opbg -->
                </article>
            <?php endwhile; ?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
    </div><!-- .section-content -->
</div>