<?php
/**
 * Template part for displaying Featured Courses Section
 *
 *@package prime-home-renovation  
 */
$featured_services_content_type = prime_home_renovation_get_option('featured_services_content_type');
$prime_home_renovation_featured_services_section_maintaitle = prime_home_renovation_get_option('featured_services_section_maintaitle');
$prime_home_renovation_featured_services_section_subtitle = prime_home_renovation_get_option('featured_services_section_subtitle');
$number_of_featured_services_items = prime_home_renovation_get_option('number_of_featured_services_items');
$featured_services_column = prime_home_renovation_get_option('featured_services_column');
$services_excerpt_mainpagelength = prime_home_renovation_get_option('services_excerpt_mainpagelength');
$featured_services_posts = prime_home_renovation_get_option('featured_services_posts');
$prime_home_renovation_service_text = prime_home_renovation_get_option('prime_home_renovation_service_text');


?>
<section id="featured-services">
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="entry-content3 mt-5">
                <h5><?php echo esc_html($prime_home_renovation_featured_services_section_maintaitle); ?>
                </h5>
                <h6><?php echo ($prime_home_renovation_featured_services_section_subtitle); ?></h6>
            </div><!-- .entry-content -->
        </div>
    </div>
    <div class="row">
        <div
            class="grid xl:grid-cols-<?php echo esc_attr($featured_services_column); ?> lg:grid-cols-<?php echo esc_attr($featured_services_column); ?> md:grid-cols-2 sm:grid-cols-1 grid-cols-1 servicerightside">

            <?php

            // if ($featured_services_content_type == 'featured_services_page'):
                for ($prime_home_renovation_i = 1; $prime_home_renovation_i <= $number_of_featured_services_items; $prime_home_renovation_i++):
                    $featured_services_posts[] = prime_home_renovation_get_option('featured_services_page_' . $prime_home_renovation_i);
                endfor;

                $prime_home_renovation_args = array(
                    'post_type' => 'page',
                    'post__in' => $featured_services_posts,
                    'posts_per_page' => absint($number_of_featured_services_items),
                    'orderby' => 'post__in',
                );

                $prime_home_renovation_loop = new WP_Query($prime_home_renovation_args);
                if ($prime_home_renovation_loop->have_posts()):
                    $prime_home_renovation_i = -1;
                    $prime_home_renovation_j = 0;
                    while ($prime_home_renovation_loop->have_posts()):
                        $prime_home_renovation_loop->the_post();
                        $prime_home_renovation_i++;
                        $prime_home_renovation_j++;
                        $prime_home_renovation_featured_icon_service[$prime_home_renovation_j] = prime_home_renovation_get_option('featured_icon_service' . $prime_home_renovation_j);

                        $prime_home_renovation_class = '';
                        if ($prime_home_renovation_i == 0) {
                            $prime_home_renovation_class = 'display-block';
                        } else {
                            $prime_home_renovation_class = 'display-none';
                        }
                        ?>
                        <article
                            class="m-3 paddingdiv <?php echo esc_attr(get_theme_mod('prime_home_renovation_featured_services_onload_effects', 'wow zoomIn')); ?>"
                            data-wow-duration="2s">
                            <a href="<?php the_permalink(); ?>">
                                <div class="featured-service-item h-full"
                                    style="text-align : <?php if (get_theme_mod('featured_services_box_align', 'Left') == 'Left') { ?> Left <?php } elseif (get_theme_mod('featured_services_box_align', 'Center') == 'Center') { ?> Center <?php } elseif (get_theme_mod('featured_services_box_align', 'Right') == 'Right') { ?> right <?php } ?> ">
                                    <div class="entry-container">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php if (has_post_thumbnail($post->ID)): ?>
                                                <?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail'); ?>
                                                <div class=""
                                                    style="background-size: 100% 100%; background-image: url(<?php echo $image[0]; ?>); height: <?php echo esc_attr(get_theme_mod('featured_services_post_image_height', '250')) ?>px;">
                                                </div>
                                                <?php if (get_theme_mod('enable_featured_service_flower_image', true) == true) { ?>
                                                    <i class="fa-solid fa-xl fa-helmet-safety"></i>
                                                <?php }
                                                ; ?>
                                            <?php endif; ?>
                                        </a>
                                        <div class="position-relative">
                                            <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                            <?php
                                            $services_excerpt_mainpagelength = prime_home_renovation_the_excerpt(prime_home_renovation_get_option('services_excerpt_mainpagelength'));
                                            echo wp_kses_post(wpautop($services_excerpt_mainpagelength));
                                            ?>
                                            <a href="<?php the_permalink(); ?>" class="newsCaption-link">
                                                <?php echo ($prime_home_renovation_service_text); ?></a>
                                        </div>
                                    </div><!-- .entry-container -->
                                </div>
                            </a>
                        </article>

                    <?php endwhile; ?>

                <?php endif; ?>
                <?php wp_reset_postdata(); ?>
                <!-- </?php endif; ?> -->
              
            </div>
        
    </div>
</section>


<!-- ///////////////////////////// -->