<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package prime-home-renovation
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
<div class="banner-head">
<header class="entry-header">
        <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
    </header><!-- .entry-header -->

</div>
    
    <div class="container" id="primaryid">
        <?php prime_home_renovation_post_thumbnail(); ?>

        <div class="entry-content">
            <?php
		the_content();

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'prime-home-renovation' ),
				'after'  => '</div>',
			)
		);
		?>
        </div><!-- .entry-content -->
        <?php if ( get_edit_post_link() ) : ?>
        <footer class="entry-footer">
            <?php
			edit_post_link(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Edit <span class="screen-reader-text">%s</span>', 'prime-home-renovation' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					wp_kses_post( get_the_title() )
				),
				'<span class="edit-link" id="primaryid">',
				'</span>'
			);
			?>
        </footer><!-- .entry-footer -->
        <?php endif; ?>
    </div>


</article><!-- #post-<?php the_ID(); ?> -->