<?php 
/**
 * Home Section
 *
 * @package prime-home-renovation
 */

$prime_home_renovation_default = prime_home_renovation_get_default_theme_options();

/** Slider Info section */
$wp_customize->add_section(
    'featured_slider_info_section',
    array(
        'title'    => __( 'Slider Info', 'prime-home-renovation' ),      
        'priority' => 1,
        'panel'      => 'prime_home_renovation_section_panel',       	
    )
);

// Enable Section
$wp_customize->add_setting(
    'slider_enable_section',
    array(
        'default' 			=> true,
       'sanitize_callback' => 'prime_home_renovation_sanitize_switch',

    )
);
$wp_customize->add_control(
    new Prime_Home_Renovation_Toggle_Checkbox_Custom_control(
        $wp_customize,
        'slider_enable_section',
        array(
            'settings'      => 'slider_enable_section',
            'section'       => 'featured_slider_info_section',
            'label'         => __( 'Enable Section', 'prime-home-renovation' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'prime-home-renovation' ),
                'off' => __( 'No', 'prime-home-renovation' )
            ),
        )
    )
);

// /// effects
$wp_customize->add_setting('prime_home_renovation_featured_slider_onload_effects',array(
    'default' => 'Bounce In Up',
    'sanitize_callback' => 'prime_home_renovation_sanitize_choices',
));
$wp_customize->add_control('prime_home_renovation_featured_slider_onload_effects',array(
    'type' => 'select',
    'label' => __('Box Onload Transition Effects','prime-home-renovation'),
    'choices' => array (
        'wow bounceInLeft' => __('Bounce In Left','prime-home-renovation'),
        'wow bounceInRight' => __('Bounce In Right','prime-home-renovation'),
        'wow bounceInUp' => __('Bounce In Up','prime-home-renovation'),
        'wow bounceInDown' => __('Bounce In Down','prime-home-renovation'),
        'wow zoomIn' => __('Zoom In','prime-home-renovation'),
        'wow zoomOut' => __('Zoom Out','prime-home-renovation'),
        'wow fadeInDown' => __('Fade In Down','prime-home-renovation'),            
        'wow fadeInUp' => __('Fade In Up','prime-home-renovation'),
        'wow fadeInLeft' => __('Fade In Left','prime-home-renovation'),
        'wow fadeInRight' => __('Fade In Right','prime-home-renovation'),
        'flip-up' => __('Flip Up','prime-home-renovation')
    ),
    'section' => 'featured_slider_info_section',
)); 

// Items
// Number of Slider Items
$wp_customize->add_setting('number_of_featured_slider_items', array(
    'default'           => 3, // Set default number of items
    'sanitize_callback' => 'absint', // Ensure it's a valid integer
));

$wp_customize->add_control('number_of_featured_slider_items', array(
    'label'    => __('Number Of Slider To Show', 'prime-home-renovation'),
    'section'  => 'featured_slider_info_section', // The section where this control will appear
    'type'     => 'number',
    'input_attrs' => array(
        'min' => 1, // Minimum value
        'max' => 10, // Maximum value
        'step' => 1, // Increment step
    ),
));

$prime_home_renovation_slider_list = array();
$prime_home_renovation_args = array('post_type' => 'post'); // Fetch posts, not pages
$prime_home_renovation_posts = get_posts( $prime_home_renovation_args ); 
foreach($prime_home_renovation_posts as $prime_home_renovation_post) {
    $prime_home_renovation_slider_list[$prime_home_renovation_post->ID] = $prime_home_renovation_post->post_title; // Use post ID as key and title as value
}

for ( $prime_home_renovation_count = 1; $prime_home_renovation_count <= 4; $prime_home_renovation_count++ ) {
    $wp_customize->add_setting( 'select_post_slider' . $prime_home_renovation_count, array(
        'default'           => '',
        'sanitize_callback' => 'prime_home_renovation_sanitize_post_dropdown'
    ));
    $wp_customize->add_control( 'select_post_slider' . $prime_home_renovation_count, array(
        'label'   => __( 'Select A Post Page', 'prime-home-renovation' ),
        'section' => 'featured_slider_info_section',
        'type'    => 'select', // Use 'select' for custom post list
        'choices' => $prime_home_renovation_slider_list // Populate choices with posts
    ));
}


//Right Image
$wp_customize->add_setting( 'prime_home_renovation_image_rightside', array(  
    'sanitize_callback' => 'prime_home_renovation_sanitise_custom_url'
    ));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'prime_home_renovation_image_rightside', array(
        'label'      => __( 'Right Side Image', 'prime-home-renovation' ),
        'description' => __( ' size: 566px x 738px', 'prime-home-renovation' ),
        'section'    => 'featured_slider_info_section',
        'settings'   => 'prime_home_renovation_image_rightside',
)));

//Left Image
$wp_customize->add_setting( 'prime_home_renovation_image_leftside', array(  
    'sanitize_callback' => 'prime_home_renovation_sanitise_custom_url'
    ));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'prime_home_renovation_image_leftside', array(
        'label'      => __( 'Left Side Image', 'prime-home-renovation' ),
        'description' => __( ' size: 54px x 241px', 'prime-home-renovation' ),
        'section'    => 'featured_slider_info_section',
        'settings'   => 'prime_home_renovation_image_leftside',
)));
    ////////// Button

$wp_customize->add_setting('prime_home_renovation_button1_text', 
    array(
    'default'           => __('Free Consultations', 'prime-home-renovation'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('prime_home_renovation_button1_text', 
    array(
    'label'       => __('Free Consultations Button Text', 'prime-home-renovation'),
    'section'     => 'featured_slider_info_section',   
    'settings'    => 'prime_home_renovation_button1_text',           
    'type'        => 'text'
    )
);
// Button URL
$wp_customize->add_setting( 'prime_home_renovation_button1_url', array(
    'default'           => 'Enter the Button URL',
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control( 'prime_home_renovation_button1_url', array(
    'label'       => __( 'Button URL', 'prime-home-renovation' ),
    'section'     => 'featured_slider_info_section',
    'settings'    => 'prime_home_renovation_button1_url',
    'type'        => 'url',
));
