<?php
/**
 * About Section options.
 *
 * @package prime-home-renovation
 */

$prime_home_renovation_default = prime_home_renovation_get_default_theme_options();


$wp_customize->add_section(
    'featured_services_info_section',
    array(
        'title' => __('Service Info', 'prime-home-renovation'),
        'priority' => 3,
        'panel' => 'prime_home_renovation_section_panel',
    )
);

$prime_home_renovation_defaults = array(
    'enable_featured_services_section' => true,
);
$wp_customize->add_setting(
    'theme_options[enable_featured_services_section]',
    array(
        'default' => $prime_home_renovation_defaults['enable_featured_services_section'],
        'type' => 'theme_mod',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'prime_home_renovation_sanitize_switch'
    )
);


//Background Color
$wp_customize->add_setting(
    'theme_options[featured_services_section_bg_color]',
    array(
        'default' => "#FBFBFB",
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control(new WP_Customize_Color_Control(
    $wp_customize,
    'theme_options[featured_services_section_bg_color]',
    array(
        'label' => __('Section Background Color', 'prime-home-renovation'),
        'section' => 'featured_services_info_section',
        'settings' => 'theme_options[featured_services_section_bg_color]',
    )
));

//Section Background Image
$wp_customize->add_setting('prime_home_renovation_featured_services_img',
array(    
    'sanitize_callback' => 'prime_home_renovation_sanitise_custom_url'
));
$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'prime_home_renovation_featured_services_img', array(
    'label' => __('Section Background Image', 'prime-home-renovation'),
    'section' => 'featured_services_info_section',
    'settings' => 'prime_home_renovation_featured_services_img',
)));

//Opacity  
$wp_customize->add_setting(
    'prime_home_renovation_featured_services_opacity',
    array(
        'default' => 1,
        'sanitize_callback' => 'prime_home_renovation_sanitize_number_range'
    )
);
$wp_customize->add_control(
    'prime_home_renovation_featured_services_opacity',
    array(
        'label' => __('Background Opacity', 'prime-home-renovation'),
        'description' => __('It Will Only apply on Image', 'prime-home-renovation'),
        'section' => 'featured_services_info_section',
        'settings' => 'prime_home_renovation_featured_services_opacity',
        'type' => 'range',
        'input_attrs' => array(
            'min' => 0,
            'max' => 1,
            'step' => 0.1,
        ),

    )
);

// /// effects
$wp_customize->add_setting('prime_home_renovation_featured_services_onload_effects', array(
    'default' => 'zoom-in',
    'sanitize_callback' => 'prime_home_renovation_sanitize_choices',
));
$wp_customize->add_control('prime_home_renovation_featured_services_onload_effects', array(
    'type' => 'select',
    'label' => __('Box Onload Transition Effects', 'prime-home-renovation'),
    'choices' => array(
        'wow bounceInLeft' => __('Bounce In Left', 'prime-home-renovation'),
        'wow bounceInRight' => __('Bounce In Right', 'prime-home-renovation'),
        'wow bounceInUp' => __('Bounce In Up', 'prime-home-renovation'),
        'wow bounceInDown' => __('Bounce In Down', 'prime-home-renovation'),
        'wow zoomIn' => __('Zoom In', 'prime-home-renovation'),
        'wow zoomOut' => __('Zoom Out', 'prime-home-renovation'),
        'wow fadeInDown' => __('Fade In Down', 'prime-home-renovation'),
        'wow fadeInUp' => __('Fade In Up', 'prime-home-renovation'),
        'wow fadeInLeft' => __('Fade In Left', 'prime-home-renovation'),
        'wow fadeInRight' => __('Fade In Right', 'prime-home-renovation'),
        'flip-up' => __('Flip Up', 'prime-home-renovation')
    ),
    'section' => 'featured_services_info_section',
));

// Section Title
$wp_customize->add_setting(
    'theme_options[featured_services_section_maintaitle]',
    array(
        'default' => $prime_home_renovation_default['featured_services_section_maintaitle'],
        'type' => 'theme_mod',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    'theme_options[featured_services_section_maintaitle]',
    array(
        'label' => __('Heading', 'prime-home-renovation'),
        'section' => 'featured_services_info_section',
        'settings' => 'theme_options[featured_services_section_maintaitle]',
        'type' => 'text'
    )
);

// Section Sub-Title
$wp_customize->add_setting(
    'theme_options[featured_services_section_subtitle]',
    array(
        'default' => $prime_home_renovation_default['featured_services_section_subtitle'],
        'type' => 'theme_mod',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    'theme_options[featured_services_section_subtitle]',
    array(
        'label' => __('Sub Heading', 'prime-home-renovation'),
        'section' => 'featured_services_info_section',
        'settings' => 'theme_options[featured_services_section_subtitle]',
        'type' => 'text'
    )
);


$prime_home_renovation_defaults = array(
    'featured_services_column' => '3',
    'number_of_featured_services_items' => 3,
    'featured_services_content_type' => 'featured_services_page',
);

// Column

if (class_exists('WP_Customize_Control') && ! class_exists( 'Prime_Home_Renovation_Radio_Image_Control' ) ) {
	/**
 	* Customize sidebar layout control.
 	*/
	class Prime_Home_Renovation_Radio_Image_Control extends WP_Customize_Control {

		public function render_content() {

			if (empty($this->choices))
				return;

			$name = '_customize-radio-' . $this->id;
			?>
			<span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
			<ul class="controls" id='prime_home_renovation-img-container' style="display: flex;">
				<?php
				foreach ($this->choices as $value => $label) :
					$class = ($this->value() == $value) ? 'prime_home_renovation-radio-img-selected prime_home_renovation-radio-img-img' : 'prime_home_renovation-radio-img-img';
					?>
					<li style="display: inline;">
						<label>
							<input <?php $this->link(); ?>style = 'display:none' type="radio" value="<?php echo esc_attr($value); ?>" name="<?php echo esc_attr($name); ?>" <?php
							  $this->link();
							  checked($this->value(), $value);
							  ?> />
							<img src='<?php echo esc_url($label); ?>' class='<?php echo esc_attr($class); ?>' />
						</label>
					</li>
					<?php
				endforeach;
				?>
			</ul>
			<?php
		}

	}
}


$wp_customize->add_setting(
    'theme_options[featured_services_column]',
    array(
        'default' => $prime_home_renovation_defaults['featured_services_column'],
        'type' => 'theme_mod',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'prime_home_renovation_sanitize_select'
    )
);
$wp_customize->add_control(
    new Prime_Home_Renovation_Radio_Image_Control(
        $wp_customize,
        'theme_options[featured_services_column]',
        array(
            'label' => __('Column', 'prime-home-renovation'),
            'section' => 'featured_services_info_section',
            'settings' => 'theme_options[featured_services_column]',
            'active_callback' => 'prime_home_renovation_featured_services_page',
            'type' 		=> 'radio-image',
           'choices' 	=> array(
    '1' 	=> esc_url(get_template_directory_uri()) . '/assets/images/column-1.jpg',						
    '2' 	=> esc_url(get_template_directory_uri()) . '/assets/images/column-2.jpg',
    '3' 	=> esc_url(get_template_directory_uri()) . '/assets/images/column-3.jpg',
    '4' 	=> esc_url(get_template_directory_uri()) . '/assets/images/column-4.jpg',
    '5' 	=> esc_url(get_template_directory_uri()) . '/assets/images/column-5.jpg',
    '6' 	=> esc_url(get_template_directory_uri()) . '/assets/images/column-6.jpg',
    ),	
        )
    )
);

// // Number of Featured Items
$wp_customize->add_setting('theme_options[number_of_featured_services_items]',
    array(
        'default'           => $prime_home_renovation_defaults['number_of_featured_services_items'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'absint', 
    )
);

$wp_customize->add_control('theme_options[number_of_featured_services_items]',
    array(
        'label'           => __('Number Of Services To Show', 'prime-home-renovation'),
        'section'         => 'featured_services_info_section',
        'settings'        => 'theme_options[number_of_featured_services_items]',
        'type'            => 'number',
        'active_callback' => 'prime_home_renovation_featured_services_page',
        'input_attrs'     => array(
            'min'  => 1,
            'max'  => 6,
            'step' => 1,
        ),
    )
);

// Content Type
$wp_customize->add_setting(
    'theme_options[featured_services_content_type]',
    array(
        'default' => $prime_home_renovation_defaults['featured_services_content_type'],
        'type' => 'theme_mod',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'prime_home_renovation_sanitize_select'
    )
);


$number_of_featured_services_items = prime_home_renovation_get_option('number_of_featured_services_items');

for ($i = 1; $i <= $number_of_featured_services_items; $i++) {
    // Page
    $wp_customize->add_setting(
        'theme_options[featured_services_page_' . $i . ']',
        array(
            'type' => 'theme_mod',
            'capability' => 'edit_theme_options',
            'sanitize_callback' => 'prime_home_renovation_dropdown_pages'
        )
    );

    $wp_customize->add_control(
        'theme_options[featured_services_page_' . $i . ']',
        array(
            'label' => sprintf(__('Select A Service', 'prime-home-renovation'), $i),
            'section' => 'featured_services_info_section',
            'settings' => 'theme_options[featured_services_page_' . $i . ']',
            'type' => 'select',
            'choices' => prime_home_renovation_dropdown_services(),
            'active_callback' => 'prime_home_renovation_featured_services_page',
        )
    );
}



