<?php
/**
 * About Section options.
 *
 * @package prime-home-renovation
 */

$prime_home_renovation_default = prime_home_renovation_get_default_theme_options();

/** About Info section */
$wp_customize->add_section(
    'featured_about_info_section',
    array(
        'title'    => __( 'About Info', 'prime-home-renovation' ),      
        'priority' => 2,
        'panel'      => 'prime_home_renovation_section_panel',       	
    )
);

// Enable Section
$wp_customize->add_setting('enable_featured_about_section', 
	array(
	'default' 			=> $prime_home_renovation_default['enable_featured_about_section'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'prime_home_renovation_sanitize_switch'
	)
);

$wp_customize->add_control('enable_featured_about_section', 
	array(		
	'label' 	=> __('Enable Section', 'prime-home-renovation'),
	'section' 	=> 'featured_about_info_section',
	'settings'  => 'enable_featured_about_section',
	'type' 		=> 'checkbox',	
	)
);

//Section Image
    $wp_customize->add_setting( 'prime_home_renovation_about_image1', array(  
        'sanitize_callback' => 'prime_home_renovation_sanitise_custom_url'
        ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'prime_home_renovation_about_image1', array(
            'label'      => __( 'Section Image', 'prime-home-renovation' ),
            'section'    => 'featured_about_info_section',
            'settings'   => 'prime_home_renovation_about_image1',
    )));
//Opacity  
$wp_customize->add_setting('prime_home_renovation_featured_about_opacity', array(
    'default'           => 0.9,
    'sanitize_callback' => 'prime_home_renovation_sanitize_number_range',
));

$wp_customize->add_control('prime_home_renovation_featured_about_opacity', array(
    'label'       => __('About Section Opacity', 'prime-home-renovation'),
    'description' => __('Adjust the background opacity of the entire About section.', 'prime-home-renovation'),
    'section'     => 'featured_about_info_section',
    'settings'    => 'prime_home_renovation_featured_about_opacity',
    'type'        => 'range',
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 1,
        'step' => 0.1,
    ),
));

$wp_customize->add_setting('prime_home_renovation_featured_about_onload_effects', array(
    'default' => 'wow zoomIn',
    'sanitize_callback' => 'prime_home_renovation_sanitize_choices',
));

$wp_customize->add_control('prime_home_renovation_featured_about_onload_effects', array(
    'label' => __('Box Onload Transition Effects', 'prime-home-renovation'),
    'section' => 'featured_about_info_section',
    'settings' => 'prime_home_renovation_featured_about_onload_effects',
    'type' => 'select',
    'choices' => array(
        'wow bounceInLeft' => __('Bounce In Left', 'prime-home-renovation'),
        'wow bounceInRight' => __('Bounce In Right', 'prime-home-renovation'),
        'wow bounceInUp' => __('Bounce In Up', 'prime-home-renovation'),
        'wow bounceInDown' => __('Bounce In Down', 'prime-home-renovation'),
        'wow zoomIn' => __('Zoom In', 'prime-home-renovation'),
        'wow zoomOut' => __('Zoom Out', 'prime-home-renovation'),
        'wow fadeInDown' => __('Fade In Down', 'prime-home-renovation'),
        'wow fadeInUp' => __('Fade In Up', 'prime-home-renovation'),
        'wow fadeInLeft' => __('Fade In Left', 'prime-home-renovation'),
        'wow fadeInRight' => __('Fade In Right', 'prime-home-renovation'),
        'flip-up' => __('Flip Up', 'prime-home-renovation'),
    ),
));


// Section Title
$wp_customize->add_setting('theme_options[featured_about_section_h2]', 
    array(
        'default'           => $prime_home_renovation_default['featured_about_section_h2'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('theme_options[featured_about_section_h2]', 
    array(
        'label'       => __('Heading', 'prime-home-renovation'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_section_h2]',		
        'type'        => 'text'
    )
);

// // Section Title
$wp_customize->add_setting('theme_options[featured_about_section_h1]', 
	array(
	'default'           => $prime_home_renovation_default['featured_about_section_h1'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_h1]', 
	array(
	'label'       => __('Sub Heading', 'prime-home-renovation'),
	'section'     => 'featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_h1]',		
	'type'        => 'textarea'
	)
);

// // Li Text
$wp_customize->add_setting('theme_options[featured_about_section_li_items1]', 
	array(
	'default'           => $prime_home_renovation_default['featured_about_section_li_items1'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_li_items1]', 
	array(
	'label'       => __('Feature Text 1', 'prime-home-renovation'),
	'section'     => 'featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_li_items1]',		
	'type'        => 'text'
	)
);

$wp_customize->add_setting('theme_options[featured_about_section_li_items2]', 
	array(
	'default'           => $prime_home_renovation_default['featured_about_section_li_items2'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_li_items2]', 
	array(
	'label'       => __('Feature Text 2', 'prime-home-renovation'),
	'section'     => 'featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_li_items2]',		
	'type'        => 'text'
	)
);
$wp_customize->add_setting('theme_options[featured_about_section_li_items3]', 
	array(
	'default'           => $prime_home_renovation_default['featured_about_section_li_items3'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_li_items3]', 
	array(
	'label'       => __('Feature Text 3', 'prime-home-renovation'),
	'section'     => 'featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_li_items3]',		
	'type'        => 'text'
	)
);
$wp_customize->add_setting('theme_options[featured_about_section_li_items4]', 
	array(
	'default'           => $prime_home_renovation_default['featured_about_section_li_items4'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_li_items4]', 
	array(
	'label'       => __('Feature Text 4', 'prime-home-renovation'),
	'section'     => 'featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_li_items4]',		
	'type'        => 'text'
	)
);
$wp_customize->add_setting('theme_options[featured_about_section_li_items5]', 
	array(
	'default'           => $prime_home_renovation_default['featured_about_section_li_items5'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_li_items5]', 
	array(
	'label'       => __('Feature Text 5', 'prime-home-renovation'),
	'section'     => 'featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_li_items5]',		
	'type'        => 'text'
	)
);
$wp_customize->add_setting('theme_options[featured_about_section_li_items6]', 
	array(
	'default'           => $prime_home_renovation_default['featured_about_section_li_items6'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_li_items6]', 
	array(
	'label'       => __('Feature Text 6', 'prime-home-renovation'),
	'section'     => 'featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_li_items6]',		
	'type'        => 'text'
	)
);

// Description
$wp_customize->add_setting('theme_options[featured_about_section_p]', 
	array(
	'default'           => $prime_home_renovation_default['featured_about_section_p'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_p]', 
	array(
	'label'       => __('Description', 'prime-home-renovation'),
	'section'     => 'featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_p]',		
	'type'        => 'textarea'
	)
);


// // main about image
$wp_customize->add_setting( 'prime_home_renovation_about1_image', array(  
'sanitize_callback' => 'prime_home_renovation_sanitise_custom_url'
));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'prime_home_renovation_about1_image', array(
    'label' => __('About Image','prime-home-renovation'),
    'description'   => __( 'Size 350px x 400x', 'prime-home-renovation' ),
    'section' => 'featured_about_info_section',
    'settings'   => 'prime_home_renovation_about1_image',
)));

// //////////////Author Name

$wp_customize->add_setting('theme_options[featured_about_section_name]', 
    array(
        'default'           => $prime_home_renovation_default['featured_about_section_name'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('theme_options[featured_about_section_name]', 
    array(
        'label'       => __('Name', 'prime-home-renovation'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_section_name]',				
        'type'        => 'text'
    )
);

// //////////////Author Text

$wp_customize->add_setting('theme_options[featured_about_section_author]', 
    array(
        'default'           => $prime_home_renovation_default['featured_about_section_author'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('theme_options[featured_about_section_author]', 
    array(
        'label'       => __('Text', 'prime-home-renovation'),
        'section'     => 'featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_section_author]',				
        'type'        => 'text'
    )
);

