<?php
/**
 * Default theme options.
 *
 * @package prime-home-renovation
 */

if ( ! function_exists( 'prime_home_renovation_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
function prime_home_renovation_get_default_theme_options() {

	$prime_home_renovation_defaults = array();
	

    // Front Page Content
	$prime_home_renovation_defaults['enable_frontpage_content'] 		= true;

	// Slider Section	
	$prime_home_renovation_defaults['enable_featured_slider_section']		    	= true;
	//$prime_home_renovation_defaults['show_slider_colors']		    			= false;	
	$prime_home_renovation_defaults['featured_slider_content_type']		    	= 'featured_slider_page';
	$prime_home_renovation_defaults['featured_slider_category_readmore_text']		= esc_html__('Read More','prime-home-renovation');
	$prime_home_renovation_defaults['data_slick_speed']					    	= 1000;
	$prime_home_renovation_defaults['data_slick_infinite']				    	= 1;
	$prime_home_renovation_defaults['data_slick_dots']					    	= 1;
	$prime_home_renovation_defaults['data_slick_autoplay']				    	= 1;
	$prime_home_renovation_defaults['data_slick_draggable']				    	= 1;
	$prime_home_renovation_defaults['data_slick_fade']					    	= 1;
	$prime_home_renovation_defaults['number_of_featured_slider_items']	    	= 6;

	// Features Section
	$prime_home_renovation_defaults['enable_featured_features_section']			= true;
	//$prime_home_renovation_defaults['show_feature_colors']						= false;
	$prime_home_renovation_defaults['number_of_featured_features_items']			= 6;
	$prime_home_renovation_defaults['featured_features_column']					= 3;
	$prime_home_renovation_defaults['featured_features_content_type']				= 'featured_features_page';
	$prime_home_renovation_defaults['feture_section_excerpt']						= 25;
	

	// About Section	
	$prime_home_renovation_defaults['enable_featured_about_section']						= true;
    $prime_home_renovation_defaults['about_image_show'] 									= true;
	$prime_home_renovation_defaults['featured_about_section_h2']							= esc_html__('Building company', 'prime-home-renovation' );
	$prime_home_renovation_defaults['featured_about_section_h1']							= esc_html__('Over 15 Years Experience In Industry', 'prime-home-renovation' );
	$prime_home_renovation_defaults['featured_about_section_li_items1']					= esc_html__('Eco-Friendly Material', 'prime-home-renovation' );
	$prime_home_renovation_defaults['featured_about_section_li_items2'] 					= esc_html__('Natural Insulation', 'prime-home-renovation' );
	$prime_home_renovation_defaults['featured_about_section_li_items3'] 					= esc_html__('Long-Lasting Durability', 'prime-home-renovation' );
	$prime_home_renovation_defaults['featured_about_section_li_items4'] 					= esc_html__('Fast Construction', 'prime-home-renovation' );
	$prime_home_renovation_defaults['featured_about_section_li_items5']					= esc_html__('Eco-Friendly Material', 'prime-home-renovation' );
	$prime_home_renovation_defaults['featured_about_section_li_items6']					= esc_html__('Natural Insulation', 'prime-home-renovation' );
	$prime_home_renovation_defaults['featured_about_section_p']							= esc_html__( "There are many variations of passages of Lorem Ipsum available majority have suffered alteration in some form, by injected humour, or randomised words which don't look even middle of text.", 'prime-home-renovation' );
	$prime_home_renovation_defaults['featured_about_section_name']						= esc_html__( "Emma Mark", 'prime-home-renovation' );
	$prime_home_renovation_defaults['featured_about_section_author']						= esc_html__( "- Autoher", 'prime-home-renovation' );


	// service Section	

	// $prime_home_renovation_defaults = array(
	// 	'featured_services_column'           => '3',
	// 	'number_of_featured_services_items'  => 3,
	// 	'featured_services_content_type'     => 'featured_services_page',
	// );
	$prime_home_renovation_defaults['enable_featured_services_section']			= true;
	$prime_home_renovation_defaults['enable_featured_service_flower_image']		= true;
	$prime_home_renovation_defaults['featured_services_section_maintaitle']	    = esc_html__( 'Our Services', 'prime-home-renovation' );
	$prime_home_renovation_defaults['featured_services_section_subtitle']	    	= esc_html__( 'We Provide Our Services All Over The World', 'prime-home-renovation' );
	$prime_home_renovation_defaults['prime_home_renovation_service_text']	    	= esc_html__( 'View Details', 'prime-home-renovation' );
	$prime_home_renovation_defaults['services_excerpt_mainpagelength']			= 11;




	// Inner Blog Page	
	$prime_home_renovation_defaults['featured_bloginn_botton_text']				= esc_html__( 'Read More', 'prime-home-renovation' );

	return $prime_home_renovation_defaults;

}

endif;

/**
*  Get theme options
*/
if ( ! function_exists( 'prime_home_renovation_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function prime_home_renovation_get_option( $key ) {

		$default_options = prime_home_renovation_get_default_theme_options();
		if ( empty( $key ) ) {
			return;
		}

		$theme_options = (array)get_theme_mod( 'theme_options' );
		$theme_options = wp_parse_args( $theme_options, $default_options );

		$value = null;

		if ( isset( $theme_options[ $key ] ) ) {
			$value = $theme_options[ $key ];
		}

		return $value;

	}

endif;
