<?php
/**
 * Active callback functions.
 *
 * @package prime-home-renovation
 */

function prime_home_renovation_featured_slider_active( $control ) {
    if( $control->manager->get_setting( 'slider_enable_section' )->value() == true ) {
        return true;
    }else{
        return false;
    }
}
function prime_home_renovation_featured_slider_page( $control ) {
    $content_type = $control->manager->get_setting( 'theme_options[featured_slider_content_type]' )->value();
    return ( prime_home_renovation_featured_slider_active( $control ) && ( 'featured_slider_page' == $content_type ) );
}

//  About

function prime_home_renovation_featured_about_active( $control ) {
    if( $control->manager->get_setting( 'theme_options[enable_featured_about_section]' )->value() == true ) {
        return true;
    }else{
        return false;
    }
}
function prime_home_renovation_featured_about_page( $control ) {
    $content_type = $control->manager->get_setting( 'theme_options[featured_about_content_type]' )->value();
    return ( prime_home_renovation_featured_about_active( $control ) && ( 'featured_about_page' == $content_type ) );
}
function prime_home_renovation_featured_services_active( $control ) {
    if( $control->manager->get_setting( 'theme_options[enable_featured_services_section]' )->value() == true ) {
        return true;
    }else{
        return false;
    }
}
function prime_home_renovation_featured_services_page( $control ) {
    $content_type = $control->manager->get_setting( 'theme_options[featured_services_content_type]' )->value();
    return ( prime_home_renovation_featured_services_active( $control ) && ( 'featured_services_page' == $content_type ) );
}

function prime_home_renovation_featured_services_post() {
    return is_single(); // Checks if the current view is a single post
}



/**
 * Active Callback for top bar section
 */
function prime_home_renovation_contact_info_ac( $control ) {

    $show_contact_info = $control->manager->get_setting( 'theme_options[show_header_contact_info]')->value();
    $control_id        = $control->id;
         
    if ( $control_id == 'theme_options[header_location]' && $show_contact_info ) return true;
    if ( $control_id == 'theme_options[header_email]' && $show_contact_info ) return true;
    if ( $control_id == 'theme_options[header_phone]' && $show_contact_info ) return true;
    if ( $control_id == 'theme_options[hphone_text]' && $show_contact_info ) return true;

    return false;
}

function prime_home_renovation_social_links_active( $control ) {
    if( $control->manager->get_setting( 'theme_options[show_header_social_links]' )->value() == true ) {
        return true;
    }else{
        return false;
    }
}
