<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package prime-home-renovation
 */

?>

<footer id="colophon" class="site-footer">
    <div class="footer-widgets-area mt-4 container">
        <?php 
    $footer_sidebar_data = prime_home_renovation_footer_sidebar_class();
    $footer_sidebar = $footer_sidebar_data['active_sidebar'];
    $footer_class = $footer_sidebar_data['class'];

    if ( ! empty( $footer_sidebar ) ) : ?>
        <div class="<?php echo esc_attr( $footer_class ); ?>">
            <?php foreach ( $footer_sidebar as $sidebar ) : ?>
            <div class="hentry">
                <?php dynamic_sidebar( $sidebar ); ?>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>

        <div class="site-info mt-4">
            <a href="<?php echo esc_url( __( 'https://wordpress.org/', 'prime-home-renovation' ) ); ?>">
                <?php
							
							printf( esc_html__( 'Proudly powered by %s', 'prime-home-renovation' ), 'WordPress' );
							?>
            </a>
            <span class="sep"> | </span>
            <?php
            
              printf(
                  esc_html__('Theme: %1$s by %2$s.', 'prime-home-renovation'),
                  esc_html(get_theme_mod('prime_home_renovation_foot_themename', 'Prime Home Renovation')),
                  esc_html(get_theme_mod('prime_home_renovation_foot_themeauthor', 'Webnotick'))
              );
							?>
        </div><!-- .site-info -->
    </div>

    <!-- Scroll to Top Button -->
    <?php if(get_theme_mod('featured_scrooltopbtn_on_off',true) == true ){  ?>
    <div class="scroll-to-top">
        <a href="#" id="scroll-to-top"><i class="fas fa-caret-up"></i></a>
    </div>
    <?php } ?>
</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>