<?php
/**
 * Settings for theme wizard
 *
 * @package Whizzie_Child
 * @author Catapult Themes
 * @since 1.0.0
 */

/**
 * Define constants
 **/
if ( ! defined( 'WHIZZIE_CHILD_DIR' ) ) {
	define( 'WHIZZIE_CHILD_DIR', dirname( __FILE__ ) );
}
// Load the Whizzie_Child class and other dependencies
require trailingslashit( WHIZZIE_CHILD_DIR ) . 'whizzie.php';
// Gets the theme object
$current_theme = wp_get_theme();
$theme_title = $current_theme->get( 'Name' );


/**
 * Make changes below
 **/

// Change the title and slug of your wizard page
$config['page_slug'] 	= 'prime-charity-trust';
$config['page_title']	= 'TI Setup Wizard';

// You can remove elements here as required
// Don't rename the IDs - nothing will break but your changes won't get carried through
$config['steps'] = array(
	'intro' => array(
		'id'			=> 'intro', // ID for section - don't rename
		'title'			=> __( 'Welcome to ', 'prime-charity-trust' ) . $theme_title, // Section title
		'icon'			=> 'dashboard', // Uses Dashicons
		'button_text'	=> __( 'Start Now', 'prime-charity-trust' ), // Button text
		'can_skip'		=> false // Show a skip button?
	),
	'plugins' => array(
		'id'			=> 'plugins',
		'title'			=> __( 'Plugins', 'prime-charity-trust' ),
		'icon'			=> 'admin-plugins',
		'button_text'	=> __( 'Install Plugins', 'prime-charity-trust' ),
		'can_skip'		=> false
	),
	'widgets' => array(
		'id'			=> 'widgets',
		'title'			=> __( 'Demo Importer', 'prime-charity-trust' ),
		'icon'			=> 'welcome-widgets-menus',
		'button_text'	=> __( 'Import Demo', 'prime-charity-trust' ),
		'can_skip'		=> false
	),
	'done' => array(
		'id'			=> 'done',
		'title'			=> __( 'All Done', 'prime-charity-trust' ),
		'icon'			=> 'yes',
	)
);

/**
 * This kicks off the wizard
 **/
if( class_exists( 'Whizzie_Child' ) ) {
	$Whizzie_Child = new Whizzie_Child( $config );
}
