<?php 
/**
 * Template part for displaying Featured Mission Section
 *
 * @package Prime Fundraiser
 */
    $prime_fundraiser_featured_mission_section_title      = prime_fundraiser_get_option( 'featured_mission_section_title');
    $prime_fundraiser_number_of_featured_mission_items     = prime_fundraiser_get_option( 'number_of_featured_mission_items');

    if( !empty($prime_fundraiser_featured_mission_section_title) ): ?>
    <div class="section-title">
        <h4><?php echo esc_html($prime_fundraiser_featured_mission_section_title); ?></h4>
    </div>
    <?php endif; 

    for( $i=1; $i<=$prime_fundraiser_number_of_featured_mission_items; $i++ ) :
        $prime_fundraiser_featured_mission_posts[] = prime_fundraiser_get_option( 'featured_mission_post_'.$i );
    endfor; ?>

    <div id="mission-section" class="section-content">
        <div class="tabs">
            <ul class="tabs-nav">
                <?php for( $i=1; $i<=$prime_fundraiser_number_of_featured_mission_items; $i++ ) : ?>
                    <li class="tabs-nav-box"><a href="<?php echo('#tab-').$i ?>"><?php if( !empty( prime_fundraiser_get_option( 'featured_mission_section_tab_icon_'.$i ) ) ): ?><i class="<?php echo esc_html( prime_fundraiser_get_option( 'featured_mission_section_tab_icon_'.$i ) ); ?>"></i><?php endif; ?><?php echo esc_html( prime_fundraiser_get_option( 'featured_mission_section_tab_'.$i ) ); ?></a></li>
                <?php endfor; ?> 
            </ul>
            <?php $args = array (
                'post_type'     => 'page',
                'posts_per_page' => absint( $prime_fundraiser_number_of_featured_mission_items ),
                'post__in'      => $prime_fundraiser_featured_mission_posts,
                'orderby'       =>'post__in',
                'ignore_sticky_posts' => true,
            );?>
            <?php
            $loop = new WP_Query($args);
            if ( $loop->have_posts() ) :
            $i=0; $j=0; 
                while ($loop->have_posts()) : $loop->the_post(); $i++; $j++; ?>
                <article style="padding: 0 15px;">
                    <div class="tabs-stage">
                        <div id="<?php echo('tab-').$i ?>" class="featured-mission-box">
                            <div class="featured-mission-item">
                                <div class="content-image">
                                    <?php if (has_post_thumbnail( $post->ID ) ): ?>
                                    <div class="image-container">
                                        <?php the_post_thumbnail(); ?>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <div class="content-details">
                                    <header class="entry-header">
                                        <h2 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
                                    </header>
                                    <div class="entry-content">
                                        <?php
                                            $excerpt = prime_charity_trust_the_excerpt( 70 );
                                            echo wp_kses_post( wpautop( $excerpt ) );
                                        ?>
                                    </div><!-- .entry-content -->
                                    
                                    <div class="button-content">
                                        <a href="<?php the_permalink(); ?>" class="btn">
                                            <?php esc_html_e('Know More','prime-fundraiser'); ?> <i class="fas fa-arrow-right"></i>
                                        </a>
                                    </div><!-- .button-content -->
                                </div>
                            </div><!-- .featured-mission-item -->
                        </div>
                    </div>
                </article>
            <?php endwhile; ?>
            <?php endif; ?>
            <?php wp_reset_postdata(); ?>
        </div>
    </div><!-- .section-content -->