<?php
/**
 * Mission Section options.
 *
 * @package Prime Fundraiser
 */

$default = prime_fundraiser_get_default_theme_options();

// Mission Section
$wp_customize->add_section( 'section_featured_mission',
	array(
	'title'      => __( 'Mission Section', 'prime-fundraiser' ),
	'priority'   => 110,
	'capability' => 'edit_theme_options',
	'panel'      => 'home_page_panel',
	)
);

// Enable Section
$wp_customize->add_setting('theme_options[enable_featured_mission_section]', 
	array(
	'default' 			=> $default['enable_featured_mission_section'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'prime_charity_trust_sanitize_checkbox'
	)
);

$wp_customize->add_control('theme_options[enable_featured_mission_section]', 
	array(		
	'label' 	=> __('Enable Section', 'prime-fundraiser'),
	'section' 	=> 'section_featured_mission',
	'settings'  => 'theme_options[enable_featured_mission_section]',
	'type' 		=> 'checkbox',	
	)
);
// Section Title
$wp_customize->add_setting('theme_options[featured_mission_section_title]', 
	array(
	'default'           => $default['featured_mission_section_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[featured_mission_section_title]', 
	array(
	'label'       => __('Section Title', 'prime-fundraiser'),
	'section'     => 'section_featured_mission',   
	'settings'    => 'theme_options[featured_mission_section_title]',
	'active_callback' => 'prime_fundraiser_featured_mission_active',
	'type'        => 'text'
	)
);

// Items
$wp_customize->add_setting('theme_options[number_of_featured_mission_items]', 
	array(
	'default' 			=> $default['number_of_featured_mission_items'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'prime_charity_trust_sanitize_number_range'
	)
);

$wp_customize->add_control('theme_options[number_of_featured_mission_items]', 
	array(
	'label'       => __('Items (Max: 5)', 'prime-fundraiser'),
	'section'     => 'section_featured_mission',   
	'settings'    => 'theme_options[number_of_featured_mission_items]',
	'type'        => 'number',
	'active_callback' => 'prime_fundraiser_featured_mission_active',
	'input_attrs' => array(
			'min'	=> 1,
			'max'	=> 5,
			'step'	=> 1,
		),
	)
);

$prime_fundraiser_number_of_featured_mission_items = prime_fundraiser_get_option( 'number_of_featured_mission_items' );

for( $i=1; $i<=$prime_fundraiser_number_of_featured_mission_items; $i++ ) {

	// Section Tab
	$wp_customize->add_setting('theme_options[featured_mission_section_tab_'.$i.']', 
		array(	
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field'
		)
	);

	$wp_customize->add_control('theme_options[featured_mission_section_tab_'.$i.']', 
		array(
		'label'       => __('Tab #', 'prime-fundraiser').$i,
		'section'     => 'section_featured_mission',
		'settings'    => 'theme_options[featured_mission_section_tab_'.$i.']',
		'active_callback' => 'prime_fundraiser_featured_mission_active',
		'type'        => 'text'
		)
	);

	// Section Tab Icon
	$wp_customize->add_setting('theme_options[featured_mission_section_tab_icon_'.$i.']', 
		array(	
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'sanitize_text_field'
		)
	);

	$wp_customize->add_control('theme_options[featured_mission_section_tab_icon_'.$i.']', 
		array(
		'label'       => __('Tab Icon #', 'prime-fundraiser').$i,
		'section'     => 'section_featured_mission',
		'settings'    => 'theme_options[featured_mission_section_tab_icon_'.$i.']',
		'active_callback' => 'prime_fundraiser_featured_mission_active',
		'type'        => 'text'
		)
	);

	// Post
	$wp_customize->add_setting('theme_options[featured_mission_post_'.$i.']', 
		array(
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'prime_charity_trust_dropdown_pages'
		)
	);

	$wp_customize->add_control('theme_options[featured_mission_post_'.$i.']', 
		array(
		'label'       => __('Post #', 'prime-fundraiser').$i,
		'section'     => 'section_featured_mission',   
		'settings'    => 'theme_options[featured_mission_post_'.$i.']',
		'type'        => 'dropdown-pages',
		'active_callback' => 'prime_fundraiser_featured_mission_active',
		)
	);
}