<?php

function prime_fundraiser_template_setup() {

if ( ! defined( 'PRIME_CHARITY_TRUST_FOOTER_URL' ) ) {
  define( 'PRIME_CHARITY_TRUST_FOOTER_URL', esc_url( 'https://themeignite.com/products/free-fundraiser-wordpress-theme', 'prime-fundraiser') );
}
if ( ! defined( 'PRIME_CHARITY_TRUST_URL' ) ) {
    define( 'PRIME_CHARITY_TRUST_URL', esc_url( 'https://themeignite.com/products/fundraiser-wordpress-theme', 'prime-fundraiser') );
}
if ( ! defined( 'PRIME_CHARITY_TRUST_TEXT' ) ) {
    define( 'PRIME_CHARITY_TRUST_TEXT', __( 'Prime Fundraiser PRO','prime-fundraiser' ));
}
if ( ! defined( 'PRIME_CHARITY_TRUST_FREE_DOC_URL' ) ) {
    define( 'PRIME_CHARITY_TRUST_FREE_DOC_URL', esc_url( 'https://demo.themeignite.com/documentation/prime-fundraiser-free
', 'prime-fundraiser') );
}
if ( ! defined( 'PRIME_CHARITY_TRUST_PRO_DOC_URL' ) ) {
    define( 'PRIME_CHARITY_TRUST_PRO_DOC_URL', esc_url( 'https://demo.themeignite.com/documentation/prime-fundraiser
', 'prime-fundraiser') );
}
if ( ! defined( 'PRIME_CHARITY_TRUST_DEMO_URL' ) ) {
    define( 'PRIME_CHARITY_TRUST_DEMO_URL', esc_url( 'https://demo.themeignite.com/fundraiser-wordpress-theme', 'prime-fundraiser') );
}
if ( ! defined( 'PRIME_CHARITY_TRUST_REVIEW_URL' ) ) {
    define( 'PRIME_CHARITY_TRUST_REVIEW_URL', esc_url( 'https://wordpress.org/support/theme/prime-fundraiser/reviews/#new-post', 'prime-fundraiser') );
}
if ( ! defined( 'PRIME_CHARITY_TRUST_SUPPORT_URL' ) ) {
    define( 'PRIME_CHARITY_TRUST_SUPPORT_URL', esc_url( 'https://wordpress.org/support/theme/prime-fundraiser', 'prime-fundraiser') );
}
/**
 * Setup Wizard
 */
if (is_child_theme() && wp_get_theme()->get('Name') === 'Prime Fundraiser') {
    require get_theme_file_path() . '/theme-wizard/config.php';
}
}
add_action( 'after_setup_theme', 'prime_fundraiser_after_setup_theme' );
function prime_fundraiser_after_setup_theme() {
    add_theme_support( 'title-tag' );
    add_theme_support( 'automatic-feed-links' );
    add_theme_support( "responsive-embeds" );
    add_theme_support( 'align-wide' );
    add_theme_support( 'post-thumbnails' );
    add_image_size( 'prime-fundraiser-featured-image', 2000, 1200, true );
    add_image_size( 'prime-fundraiser-thumbnail-avatar', 100, 100, true );

    // Set the default content width.
    $GLOBALS['content_width'] = 525;

    // Add theme support for Custom Logo.
    add_theme_support( 'custom-logo' , array(
        'height'        =>45,
        'width'         =>45,
        'flex-height'   =>true, 
        'flex-width'    =>true,
    ));

    add_theme_support( 'custom-background', array(
        'default-color' => 'ffffff'
    ) );

    add_theme_support( 'html5', array('comment-form','comment-list','gallery','caption',) );

    add_editor_style( array( 'assets/css/editor-style.css') );
}

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function prime_fundraiser_widgets_init() {
    register_sidebar( array(
        'name'          => esc_html__( 'Sidebar', 'prime-fundraiser' ),
        'id'            => 'sidebar-1',
        'description'   => esc_html__( 'Add widgets here.', 'prime-fundraiser' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
        register_sidebar( array(
        'name'          => esc_html__( 'Footer 1', 'prime-fundraiser' ),
        'id'            => 'footer-1',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer 2', 'prime-fundraiser' ),
        'id'            => 'footer-2',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer 3', 'prime-fundraiser' ),
        'id'            => 'footer-3',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer 4', 'prime-fundraiser' ),
        'id'            => 'footer-4',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ) );
}
add_action( 'widgets_init', 'prime_fundraiser_widgets_init' );

// enqueue styles for child theme
function prime_fundraiser_enqueue_styles() {
    // enqueue parent styles
    wp_enqueue_style('prime-charity-trust-style', get_template_directory_uri() .'/style.css');
    
    // enqueue child styles
    wp_enqueue_style('prime-fundraiser-child-style', get_stylesheet_directory_uri() .'/style.css', array('prime-charity-trust-style'));

    wp_enqueue_script( 'comment-reply', '/wp-includes/js/comment-reply.min.js', array(), false, true );

    wp_enqueue_script( 'theme-script-js', get_stylesheet_directory_uri(). '/assets/js/theme-script.js', array('jquery') ,'',true);
}
add_action('wp_enqueue_scripts', 'prime_fundraiser_enqueue_styles');

function prime_fundraiser_customize_register( $wp_customize ) {    

    // Load home page sections option.
    include get_stylesheet_directory() . '/inc/customizer/home-sections/featured-mission.php';
}
add_action( 'customize_register', 'prime_fundraiser_customize_register' );

if ( ! function_exists( 'prime_fundraiser_get_default_theme_options' ) ) :

    /**
     * Get default theme options.
     *
     * @since 1.0.0
     *
     * @return array Default theme options.
     */
function prime_fundraiser_get_default_theme_options() {

    $prime_fundraiser_defaults = array();

    // Mission Section  
    $prime_fundraiser_defaults['enable_featured_mission_section']            = true;
    $prime_fundraiser_defaults['number_of_featured_mission_items']           = 5;
    $prime_fundraiser_defaults['featured_mission_section_title'] = esc_html__( 'Our Mission', 'prime-fundraiser' );
    return $prime_fundraiser_defaults;
}

endif;

/**
*  Get theme options
*/
if ( ! function_exists( 'prime_fundraiser_get_option' ) ) :

    /**
     * Get theme option
     *
     * @since 1.0.0
     *
     * @param string $key Option key.
     * @return mixed Option value.
     */
    function prime_fundraiser_get_option( $key ) {

        $prime_fundraiser_default_options = prime_fundraiser_get_default_theme_options();
        if ( empty( $key ) ) {
            return;
        }

        $prime_fundraiser_theme_options = (array)get_theme_mod( 'theme_options' );
        $prime_fundraiser_theme_options = wp_parse_args( $prime_fundraiser_theme_options, $prime_fundraiser_default_options );

        $value = null;

        if ( isset( $prime_fundraiser_theme_options[ $key ] ) ) {
            $value = $prime_fundraiser_theme_options[ $key ];
        }

        return $value;

    }

endif;

function prime_fundraiser_featured_mission_active( $control ) {
    if( $control->manager->get_setting( 'theme_options[enable_featured_mission_section]' )->value() == true ) {
        return true;
    }else{
        return false;
    }
}

if ( ! function_exists( 'prime_fundraiser_dropdown_pages' ) ) :
    function prime_fundraiser_dropdown_pages( $page_id, $setting ) {
      // Ensure $input is an absolute integer.
      $page_id = absint( $page_id );
      
      // If $page_id is an ID of a published page, return it; otherwise, return the default.
      return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
    }
endif;

/**
 * Display the admin notice unless dismissed.
 */
// Remove parent notice
add_action( 'admin_init', function() {
    remove_action( 'admin_notices', 'prime_charity_trust_dashboard_notice' );
}, 100 );

// Add child notice
function prime_charity_trust_dashboard_notice_child() {
    $dismissed = get_user_meta( get_current_user_id(), 'prime_charity_trust_dismissable_notice', true );

    if ( ! $dismissed ) {
        $theme_name = wp_get_theme()->get( 'Name' );
        ?>
        <div class="updated notice notice-success is-dismissible notice-get-started-class" data-notice="get-start">
            <div class="notice-details">
                <div class="notice-content">
                    <h2>
                        <?php printf(
                            esc_html__( 'Thank you for installing %s.', 'prime-charity-trust' ),
                            '<strong>' . esc_html( $theme_name ) . '</strong>'
                        ); ?>
                    </h2>
                    <p><?php echo esc_html__( 'Your journey to a powerful and stylish website begins here. Let’s get everything set up in just a few clicks!', 'prime-charity-trust' ); ?></p>
                    <div class="notice-btns" style="padding-bottom: 25px">
                        <a class="button button-primary getstart"
                           href="<?php echo esc_url( admin_url( 'themes.php?page=prime-charity-trust' ) ); ?>">
                           <?php esc_html_e( 'Getting Started', 'prime-charity-trust' ); ?>
                        </a>
                        <a class="button button-primary import"
                           href="<?php echo esc_url(admin_url('themes.php?page=primefundraiser-wizard')); ?>">
                           <?php esc_html_e('Demo Importer', 'prime-charity-trust') ?>
                        </a>
                       	<a class="button button-primary premium" target="_blank" href="<?php echo esc_url(PRIME_CHARITY_TRUST_URL); ?>"><?php esc_html_e('Go To Premium', 'prime-charity-trust') ?></a>
						<a class="button button-primary demo" target="_blank" href="<?php echo esc_url(PRIME_CHARITY_TRUST_DEMO_URL); ?>"><?php esc_html_e('View Demo', 'prime-charity-trust') ?></a>
                    </div>
                </div>
                <div class="notice-img">
                    <a href="<?php echo esc_url( PRIME_CHARITY_TRUST_BUNDLE_URL ); ?>" target="_blank"><img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/notice.png' ); ?>"></a>
                </div>
            </div>
        </div>
        <?php
    }
}
add_action( 'admin_notices', 'prime_charity_trust_dashboard_notice_child' );