<?php
/**
 * The template for displaying home page.
 * @package Prime Fundraiser
 */

if ( 'posts' != get_option( 'show_on_front' ) ) { 
    get_header(); ?>
    <?php $prime_charity_trust_enabled_sections = prime_charity_trust_get_sections();

    $prime_charity_trust_new_section = array('id' => 'featured-mission', 'menu_text' => '');
    array_push($prime_charity_trust_enabled_sections, $prime_charity_trust_new_section);
    if( is_array( $prime_charity_trust_enabled_sections ) ) { ?>
        <div id="content" class="site-content">
            <?php foreach( $prime_charity_trust_enabled_sections as $section ) {

                if( $section['id'] == 'featured-slider' ) { ?>
                    <?php $enable_featured_slider_section = prime_charity_trust_get_option( 'enable_featured_slider_section' );
                    if(true ==$enable_featured_slider_section): ?>
                        <section id="<?php echo esc_attr( $section['id'] ); ?>">  
                            <?php get_template_part( 'sections/section', esc_attr( $section['id'] ) ); ?>
                        </section>
                    <?php endif; ?>

                <?php } 
                
            } ?> 
            <?php foreach( $prime_charity_trust_enabled_sections as $section ) {

                if( $section['id'] == 'featured-cause' ) { ?>
                    <?php $enable_featured_services_section = prime_charity_trust_get_option( 'enable_featured_services_section' );
                    if(true ==$enable_featured_services_section): ?>
                        <section id="<?php echo esc_attr( $section['id'] ); ?>" class="section-gap">  
                            <div class="wrapper">
                                <?php get_template_part( 'sections/section', esc_attr( $section['id'] ) ); ?>
                            </div>
                        </section>
                    <?php endif; ?>
            
                <?php }
                
            } ?>
            <?php foreach( $prime_charity_trust_enabled_sections as $section ) {
                if( $section['id'] == 'featured-mission' ) { ?>
                    <?php $enable_featured_mission_section = prime_fundraiser_get_option( 'enable_featured_mission_section' );
                    if(true ==$enable_featured_mission_section): ?>
                        <section id="<?php echo esc_attr( $section['id'] ); ?>" class="section-gap">  
                            <div class="wrapper">
                                <?php get_template_part( 'sections/section', esc_attr( $section['id'] ) ); ?>
                            </div>
                        </section>
                    <?php endif; ?>
            
                <?php }
                
            } ?>
        </div> 
    <?php }
    if( true == prime_charity_trust_get_option('enable_frontpage_content') ) { ?>
        <div id="content" class="wrapper section-gap extra-content">
            <?php include( get_page_template() ); ?>
        </div>
    <?php }
    get_footer();
} 
elseif ('posts' == get_option( 'show_on_front' ) ) {
    include( get_home_template() );
} 