<?php 
/**
 * Template part for displaying Featured Classes Section
 *
 * @package Prime Events
 */

$prime_events_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('prime_events_student_category'),
); 
$prime_events_classes = get_theme_mod( 'prime_events_classes_setting',false );
$prime_events_section_title = get_theme_mod( 'prime_events_section_title' );
$prime_events_section_text = get_theme_mod( 'prime_events_section_text' );
?>
<?php if ( $prime_events_classes ){?>
<div class="our-classes">
    <div class="container">
        <?php if ( $prime_events_section_title ){?>
            <h3 class="mb-0"><?php echo esc_html( $prime_events_section_title );?></h3>
        <?php } ?>
        <?php if ( $prime_events_section_text ){?>
            <p class="main-text"><?php echo esc_html( $prime_events_section_text );?></p>
        <?php } ?>
        <div class="owl-carousel">
                <?php 
                    $catergory_name = get_theme_mod('prime_events_trending_post_slider_args_');
                    $args = array(
                        'post_type'           => 'post',
                        'category_name'       => $catergory_name,
                        'orderby'             => 'post__in',
                        'ignore_sticky_posts' => true,
                    );?>
                    <?php
                    $loop = new WP_Query($args);
                    if ( $loop->have_posts() ) :
                        $i=1;
                        while ($loop->have_posts()) : $loop->the_post(); ?>
                            <div class="pro-box align-self-center px-0">
                                <div class="box">
                                    <?php
                                        if ( has_post_thumbnail() ) : ?>
                                            <div class="image-blog">
                                          <?php the_post_thumbnail();?>
                                          <?php $prime_events_post_dates = get_theme_mod( 'prime_events_post_dates' .$i,);
                                        if ( $prime_events_post_dates ){?>
                                            <p class="post-time"><?php echo esc_html( $prime_events_post_dates );?></p>
                                        <?php } ?>
                                          </div>
                                        <?php else:
                                          ?>
                                          <div class="image-blog">
                                            <img src="<?php echo get_stylesheet_directory_uri() . '/images/default-header.png'; ?>">
                                            <?php $prime_events_post_dates = get_theme_mod( 'prime_events_post_dates' .$i,);
                                        if ( $prime_events_post_dates ){?>
                                            <p class="post-time"><?php echo esc_html( $prime_events_post_dates );?></p>
                                        <?php } ?>
                                          </div>
                                          <?php
                                        endif;
                                      ?>
                                    <div class="box-content text-center">
                                        <h4 class="title mb-2">
                                            <a href="<?php the_permalink();?>"><?php the_title();?></a>
                                        </h4>
                                        <div class="blog-text"><p class="mb-0"><?php echo wp_trim_words( get_the_content(), 9 ); ?></p></div>
                                    </div>
                                </div>
                            </div>
                        <?php $i++; endwhile;
                    endif;
                ?>
            </div>
    </div>
</div>
<?php } ?>