<?php
/**
 * Banner Section
 * 
 * @package prime_events
 */
$prime_events_slider = get_theme_mod( 'prime_events_slider_setting',true );
$prime_events_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('prime_events_blog_slide_category'),
  'posts_per_page' => 3,
); ?>

<?php if ( $prime_events_slider ){?>
  <div class="banner">
    <div class="owl-carousel">
      <?php $prime_events_arr_posts = new WP_Query( $prime_events_args );
      if ( $prime_events_arr_posts->have_posts() ) :
        while ( $prime_events_arr_posts->have_posts() ) :
          $prime_events_arr_posts->the_post();
          ?>
          <div class="row">
            <div class="col-xl-8 col-lg-8 col-md-8 col-sm-12 col-12">
              <div class="banner_box">
                <?php if ( get_theme_mod('prime_events_slider_text_extra') ) : ?>
                  <h5><?php echo esc_html(get_theme_mod('prime_events_slider_text_extra'));?></h5>
                <?php endif; ?>
                <h3 class="my-3"><?php the_title(); ?></a></h3>
                <p class="mb-0"><?php echo wp_trim_words( get_the_content(), 45 ); ?></p>
                <p class="btn-green mt-4">
                  <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('Read More','prime-events'); ?></a>
                </p>
              </div>
               <?php if ( get_theme_mod('prime_events_slider_side_text') ) : ?>
                  <h6 class="side-event"><?php echo esc_html(get_theme_mod('prime_events_slider_side_text'));?></h6>
                <?php endif; ?>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
               <div class="banner_inner_box">
                  <?php
                    if ( has_post_thumbnail() ) :
                      the_post_thumbnail();
                    else:?>
                      <div class="banner_inner_box">
                        <img src="<?php echo get_stylesheet_directory_uri() . '/images/default-header.png'; ?>">
                      </div>
                      <?php endif; ?>
                </div>
            </div>
          </div>
        <?php
      endwhile;
      wp_reset_postdata();
      endif; ?>
    </div>
  </div>
<?php } ?>