<?php

function prime_events_sanitize_checkbox( $checked ) {
    return ( ( isset( $checked ) && true === $checked ) ? true : false );
}

/*------------------------------------------------------------------------*/

// Sanitize Font Weight
function prime_events_sanitize_font_weight( $value ) {
    $valid = array( '100', '200', '300', '400', '500', '600', '700', '800', '900', 'bold' );
    return in_array( $value, $valid ) ? $value : '400';
}

/*------------------------------------------------------------------------*/

// Sanitize Text Transform
function prime_events_sanitize_text_transform( $value ) {
    $valid = array( 'none', 'capitalize', 'uppercase', 'lowercase' );
    return in_array( $value, $valid ) ? $value : 'none';
}

/*------------------------------------------------------------------------*/

function prime_events_sanitize_theme_width($input) {
    // Define the valid options
    $valid = array('full-width', 'container-fluid', 'container');
    
    // Check if the input is in the array of valid options, otherwise return the default.
    if (in_array($input, $valid, true)) {
        return $input;
    }
    
    // Default fallback if the input is not valid.
    return 'full-width';
}

/*------------------------------------------------------------------------*/

function prime_events_sanitize_single_post_align($input) {
    // Define the valid options
    $valid = array('left-align', 'right-align', 'center-align');
    
    // Check if the input is in the array of valid options, otherwise return the default.
    if (in_array($input, $valid, true)) {
        return $input;
    }
    
    // Default fallback if the input is not valid.
    return 'left-align';
}

/*------------------------------------------------------------------------*/

// Sanitize callback function
function prime_events_sanitize_post_layout($input) {
    $valid = array('one-column', 'right-sidebar', 'left-sidebar', 'three-column', 'four-column');

    if (in_array($input, $valid, true)) {
        return $input;
    }

    return 'right-sidebar'; // Default value if the input is invalid
}

/*------------------------------------------------------------------------*/

function prime_events_sanitize_scroll_top_alignment($input) {
    $valid = array('right-align', 'center-align', 'left-align');

    if (in_array($input, $valid, true)) {
        return $input;
    }

    return 'right-align'; 
}

/*------------------------------------------------------------------------*/

function prime_events_sanitize_pagination_alignment($input) {
    $valid = array('right-align', 'center-align', 'left-align');

    if (in_array($input, $valid, true)) {
        return $input;
    }

    return 'left-align'; 
}

/*------------------------------------------------------------------------*/

// Sanitize Sortable control.
function prime_events_sanitize_sortable( $val, $setting ) {
    if ( is_string( $val ) || is_numeric( $val ) ) {
        return array(
            esc_attr( $val ),
        );
    }
    $sanitized_value = array();
    foreach ( $val as $item ) {
        if ( isset( $setting->manager->get_control( $setting->id )->choices[ $item ] ) ) {
            $sanitized_value[] = esc_attr( $item );
        }
    }
    return $sanitized_value;
}