<?php
/**
 * Prime Events Theme Customizer.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package prime_events
 */

if( ! function_exists( 'prime_events_customize_register' ) ):  
/**
 * Add postMessage support for site title and description for the Theme Customizer.F
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function prime_events_customize_register( $wp_customize ) {
    require get_parent_theme_file_path('/inc/controls/changeable-icon.php');

    require get_parent_theme_file_path('/inc/controls/sortable-control.php');
    
    //Register the sortable control type.
    $wp_customize->register_control_type( 'Prime_Events_Control_Sortable' ); 
    
    if ( version_compare( get_bloginfo('version'),'4.9', '>=') ) {
        $wp_customize->get_section( 'static_front_page' )->title = __( 'Static Front Page', 'prime-events' );
    }
	
    /* Option list of all post */	
    $prime_events_options_posts = array();
    $prime_events_options_posts_obj = get_posts('posts_per_page=-1');
    $prime_events_options_posts[''] = esc_html__( 'Choose Post', 'prime-events' );
    foreach ( $prime_events_options_posts_obj as $prime_events_posts ) {
    	$prime_events_options_posts[$prime_events_posts->ID] = $prime_events_posts->post_title;
    }
    
    /* Option list of all categories */
    $prime_events_args = array(
	   'type'                     => 'post',
	   'orderby'                  => 'name',
	   'order'                    => 'ASC',
	   'hide_empty'               => 1,
	   'hierarchical'             => 1,
	   'taxonomy'                 => 'category'
    ); 
    $prime_events_option_categories = array();
    $prime_events_category_lists = get_categories( $prime_events_args );
    $prime_events_option_categories[''] = esc_html__( 'Choose Category', 'prime-events' );
    foreach( $prime_events_category_lists as $prime_events_category ){
        $prime_events_option_categories[$prime_events_category->term_id] = $prime_events_category->name;
    }
    
    /** Default Settings */    
    $wp_customize->add_panel( 
        'wp_default_panel',
         array(
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => esc_html__( 'Default Settings', 'prime-events' ),
            'description' => esc_html__( 'Default section provided by wordpress customizer.', 'prime-events' ),
        ) 
    );
    
    $wp_customize->get_section( 'title_tagline' )->panel                  = 'wp_default_panel';
    $wp_customize->get_section( 'colors' )->panel                         = 'wp_default_panel';
    $wp_customize->get_section( 'header_image' )->panel                   = 'wp_default_panel';
    $wp_customize->get_section( 'background_image' )->panel               = 'wp_default_panel';
    $wp_customize->get_section( 'static_front_page' )->panel              = 'wp_default_panel';
    
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    
    /** Default Settings Ends */

    /** Responsive Media settings */
    $wp_customize->add_section(
        'prime_events_responsive_media_section',
        array(
            'title' => esc_html__( 'Responsive Media Settings', 'prime-events' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_events_general_settings',
        )
    );

    /** Scroll to top Responsive control */
    $wp_customize->add_setting( 
        'prime_events_resp_scroll_top', 
        array(
            'default' => 1,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_resp_scroll_top',
        array(
            'label'       => __( 'Show Scroll To Top', 'prime-events' ),
            'section'     => 'prime_events_responsive_media_section',
            'type'        => 'checkbox',
        )
    );

        /** Scroll to top Responsive control */
    $wp_customize->add_setting( 
        'prime_events_resp_loader', 
        array(
            'default' => 0,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_resp_loader',
        array(
            'label'       => __( 'Show Preloader', 'prime-events' ),
            'section'     => 'prime_events_responsive_media_section',
            'type'        => 'checkbox',
        )
    );

    /** Responsive Media Ends */

    //Global Color
    $wp_customize->add_section(
        'prime_events_global_color',
        array(
            'title' => esc_html__( 'Global Color Settings', 'prime-events' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_events_general_settings',
        )
    );

    $wp_customize->add_setting('prime_events_primary_color', array(
        'default'           => '#560238',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'prime_events_primary_color', array(
        'label'    => __('Theme Primary Color', 'prime-events'),
        'section'  => 'prime_events_global_color',
        'settings' => 'prime_events_primary_color',
    )));    

    $wp_customize->add_setting('prime_events_second_color', array(
        'default'           => '#F85285',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'prime_events_second_color', array(
        'label'    => __('Theme Secondary Color', 'prime-events'),
        'section'  => 'prime_events_global_color',
        'settings' => 'prime_events_second_color',
    )));

    /** Post & Pages Settings */
    $wp_customize->add_panel( 
        'prime_events_post_settings',
         array(
            'priority' => 12,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Post & Pages Settings', 'prime-events' ),
            'description' => esc_html__( 'Customize Post & Pages Settings', 'prime-events' ),
        ) 
    );

        /** Post Layouts */
    
    $wp_customize->add_section(
        'prime_events_post_layout_section',
        array(
            'title' => esc_html__( 'Post Layout Settings', 'prime-events' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_events_post_settings',
        )
    );

    $wp_customize->add_setting('prime_events_post_layout_setting', array(
        'default'           => 'right-sidebar',
        'sanitize_callback' => 'prime_events_sanitize_post_layout',
    ));

    $wp_customize->add_control('prime_events_post_layout_setting', array(
        'label'    => __('Post Column Settings', 'prime-events'),
        'section'  => 'prime_events_post_layout_section',
        'settings' => 'prime_events_post_layout_setting',
        'type'     => 'select',
        'choices'  => array(
            'one-column'   => __('One Column', 'prime-events'),
            'right-sidebar'   => __('Right Sidebar', 'prime-events'),
            'left-sidebar'   => __('Left Sidebar', 'prime-events'),
            'three-column'   => __('Three Columns', 'prime-events'),
            'four-column'   => __('Four Columns', 'prime-events'),
        ),
    ));

    $wp_customize->add_setting('prime_events_archive_pagination_alignment',array(
        'default' => 'left-align',
        'sanitize_callback' => 'prime_events_sanitize_pagination_alignment'
    ));
    $wp_customize->add_control('prime_events_archive_pagination_alignment',array(
        'type' => 'select',
        'label' => __('Pagination Alignment','prime-events'),
        'section' => 'prime_events_post_layout_section',
        'choices' => array(
            'right-align' => __('Right Alignment','prime-events'),
            'center-align' => __('Center Alignment','prime-events'),
            'left-align' => __('Left Alignment','prime-events'),
        ),
    ) );

     /** Post Layouts Ends */
    
    /** Site Title control */
    $wp_customize->add_setting( 
        'header_site_title', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_site_title',
        array(
            'label'       => __( 'Show / Hide Site Title', 'prime-events' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    /** Tagline control */
    $wp_customize->add_setting( 
        'header_tagline', 
        array(
            'default'           => false,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'header_tagline',
        array(
            'label'       => __( 'Show / Hide Tagline', 'prime-events' ),
            'section'     => 'title_tagline',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('logo_width', array(
        'sanitize_callback' => 'absint', 
    ));

    // Add a control for logo width
    $wp_customize->add_control('logo_width', array(
        'label' => __('Logo Width', 'prime-events'),
        'section' => 'title_tagline',
        'type' => 'number',
        'input_attrs' => array(
            'min' => '50', 
            'max' => '500', 
            'step' => '5', 
    ),
        'default' => '100', 
    ));

    $wp_customize->add_setting( 'prime_events_site_title_size', array(
        'default'           => 30, // Default font size in pixels
        'sanitize_callback' => 'absint', // Sanitize the input as a positive integer
    ) );

    // Add control for site title size
    $wp_customize->add_control( 'prime_events_site_title_size', array(
        'type'        => 'number',
        'section'     => 'title_tagline', // You can change this section to your preferred section
        'label'       => __( 'Site Title Font Size (px)', 'prime-events' ),
        'input_attrs' => array(
            'min'  => 10,
            'max'  => 100,
            'step' => 1,
        ),
    ) );
    /** Post Settings */
    $wp_customize->add_section(
        'prime_events_post_settings',
        array(
            'title' => esc_html__( 'Post Settings', 'prime-events' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_events_post_settings',
        )
    );

    /** Post Heading control */
    $wp_customize->add_setting( 
        'prime_events_post_heading_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_post_heading_setting',
        array(
            'label'       => __( 'Show / Hide Post Heading', 'prime-events' ),
            'section'     => 'prime_events_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Meta control */
    $wp_customize->add_setting( 
        'prime_events_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Post Meta', 'prime-events' ),
            'section'     => 'prime_events_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Image control */
    $wp_customize->add_setting( 
        'prime_events_post_image_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_post_image_setting',
        array(
            'label'       => __( 'Show / Hide Post Image', 'prime-events' ),
            'section'     => 'prime_events_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Post Content control */
    $wp_customize->add_setting( 
        'prime_events_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Post Content', 'prime-events' ),
            'section'     => 'prime_events_post_settings',
            'type'        => 'checkbox',
        )
    );
    /** Post ReadMore control */
    $wp_customize->add_setting( 
        'prime_events_read_more_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_read_more_setting',
        array(
            'label'       => __( 'Display Read More Button', 'prime-events' ),
            'section'     => 'prime_events_post_settings',
            'type'        => 'checkbox',
        )
    );

    $wp_customize->add_setting('prime_events_single_post_align',array(
        'default' => 'left-align',
        'sanitize_callback' => 'prime_events_sanitize_single_post_align'
    ));
    $wp_customize->add_control('prime_events_single_post_align',array(
        'type' => 'select',
        'label' => __('Post Content Alignment','prime-events'),
        'section' => 'prime_events_post_settings',
        'choices' => array(
            'left-align' => __('Left Alignment','prime-events'),
            'right-align' => __('Right Alignment','prime-events'),
            'center-align' => __('Center Alignment','prime-events'),
        ),
    ) );

    $wp_customize->add_setting('prime_events_blog_meta_order', array(
        'default' => array('heading', 'author', 'featured-image', 'content','button'),
        'sanitize_callback' => 'prime_events_sanitize_sortable',
    ));
    $wp_customize->add_control(new Prime_Events_Control_Sortable($wp_customize, 'prime_events_blog_meta_order', array(
        'label' => esc_html__('Post Meta Ordering', 'prime-events'),
        'description' => __('Drag & drop post items to rearrange the ordering ( this control will not function by post format )', 'prime-events') ,
        'section' => 'prime_events_post_settings',
        'choices' => array(
            'heading' => __('heading', 'prime-events') ,
            'author' => __('author', 'prime-events') ,
            'featured-image' => __('featured-image', 'prime-events') ,
            'content' => __('content', 'prime-events') ,
            'button' => __('button', 'prime-events') ,
        ) ,
    )));

    /** Post Settings Ends */

     /** Single Post Settings */
    $wp_customize->add_section(
        'prime_events_single_post_settings',
        array(
            'title' => esc_html__( 'Single Post Settings', 'prime-events' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_events_post_settings',
        )
    );

    /** Single Post Meta control */
    $wp_customize->add_setting( 
        'prime_events_single_post_meta_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_single_post_meta_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Meta', 'prime-events' ),
            'section'     => 'prime_events_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Content control */
    $wp_customize->add_setting( 
        'prime_events_single_post_content_setting', 
        array(
            'default'           => true,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_single_post_content_setting',
        array(
            'label'       => __( 'Show / Hide Single Post Content', 'prime-events' ),
            'section'     => 'prime_events_single_post_settings',
            'type'        => 'checkbox',
        )
    );

    /** Single Post Settings Ends */

         // Typography Settings Section
    $wp_customize->add_section('prime_events_typography_settings', array(
        'title'      => esc_html__('Typography Settings', 'prime-events'),
        'priority'   => 30,
        'capability' => 'edit_theme_options',
        'panel' => 'prime_events_general_settings',
    ));

    // Array of fonts to choose from
    $font_choices = array(
        ''               => __('Select', 'prime-events'),
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Roboto'         => 'Roboto, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
        'Libre Baskerville' => 'Libre Baskerville',
    );

    // Heading Font Setting
    $wp_customize->add_setting('prime_events_heading_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'prime_events_sanitize_choicess',
    ));
    $wp_customize->add_control('prime_events_heading_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Heading', 'prime-events'),
        'section' => 'prime_events_typography_settings',
    ));

    // Body Font Setting
    $wp_customize->add_setting('prime_events_body_font_family', array(
        'default'           => '',
        'sanitize_callback' => 'prime_events_sanitize_choicess',
    ));
    $wp_customize->add_control('prime_events_body_font_family', array(
        'type'    => 'select',
        'choices' => $font_choices,
        'label'   => __('Select Font for Body', 'prime-events'),
        'section' => 'prime_events_typography_settings',
    ));

    /** Typography Settings Section End */

    /** General Settings */
    $wp_customize->add_panel( 
        'prime_events_general_settings',
         array(
            'priority' => 12,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'General Settings', 'prime-events' ),
            'description' => esc_html__( 'Customize General Settings', 'prime-events' ),
        ) 
    );

    /** General Settings */
    $wp_customize->add_section(
        'prime_events_general_settings',
        array(
            'title' => esc_html__( 'Loader Settings', 'prime-events' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_events_general_settings',
        )
    );

    /** Preloader control */
    $wp_customize->add_setting( 
        'prime_events_header_preloader', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_header_preloader',
        array(
            'label'       => __( 'Show Preloader', 'prime-events' ),
            'section'     => 'prime_events_general_settings',
            'type'        => 'checkbox',
        )
    );

    /** Header Section Settings */
    $wp_customize->add_section(
        'prime_events_header_section_settings',
        array(
            'title' => esc_html__( 'Header Section Settings', 'prime-events' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
        )
    );

    /** Header Section control */
    $wp_customize->add_setting( 
        'prime_events_header_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_header_setting',
        array(
            'label'       => __( 'Show Header', 'prime-events' ),
            'section'     => 'prime_events_header_section_settings',
            'type'        => 'checkbox',
        )
    );

     /** Phone */
    $wp_customize->add_setting(
        'prime_events_header_phone',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_events_header_phone',
        array(
            'label' => esc_html__( 'Add Phone', 'prime-events' ),
            'section' => 'prime_events_header_section_settings',
            'type' => 'text',
        )
    );
    $wp_customize->add_setting('prime_events_phone_icon',array(
        'default'   => 'fas fa-phone',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Prime_Events_Changeable_Icon(
        $wp_customize,'prime_events_phone_icon',array(
        'label' => __('Phone Icon','prime-events'),
        'transport' => 'refresh',
        'section'   => 'prime_events_header_section_settings',
        'type'      => 'icon'
    )));

    /**  TIMING */
    $wp_customize->add_setting(
        'prime_events_header_location',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_events_header_location',
        array(
            'label' => esc_html__( 'Add Topbar Text', 'prime-events' ),
            'section' => 'prime_events_header_section_settings',
            'type' => 'text',
        )
    );

    /** Appointment Button */
    $wp_customize->add_setting(
        'prime_events_header_btn_text',
        array( 
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_events_header_btn_text',
        array(
            'label' => esc_html__( 'Add Button Text', 'prime-events' ),
            'section' => 'prime_events_header_section_settings',
            'type' => 'text',
        )
    );

    /** Appointment Button */
    $wp_customize->add_setting(
        'prime_events_header_btn_url',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_events_header_btn_url',
        array(
            'label' => esc_html__( 'Add Button URL', 'prime-events' ),
            'section' => 'prime_events_header_section_settings',
            'type' => 'url',
        )
    );

    /** Sticky Header control */
    $wp_customize->add_setting( 
        'prime_events_sticky_header', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_sticky_header',
        array(
            'label'       => __( 'Show Sticky Header', 'prime-events' ),
            'section'     => 'prime_events_header_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Add Setting for Menu Font Weight
    $wp_customize->add_setting( 'prime_events_menu_font_weight', array(
        'default'           => '500',
        'sanitize_callback' => 'prime_events_sanitize_font_weight',
    ) );

    // Add Control for Menu Font Weight
    $wp_customize->add_control( 'prime_events_menu_font_weight', array(
        'label'    => __( 'Menu Font Weight', 'prime-events' ),
        'section'  => 'prime_events_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            '100' => __( '100 - Thin', 'prime-events' ),
            '200' => __( '200 - Extra Light', 'prime-events' ),
            '300' => __( '300 - Light', 'prime-events' ),
            '400' => __( '400 - Normal', 'prime-events' ),
            '500' => __( '500 - Medium', 'prime-events' ),
            '600' => __( '600 - Semi Bold', 'prime-events' ),
            '700' => __( '700 - Bold', 'prime-events' ),
            '800' => __( '800 - Extra Bold', 'prime-events' ),
            '900' => __( '900 - Black', 'prime-events' ),
        ),
    ) );

    // Add Setting for Menu Text Transform
    $wp_customize->add_setting( 'prime_events_menu_text_transform', array(
        'default'           => 'capitalize',
        'sanitize_callback' => 'prime_events_sanitize_text_transform',
    ) );

    // Add Control for Menu Text Transform
    $wp_customize->add_control( 'prime_events_menu_text_transform', array(
        'label'    => __( 'Menu Text Transform', 'prime-events' ),
        'section'  => 'prime_events_header_section_settings',
        'type'     => 'select',
        'choices'  => array(
            'none'       => __( 'None', 'prime-events' ),
            'capitalize' => __( 'Capitalize', 'prime-events' ),
            'uppercase'  => __( 'Uppercase', 'prime-events' ),
            'lowercase'  => __( 'Lowercase', 'prime-events' ),
        ),
    ) );

    // Menu Hover Style	
    $wp_customize->add_setting('prime_events_menus_style',array(
        'default' => '',
        'sanitize_callback' => 'prime_events_sanitize_choices'
	));
	$wp_customize->add_control('prime_events_menus_style',array(
        'type' => 'select',
		'label' => __('Menu Hover Style','prime-events'),
		'section' => 'prime_events_header_section_settings',
		'choices' => array(
         'None' => __('None','prime-events'),
         'Zoom In' => __('Zoom In','prime-events'),
      ),
	));

    $wp_customize->add_setting('prime_events_theme_width',array(
        'default' => 'full-width',
        'sanitize_callback' => 'prime_events_sanitize_theme_width'
    ));
    $wp_customize->add_control('prime_events_theme_width',array(
        'type' => 'select',
        'label' => __('Theme Width Option','prime-events'),
        'section' => 'prime_events_header_section_settings',
        'choices' => array(
            'full-width' => __('Fullwidth','prime-events'),
            'container' => __('Container','prime-events'),
            'container-fluid' => __('Container Fluid','prime-events'),
        ),
    ) );

    
    /** Social Section Settings */
    $wp_customize->add_section(
        'prime_events_social_section_settings',
        array(
            'title' => esc_html__( 'Social Media Section Settings', 'prime-events' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_events_home_page_settings',
        )
    );

    /** Socail Section control */
    $wp_customize->add_setting( 
        'prime_events_social_icon_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_social_icon_setting',
        array(
            'label'       => __( 'Show Social Icon', 'prime-events' ),
            'section'     => 'prime_events_social_section_settings',
            'type'        => 'checkbox',
        )
    );

    /**  Social Link 1 */
    $wp_customize->add_setting(
        'prime_events_social_link_1',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_events_social_link_1',
        array(
            'label' => esc_html__( 'Add Facebook Link', 'prime-events' ),
            'section' => 'prime_events_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 2 */
    $wp_customize->add_setting(
        'prime_events_social_link_2',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_events_social_link_2',
        array(
            'label' => esc_html__( 'Add Twitter Link', 'prime-events' ),
            'section' => 'prime_events_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 3 */
    $wp_customize->add_setting(
        'prime_events_social_link_3',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_events_social_link_3',
        array(
            'label' => esc_html__( 'Add Instagram Link', 'prime-events' ),
            'section' => 'prime_events_social_section_settings',
            'type' => 'url',
        )
    );

    /**  Social Link 4 */
    $wp_customize->add_setting(
        'prime_events_social_link_4',
        array( 
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
            'transport'         => 'refresh'
        )
    );
    
    $wp_customize->add_control(
        'prime_events_social_link_4',
        array(
            'label' => esc_html__( 'Add Youtube Link', 'prime-events' ),
            'section' => 'prime_events_social_section_settings',
            'type' => 'url',
        )
    );

    /** Socail Section Settings End */

    /** Home Page Settings */
    $wp_customize->add_panel( 
        'prime_events_home_page_settings',
         array(
            'priority' => 9,
            'capability' => 'edit_theme_options',
            'title' => esc_html__( 'Home Page Settings', 'prime-events' ),
            'description' => esc_html__( 'Customize Home Page Settings', 'prime-events' ),
        ) 
    );

    /** Slider Section Settings */
    $wp_customize->add_section(
        'prime_events_slider_section_settings',
        array(
            'title' => esc_html__( 'Slider Section Settings', 'prime-events' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_events_home_page_settings',
        )
    );

    /** Slider Section control */
    $wp_customize->add_setting( 
        'prime_events_slider_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_slider_setting',
        array(
            'label'       => __( 'Show Slider', 'prime-events' ),
            'section'     => 'prime_events_slider_section_settings',
            'type'        => 'checkbox',
        )
    );

     // Section Text
    $wp_customize->add_setting('prime_events_slider_text_extra', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('prime_events_slider_text_extra', 
        array(
        'label'       => __('Slider Extra Title', 'prime-events'),
        'section'     => 'prime_events_slider_section_settings',   
        'settings'    => 'prime_events_slider_text_extra',
        'type'        => 'text'
        )
    );

    // Section Text
    $wp_customize->add_setting('prime_events_slider_side_text', 
        array(
        'default'           => '',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',    
        'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control('prime_events_slider_side_text', 
        array(
        'label'       => __('Side Event Text ( Only One Word )', 'prime-events'),
        'section'     => 'prime_events_slider_section_settings',   
        'settings'    => 'prime_events_slider_side_text',
        'type'        => 'text'
        )
    );
    
    $categories = get_categories();
        $cat_posts = array();
            $i = 0;
            $cat_posts[]='Select';
        foreach($categories as $category){
            if($i==0){
            $default = $category->slug;
            $i++;
        }
        $cat_posts[$category->slug] = $category->name;
    }

    $wp_customize->add_setting(
        'prime_events_blog_slide_category',
        array(
            'default'   => 'select',
            'sanitize_callback' => 'prime_events_sanitize_choices',
        )
    );
    $wp_customize->add_control(
        'prime_events_blog_slide_category',
        array(
            'type'    => 'select',
            'choices' => $cat_posts,
            'label' => __('Select Category to display Latest Post','prime-events'),
            'section' => 'prime_events_slider_section_settings',
        )
    );

    /** Classes Section Settings */
    $wp_customize->add_section(
        'prime_events_classes_section_settings',
        array(
            'title' => esc_html__( 'Our Events Section Settings', 'prime-events' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'prime_events_home_page_settings',
        )
    );

    /** Classes Section control */
    $wp_customize->add_setting( 
        'prime_events_classes_setting', 
        array(
            'default' => false,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_classes_setting',
        array(
            'label'       => __( 'Show Events', 'prime-events' ),
            'section'     => 'prime_events_classes_section_settings',
            'type'        => 'checkbox',
        )
    );

    // Section Title
    $wp_customize->add_setting(
        'prime_events_section_title', 
        array(
            'default'           => '',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',    
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'prime_events_section_title', 
        array(
            'label'       => __('Section Title', 'prime-events'),
            'section'     => 'prime_events_classes_section_settings',
            'settings'    => 'prime_events_section_title',
            'type'        => 'text'
        )
    );

    // Section Text
    $wp_customize->add_setting(
        'prime_events_section_text', 
        array(
            'default'           => '',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',    
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'prime_events_section_text', 
        array(
            'label'       => __('Section Text', 'prime-events'),
            'section'     => 'prime_events_classes_section_settings',
            'settings'    => 'prime_events_section_text',
            'type'        => 'text'
        )
    );

       // Post Categories
    $categories = get_categories();
    $cat_posts = array();
    $default = '';
    $cat_posts[] = 'Select';
    foreach ($categories as $category) {
        $cat_posts[$category->slug] = $category->name;
    }

    $wp_customize->add_setting(
        'prime_events_trending_post_slider_args_',
        array(
            'default'            => 'select',
            'sanitize_callback'  => 'prime_events_sanitize_choices',
        )
    );
    $wp_customize->add_control(
        'prime_events_trending_post_slider_args_',
        array(
            'type'     => 'select',
            'choices'  => $cat_posts,
            'label'    => __('Select Category to display Tab Details', 'prime-events'),
            'section'  => 'prime_events_classes_section_settings',
        )
    );

    // Event Timings

    for ($i=1; $i <=10 ; $i++) { 
        $wp_customize->add_setting(
        'prime_events_post_dates'.$i, 
        array(
            'default'           => '',
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',    
            'sanitize_callback' => 'sanitize_text_field'
        )
    );

    $wp_customize->add_control(
        'prime_events_post_dates'.$i, 
        array(
            'label'       => __('Event Timings ', 'prime-events') .$i,
            'section'     => 'prime_events_classes_section_settings',
            'settings'    => 'prime_events_post_dates'.$i,
            'type'        => 'text'
        )
    );
    }

    
    /** Home Page Settings Ends */
    
    /** Footer Section */
    $wp_customize->add_section(
        'prime_events_footer_section',
        array(
            'title' => __( 'Footer Settings', 'prime-events' ),
            'priority' => 70,
            'panel' => 'prime_events_home_page_settings',
        )
    );

    /** Footer Widget Columns */
    $wp_customize->add_setting('prime_events_footer_widget_areas', array(
        'default'           => 4,
        'sanitize_callback' => 'prime_events_sanitize_choices',
    ));

    $wp_customize->add_control('prime_events_footer_widget_areas', array(
        'label'    => __('Footer Widget Columns', 'prime-events'),
        'section'  => 'prime_events_footer_section',
        'settings' => 'prime_events_footer_widget_areas',
        'type'     => 'select',
        'choices'  => array(
		   '1'     => __('One', 'prime-events'),
		   '2'     => __('Two', 'prime-events'),
		   '3'     => __('Three', 'prime-events'),
		   '4'     => __('Four', 'prime-events')
        ),
    ));

    /** Footer Copyright control */
    $wp_customize->add_setting( 
        'prime_events_footer_setting', 
        array(
            'default' => true,
            'sanitize_callback' => 'prime_events_sanitize_checkbox',
        ) 
    );

    $wp_customize->add_control(
        'prime_events_footer_setting',
        array(
            'label'       => __( 'Show Footer Copyright', 'prime-events' ),
            'section'     => 'prime_events_footer_section',
            'type'        => 'checkbox',
        )
    );
    
    /** Copyright Text */
    $wp_customize->add_setting(
        'prime_events_footer_copyright_text',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'prime_events_footer_copyright_text',
        array(
            'label' => __( 'Copyright Info', 'prime-events' ),
            'section' => 'prime_events_footer_section',
            'type' => 'text',
        )
    );  
$wp_customize->add_setting('prime_events_footer_background_image',
        array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
        )
    );


    $wp_customize->add_control(
         new WP_Customize_Cropped_Image_Control($wp_customize, 'prime_events_footer_background_image',
            array(
                'label' => esc_html__('Footer Background Image', 'prime-events'),
                'description' => sprintf(esc_html__('Recommended Size %1$s px X %2$s px', 'prime-events'), 1024, 800),
                'section' => 'prime_events_footer_section',
                'width' => 1024,
                'height' => 800,
                'flex_width' => true,
                'flex_height' => true,
            )
        )
    );

    /** Footer Background Image Attachment */
    $wp_customize->add_setting('prime_events_background_attachment', array(
        'default'           => 'scroll',
        'sanitize_callback' => 'prime_events_sanitize_choices',
    ));

    $wp_customize->add_control('prime_events_background_attachment', array(
        'label'    => __('Footer Background Attachment', 'prime-events'),
        'section'  => 'prime_events_footer_section',
        'settings' => 'prime_events_background_attachment',
        'type'     => 'select',
        'choices'  => array(
            'fixed' => __('fixed','prime-events'),
            'scroll' => __('scroll','prime-events'),
        ),
    ));

    /* Footer Background Color*/
    $wp_customize->add_setting(
        'prime_events_footer_background_color',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'prime_events_footer_background_color',
            array(
                'label' => __('Footer Widget Area Background Color', 'prime-events'),
                'section' => 'prime_events_footer_section',
                'type' => 'color',
            )
        )
    );

     $wp_customize->add_setting('prime_events_scroll_icon',array(
        'default'   => 'fas fa-arrow-up',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control(new Prime_Events_Changeable_Icon(
        $wp_customize,'prime_events_scroll_icon',array(
        'label' => __('Scroll Top Icon','prime-events'),
        'transport' => 'refresh',
        'section'   => 'prime_events_footer_section',
        'type'      => 'icon'
    )));

    $wp_customize->add_setting('prime_events_scroll_top_alignment',array(
        'default' => 'right-align',
        'sanitize_callback' => 'prime_events_sanitize_scroll_top_alignment'
    ));
    $wp_customize->add_control('prime_events_scroll_top_alignment',array(
        'type' => 'select',
        'label' => __('Scroll Top Alignment','prime-events'),
        'section' => 'prime_events_footer_section',
        'choices' => array(
            'right-align' => __('Right Alignment','prime-events'),
            'center-align' => __('Center Alignment','prime-events'),
            'left-align' => __('Left Alignment','prime-events'),
        ),
    ) );

    /** Scroll to top button shape */
    $wp_customize->add_setting('prime_events_scroll_to_top_radius', array(
        'default'           => 'curved-box',
        'sanitize_callback' => 'prime_events_sanitize_choices',
    ));

    $wp_customize->add_control('prime_events_scroll_to_top_radius', array(
        'label'    => __('Scroll Top Button Shape', 'prime-events'),
        'section'  => 'prime_events_footer_section',
        'settings' => 'prime_events_scroll_to_top_radius',
        'type'     => 'select',
        'choices'  => array(
            'box'        => __( 'Box', 'prime-events' ),
            'curved-box' => __( 'Curved Box', 'prime-events' ),
            'circle'     => __( 'Circle', 'prime-events' ),
        ),
    ));

    // 404 PAGE SETTINGS
    $wp_customize->add_section(
        'prime_events_404_section',
        array(
            'title' => __( '404 Page Settings', 'prime-events' ),
            'priority' => 70,
            'panel' => 'prime_events_general_settings',
        )
    );
   
    $wp_customize->add_setting('404_page_image', array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'esc_url_raw', // Sanitize as URL
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, '404_page_image', array(
        'label' => __('404 Page Image', 'prime-events'),
        'section' => 'prime_events_404_section',
        'settings' => '404_page_image',
    )));

    $wp_customize->add_setting('404_pagefirst_header', array(
        'default' => __('404', 'prime-events'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_pagefirst_header', array(
        'type' => 'text',
        'label' => __('Heading', 'prime-events'),
        'section' => 'prime_events_404_section',
    ));

    // Setting for 404 page header
    $wp_customize->add_setting('404_page_header', array(
        'default' => __('Sorry, that page can\'t be found!', 'prime-events'),
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field', // Sanitize as text field
    ));

    $wp_customize->add_control('404_page_header', array(
        'type' => 'text',
        'label' => __('Heading', 'prime-events'),
        'section' => 'prime_events_404_section',
    ));
    function prime_events_sanitize_choices( $input, $setting ) {
        global $wp_customize; 
        $control = $wp_customize->get_control( $setting->id ); 
        if ( array_key_exists( $input, $control->choices ) ) {
            return $input;
        } else {
            return $setting->default;
        }
    }

    function prime_events_sanitize_choicess($input) {
    $valid = array(
        'Arial'          => 'Arial, sans-serif',
        'Verdana'        => 'Verdana, sans-serif',
        'Helvetica'      => 'Helvetica, sans-serif',
        'Times New Roman'=> '"Times New Roman", serif',
        'Georgia'        => 'Georgia, serif',
        'Courier New'    => '"Courier New", monospace',
        'Trebuchet MS'   => '"Trebuchet MS", sans-serif',
        'Tahoma'         => 'Tahoma, sans-serif',
        'Palatino'       => '"Palatino Linotype", serif',
        'Garamond'       => 'Garamond, serif',
        'Impact'         => 'Impact, sans-serif',
        'Comic Sans MS'  => '"Comic Sans MS", cursive, sans-serif',
        'Lucida Sans'    => '"Lucida Sans Unicode", sans-serif',
        'Arial Black'    => '"Arial Black", sans-serif',
        'Gill Sans'      => '"Gill Sans", sans-serif',
        'Segoe UI'       => '"Segoe UI", sans-serif',
        'Open Sans'      => '"Open Sans", sans-serif',
        'Roboto'         => 'Roboto, sans-serif',
        'Lato'           => 'Lato, sans-serif',
        'Montserrat'     => 'Montserrat, sans-serif',
    );

    return (array_key_exists($input, $valid)) ? $input : '';
}

}
add_action( 'customize_register', 'prime_events_customize_register' );
endif;

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function prime_events_customize_preview_js() {
    // Use minified libraries if SCRIPT_DEBUG is false
    $prime_events_build  = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $prime_events_suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';
	wp_enqueue_script( 'prime_events_customizer', get_template_directory_uri() . '/js' . $prime_events_build . '/customizer' . $prime_events_suffix . '.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'prime_events_customize_preview_js' );