<?php 


function homepage_customizer_register( $wp_customize ) {

/*Sanitize Functions*/

function pridehost_sanitize_checkbox( $checked ) {
	// Boolean check.
	return ( ( isset( $checked ) && true == $checked ) ? true : false );
	}

//select sanitization function
function pridehost_sanitize_select( $input, $setting ){
 
    //input must be a slug: lowercase alphanumeric characters, dashes and underscores are allowed only
    $input = sanitize_key($input);

    //get the list of possible select options 
    $choices = $setting->manager->get_control( $setting->id )->choices;
                     
    //return input if valid or return default option
    return ( array_key_exists( $input, $choices ) ? $input : $setting->default );                
     
}	

function pridehost_sanitize_image( $image, $setting ) {
	/*
	 * Array of valid image file types.
	 *
	 * The array includes image mime types that are included in wp_get_mime_types()
	 */
    $mimes = array(
        'jpg|jpeg|jpe' => 'image/jpeg',
        'gif'          => 'image/gif',
        'png'          => 'image/png',
        'bmp'          => 'image/bmp',
        'tif|tiff'     => 'image/tiff',
        'ico'          => 'image/x-icon'
    );
	// Return an array with file extension and mime_type.
    $file = wp_check_filetype( $image, $mimes );
	// If $image has a valid mime_type, return it; otherwise, return the default.
    return ( $file['ext'] ? $image : $setting->default );
}

/*Sanitize Functions END */

/*Custom-Page Setting Panel*/

$wp_customize->add_panel( 'front_page_panel', array(
	'priority'       => 50,
	'capability'     => 'edit_theme_options',
	'theme_supports' => '',
	'title'          => __('Custom Page Settings', 'pridehost'),
	'description'    => __('Customize Custom-Page Sections', 'pridehost'),
) );

/* Start Custom-Page Section-1 */

	$wp_customize->add_section( 'Welcome_section', array(
		'title'       => __( 'Section-1', 'pridehost' ),
		'description' => 'Edit Section-1',
		'panel'  => 'front_page_panel',
	) );

		/*Welcome Heading*/

		$wp_customize->add_setting( 'Welcome_message_heading', array(
			'default' => 'Best web hosting service for your website.',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'welcome_heading_control', array(
			'label'    => __( 'Heading: ', 'pridehost' ),
			'section'  => 'Welcome_section',
			'settings' => 'Welcome_message_heading'	
		) );


	/*Welcome Description*/

		$wp_customize->add_setting( 'Welcome_message_description', array(
			'default' => 'Get the best speed for your website. Do Not lose anymore clients for the slowest speed of your hosting service.',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'welcome_description_control', array(
			'label'    => __( 'Description: ', 'pridehost' ),
			'section'  => 'Welcome_section',
			'settings' => 'Welcome_message_description'	
	) );


    /* First Section Button Description */

	$wp_customize->add_setting( 'first_section_button1_description', array(
		'default' => 'Get Started Now',
		'sanitize_callback' => 'sanitize_text_field',
		'panel'  => 'front_page_panel',
	) );
	$wp_customize->add_control( 'first_section_button1_description', array(
		'label'    => __( 'Button Description: ', 'pridehost' ),
		'section'  => 'Welcome_section',
		'settings' => 'first_section_button1_description'	
	) );	

	// First Section Button link

	$wp_customize->add_setting('first_section_button1_link', array(
        'sanitize_callback' => 'esc_url_raw',
		'panel'  => 'front_page_panel',
		'default' => '#',
    ) );
	$wp_customize->add_control('first_section_button1_link', array(
        'label' => __('Button Link URL','pridehost'),
        'section' => 'Welcome_section',
        'type' => 'url',
    ) );


/* Firat Section Image Upload */
	    $wp_customize->add_setting( 
	    	'first_section_image', array(
	    	'sanitize_callback' => 'pridehost_sanitize_image',
	    ) );

	    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 
	    	'first_section_image', array(
	    	'label'    => __( 'Choose Image', 'pridehost' ),
	    	'section'  => 'Welcome_section',
	    	'settings' => 'first_section_image',) 
	    ) );

/* END Custom-Page Section-1 */

/* Start Custom-Page Section-2 */

	$wp_customize->add_section( 'section-2', array(
		'title'       => __( 'Section-2', 'pridehost' ),
		'description' => 'Edit Section-2',
		'panel'  => 'front_page_panel',
	) );

		/* Choose Us Heading 1 */

		$wp_customize->add_setting( 'choose_us_heading_1', array(
			'default' => 'Easy to Customize',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'choose_us_heading_1', array(
			'label'    => __( 'Heading: 1', 'pridehost' ),
			'section'  => 'section-2',
			'settings' => 'choose_us_heading_1'	
		) );


	/* Choose Us Description 1 */

		$wp_customize->add_setting( 'choose_us_description_1', array(
			'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'choose_us_description_1', array(
			'label'    => __( 'Description: ', 'pridehost' ),
			'section'  => 'section-2',
			'settings' => 'choose_us_description_1'	
	) );


		/* Choose Us Heading 2 */

		$wp_customize->add_setting( 'choose_us_heading_2', array(
			'default' => 'Secured Servers',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'choose_us_heading_2', array(
			'label'    => __( 'Heading: 2', 'pridehost' ),
			'section'  => 'section-2',
			'settings' => 'choose_us_heading_2'	
		) );


	/* Choose Us Description 2 */

		$wp_customize->add_setting( 'choose_us_description_2', array(
			'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'choose_us_description_2', array(
			'label'    => __( 'Description: ', 'pridehost' ),
			'section'  => 'section-2',
			'settings' => 'choose_us_description_2'	
	) );

		/* Choose Us Heading 3 */

		$wp_customize->add_setting( 'choose_us_heading_3', array(
			'default' => '24/7 customer support',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'choose_us_heading_3', array(
			'label'    => __( 'Heading: 3', 'pridehost' ),
			'section'  => 'section-2',
			'settings' => 'choose_us_heading_3'	
		) );


	/* Choose Us Description 2 */

		$wp_customize->add_setting( 'choose_us_description_3', array(
			'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'choose_us_description_3', array(
			'label'    => __( 'Description: ', 'pridehost' ),
			'section'  => 'section-2',
			'settings' => 'choose_us_description_3'	
	) );	

/* END Custom-Page Section-2 */

/* Start Custom-Page Section-3 */

		$wp_customize->add_section( 'section-3', array(
		'title'       => __( 'Section-3', 'pridehost' ),
		'description' => 'Edit Section-3',
		'panel'  => 'front_page_panel',
	) );


	/* Start Plan 1 */
		/* Plan 1 Heading */

		$wp_customize->add_setting( 'plan_heading_1', array(
			'default' => 'Personal Plan',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan_heading_1', array(
			'label'    => __( 'Plan 1 Heading', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan_heading_1'	
		) );

		/* Plan 1 Price */

		$wp_customize->add_setting( 'plan_price_1', array(
			'default' => '$3/m',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan_price_1', array(
			'label'    => __( 'Plan 1 Price', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan_price_1'	
		) );

		/* Plan 1 Description */

		$wp_customize->add_setting( 'plan_description_1', array(
			'default' => 'Best for personal use',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan_description_1', array(
			'label'    => __( 'Plan 1 Description', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan_description_1'	
		) );	

		/* Plan 1 spec 1 */

		$wp_customize->add_setting( 'plan1_spec_1', array(
			'default' => '10GB Space',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan1_spec_1', array(
			'label'    => __( 'Plan 1 first spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan1_spec_1'	
		) );

		/* Plan 1 spec 2*/

		$wp_customize->add_setting( 'plan1_spec_2', array(
			'default' => '1 Free Domain',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan1_spec_2', array(
			'label'    => __( 'Plan 1 second spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan1_spec_2'	
		) );

		/* Plan 1 spec 3 */

		$wp_customize->add_setting( 'plan1_spec_3', array(
			'default' => '300GB SSD Disk',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan1_spec_3', array(
			'label'    => __( 'Plan 1 third spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan1_spec_3'	
		) );		

		/* Plan 1 spec 4 */

		$wp_customize->add_setting( 'plan1_spec_4', array(
			'default' => 'Special Offers',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan1_spec_4', array(
			'label'    => __( 'Plan 1 fourth spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan1_spec_4'	
		) );

		/* Plan 1 spec 5 */

		$wp_customize->add_setting( 'plan1_spec_5', array(
			'default' => 'Unlimited Support',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan1_spec_5', array(
			'label'    => __( 'Plan 1 fifth spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan1_spec_5'	
		) );

    /* Third Section Button Description */

	$wp_customize->add_setting( 'plan1_button_description', array(
		'default' => 'Get Started Now',
		'sanitize_callback' => 'sanitize_text_field',
		'panel'  => 'front_page_panel',
	) );
	$wp_customize->add_control( 'plan1_button_description', array(
		'label'    => __( 'Button Description: ', 'pridehost' ),
		'section'  => 'section-3',
		'settings' => 'plan1_button_description'	
	) );	

	// Plan 1 Button link

	$wp_customize->add_setting('plan1_button_link', array(
        'sanitize_callback' => 'esc_url_raw',
		'panel'  => 'front_page_panel',
		'default' => '#',
    ) );
	$wp_customize->add_control('plan1_button_link', array(
        'label' => __('Button Link URL','pridehost'),
        'section' => 'section-3',
        'type' => 'url',
    ) );
	
	/* END Plan 1 */

	/* Start Plan 2 */

		/* Plan 2 Heading */

		$wp_customize->add_setting( 'plan_heading_2', array(
			'default' => 'SMALL TEAM',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan_heading_2', array(
			'label'    => __( 'Plan 2 Heading', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan_heading_2'	
		) );

		/* Plan 2 Price */

		$wp_customize->add_setting( 'plan_price_2', array(
			'default' => '$10/m',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan_price_2', array(
			'label'    => __( 'Plan 2 Price', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan_price_2'	
		) );

		/* Plan 2 Description */

		$wp_customize->add_setting( 'plan_description_2', array(
			'default' => 'Best for small team use',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan_description_2', array(
			'label'    => __( 'Plan 2 Description', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan_description_2'	
		) );	

		/* Plan 2 spec 1 */

		$wp_customize->add_setting( 'plan2_spec_1', array(
			'default' => '10GB Space',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan2_spec_1', array(
			'label'    => __( 'Plan 2 first spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan2_spec_1'	
		) );

		/* Plan 2 spec 2*/

		$wp_customize->add_setting( 'plan2_spec_2', array(
			'default' => '1 Free Domain',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan2_spec_2', array(
			'label'    => __( 'Plan 2 second spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan2_spec_2'	
		) );

		/* Plan 2 spec 3 */

		$wp_customize->add_setting( 'plan2_spec_3', array(
			'default' => '300GB SSD Disk',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan2_spec_3', array(
			'label'    => __( 'Plan 2 third spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan2_spec_3'	
		) );		

		/* Plan 2 spec 4 */

		$wp_customize->add_setting( 'plan2_spec_4', array(
			'default' => 'Special Offers',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan2_spec_4', array(
			'label'    => __( 'Plan 2 fourth spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan2_spec_4'	
		) );

		/* Plan 2 spec 5 */

		$wp_customize->add_setting( 'plan2_spec_5', array(
			'default' => 'Unlimited Support',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan2_spec_5', array(
			'label'    => __( 'Plan 2 fifth spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan2_spec_5'	
		) );

    /* Third Section Button Description */

	$wp_customize->add_setting( 'plan2_button_description', array(
		'default' => 'Get Started Now',
		'sanitize_callback' => 'sanitize_text_field',
		'panel'  => 'front_page_panel',
	) );
	$wp_customize->add_control( 'plan2_button_description', array(
		'label'    => __( 'Button Description: ', 'pridehost' ),
		'section'  => 'section-3',
		'settings' => 'plan2_button_description'	
	) );	

	// Plan 2 Button link

	$wp_customize->add_setting('plan2_button_link', array(
        'sanitize_callback' => 'esc_url_raw',
		'panel'  => 'front_page_panel',
		'default' => '#',
    ) );
	$wp_customize->add_control('plan2_button_link', array(
        'label' => __('Button Link URL','pridehost'),
        'section' => 'section-3',
        'type' => 'url',
    ) );

	/* END Plan 2 */

	/* Start Plan 3 */

		/* Plan 3 Heading */

		$wp_customize->add_setting( 'plan_heading_3', array(
			'default' => 'COMPANY',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan_heading_3', array(
			'label'    => __( 'Plan 3 Heading', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan_heading_3'	
		) );

		/* Plan 3 Price */

		$wp_customize->add_setting( 'plan_price_3', array(
			'default' => '$25/m',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan_price_3', array(
			'label'    => __( 'Plan 3 Price', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan_price_3'	
		) );

		/* Plan 3 Description */

		$wp_customize->add_setting( 'plan_description_3', array(
			'default' => 'Best for company use',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan_description_3', array(
			'label'    => __( 'Plan 3 Description', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan_description_3'	
		) );	

		/* Plan 3 spec 1 */

		$wp_customize->add_setting( 'plan3_spec_1', array(
			'default' => '10GB Space',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan3_spec_1', array(
			'label'    => __( 'Plan 3 first spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan3_spec_1'	
		) );

		/* Plan 3 spec 2*/

		$wp_customize->add_setting( 'plan3_spec_2', array(
			'default' => '1 Free Domain',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan3_spec_2', array(
			'label'    => __( 'Plan 3 second spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan3_spec_2'	
		) );

		/* Plan 3 spec 3 */

		$wp_customize->add_setting( 'plan3_spec_3', array(
			'default' => '300GB SSD Disk',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan3_spec_3', array(
			'label'    => __( 'Plan 3 third spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan3_spec_3'	
		) );		

		/* Plan 3 spec 4 */

		$wp_customize->add_setting( 'plan3_spec_4', array(
			'default' => 'Special Offers',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan3_spec_4', array(
			'label'    => __( 'Plan 3 fourth spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan3_spec_4'	
		) );

		/* Plan 3 spec 5 */

		$wp_customize->add_setting( 'plan3_spec_5', array(
			'default' => 'Unlimited Support',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'plan3_spec_5', array(
			'label'    => __( 'Plan 3 fifth spec', 'pridehost' ),
			'section'  => 'section-3',
			'settings' => 'plan3_spec_5'	
		) );

    /* Plan 3 Button Description */

	$wp_customize->add_setting( 'plan3_button_description', array(
		'default' => 'Get Started Now',
		'sanitize_callback' => 'sanitize_text_field',
		'panel'  => 'front_page_panel',
	) );
	$wp_customize->add_control( 'plan3_button_description', array(
		'label'    => __( 'Button Description: ', 'pridehost' ),
		'section'  => 'section-3',
		'settings' => 'plan3_button_description'	
	) );	

	// Plan 3 Button link

	$wp_customize->add_setting('plan3_button_link', array(
        'sanitize_callback' => 'esc_url_raw',
		'panel'  => 'front_page_panel',
		'default' => '#',
    ) );
	$wp_customize->add_control('plan3_button_link', array(
        'label' => __('Button Link URL','pridehost'),
        'section' => 'section-3',
        'type' => 'url',
    ) );

	/* END Plan 3 */

/* END Custom-Page Section-3 */

/* Start Call To Action Section */


	$wp_customize->add_section( 'action_section', array(
		'title'       => __( 'Call To Action Section', 'pridehost' ),
		'description' => 'Edit Call To Action Section',
		'panel'  => 'front_page_panel',
	) );

		/* Call To Action Heading*/

		$wp_customize->add_setting( 'call_action_heading', array(
			'default' => '20,000+ trusted Clients! Be one of them today',
			'sanitize_callback' => 'sanitize_text_field',
			'panel'  => 'front_page_panel',
		) );
		$wp_customize->add_control( 'call_action_heading', array(
			'label'    => __( 'Heading: ', 'pridehost' ),
			'section'  => 'action_section',
			'settings' => 'call_action_heading'	
		) );	

    /* Call To Action Button Description */

	$wp_customize->add_setting( 'call_action_button_description', array(
		'default' => 'Get Started Now',
		'sanitize_callback' => 'sanitize_text_field',
		'panel'  => 'front_page_panel',
	) );
	$wp_customize->add_control( 'call_action_button_description', array(
		'label'    => __( 'Button Description: ', 'pridehost' ),
		'section'  => 'action_section',
		'settings' => 'call_action_button_description'	
	) );	

	// Call To Action Button link

	$wp_customize->add_setting('call_action_button_link', array(
        'sanitize_callback' => 'esc_url_raw',
		'panel'  => 'front_page_panel',
		'default' => '#',
    ) );
	$wp_customize->add_control('call_action_button_link', array(
        'label' => __('Button Link URL','pridehost'),
        'section' => 'action_section',
        'type' => 'url',
    ) );		

/* END Call To Action Section */

/* END Custom-Page Setting Panel */

}

add_action( 'customize_register', 'homepage_customizer_register' );

?>