<?php
/**
* Template Name: Custom Page
*/

get_header();

?>

<div class="main-section" >
	<div class="container" >
		<div class="row">
			<div class="col-sm-6" > 
				<div class="section-1-1">
					<h2>
						<?php echo esc_html(get_theme_mod('Welcome_message_heading','Best web hosting service for your website.')); ?>
					</h2>
					<p>
						<?php echo esc_html(get_theme_mod('Welcome_message_description','Get the best speed for your website. Do Not lose anymore clients for the slowest speed of your hosting service. ')); ?>
					</p>

					<a class="btn btn-link button-1" href="<?php echo esc_url(get_theme_mod( 'first_section_button1_link', '#' )); ?>">
						<?php echo esc_html(get_theme_mod( 'first_section_button1_description', 'Get Started Now' )); ?>
					</a>

				</div>
			</div>

			<div class="col-sm-6" > 
				<div class="section-1-2">
					<?php $img2 =get_template_directory_uri().'/images/server.jpg'; ?>
					<img src="<?php echo esc_url(get_theme_mod( 'first_section_image', $img2 )); ?>">
				</div>
			</div>
		</div>
		<div class="section-2" >
		<hr>
		<h1 class="aligncenter"><?php esc_html_e('Why Choose Us?','pridehost') ?></h1>

			<div class="row">

				<div class="col-sm-4">
					<h3>
						<?php echo esc_html(get_theme_mod('choose_us_heading_1', 'Easy to Customize')); ?>
					</h3>
					<p>
						<?php echo esc_html(get_theme_mod('choose_us_description_1', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.')); ?>
					</p>
				</div>

				<div class="col-sm-4">
					<h3>
						<?php echo esc_html(get_theme_mod('choose_us_heading_2', 'Secured Servers')); ?>
					</h3>
					<p>
						<?php echo esc_html(get_theme_mod('choose_us_description_2', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.')); ?>
					</p>
				</div>

				<div class="col-sm-4">
					<h3>
						<?php echo esc_html(get_theme_mod('choose_us_heading_3', '24/7 customer support')); ?>
					</h3>
					<p>
						<?php echo esc_html(get_theme_mod('choose_us_description_3', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.')); ?>
					</p>
				</div>
			</div>
		</div>
		<hr>
		<div class="section-3">
		<h1 class="aligncenter"><?php esc_html_e('Our Plans','pridehost') ?></h1>
			<div class="row">	
				<div class="col-sm-4">
					<div class="plan-1">
						<h3 class="aligncenter">
							<?php echo esc_html(get_theme_mod('plan_heading_1','Personal Plan')); ?>
						</h3>
						<h6 class="aligncenter">
							<?php echo esc_html(get_theme_mod('plan_price_1','$3/m')); ?>
						</h6>
						<p class="aligncenter">
							<?php echo esc_html(get_theme_mod('plan_description_1','Best for personal use')); ?>
						</p>

						<div class="specs">
							<p><?php echo esc_html(get_theme_mod('plan1_spec_1','10GB Space')); ?></p>
							<p><?php echo esc_html(get_theme_mod('plan1_spec_2','1 Free Domain')); ?></p>
							<p><?php echo esc_html(get_theme_mod('plan1_spec_3','300GB SSD Disk')); ?></p>
							<p><?php echo esc_html(get_theme_mod('plan1_spec_4','Special Offers')); ?></p>
							<p><?php echo esc_html(get_theme_mod('plan1_spec_5','Unlimited Support')); ?></p>
						</div>
						<div class="aligncenter plan-button">
							<a class="btn btn-link" href="<?php echo esc_url(get_theme_mod( 'plan1_button_link', '#' )); ?>">
								<?php echo esc_html(get_theme_mod( 'plan1_button_description', 'Get Started Now' )); ?>
							</a>
						</div>
					</div>
				</div>
				<div class="col-sm-4">
					<div class="plan-2">
						<h3 class="aligncenter">
							<?php echo esc_html(get_theme_mod('plan_heading_2','SMALL TEAM')); ?>
						</h3>
						<h6 class="aligncenter">
							<?php echo esc_html(get_theme_mod('plan_price_2','$10/m')); ?>
						</h6>
						<p class="aligncenter">
							<?php echo esc_html(get_theme_mod('plan_description_2','Best for small team use')); ?>
						</p>

						<div class="specs">
							<p><?php echo esc_html(get_theme_mod('plan2_spec_1','10GB Space')); ?></p>
							<p><?php echo esc_html(get_theme_mod('plan2_spec_2','1 Free Domain')); ?></p>
							<p><?php echo esc_html(get_theme_mod('plan2_spec_3','300GB SSD Disk')); ?></p>
							<p><?php echo esc_html(get_theme_mod('plan2_spec_4','Special Offers')); ?></p>
							<p><?php echo esc_html(get_theme_mod('plan2_spec_5','Unlimited Support')); ?></p>
						</div>
						<div class="aligncenter plan-button">
							<a class="btn btn-link" href="<?php echo esc_url(get_theme_mod( 'plan2_button_link', '#' )); ?>">
								<?php echo esc_html(get_theme_mod( 'plan2_button_description', 'Get Started Now' )); ?>
							</a>
						</div>
					</div>
				</div>
				<div class="col-sm-4">
					<div class="plan-3">
						<h3 class="aligncenter">
							<?php echo esc_html(get_theme_mod('plan_heading_3','COMPANY')); ?>
						</h3>
						<h6 class="aligncenter">
							<?php echo esc_html(get_theme_mod('plan_price_3','$25/m')); ?>
						</h6>
						<p class="aligncenter">
							<?php echo esc_html(get_theme_mod('plan_description_3','Best for company use')); ?>
						</p>

						<div class="specs">
							<p><?php echo esc_html(get_theme_mod('plan3_spec_1','10GB Space')); ?></p>
							<p><?php echo esc_html(get_theme_mod('plan3_spec_2','1 Free Domain')); ?></p>
							<p><?php echo esc_html(get_theme_mod('plan3_spec_3','300GB SSD Disk')); ?></p>
							<p><?php echo esc_html(get_theme_mod('plan3_spec_4','Special Offers')); ?></p>
							<p><?php echo esc_html(get_theme_mod('plan3_spec_5','Unlimited Support')); ?></p>
						</div>
						<div class="aligncenter plan-button">
							<a class="btn btn-link" href="<?php echo esc_url(get_theme_mod( 'plan3_button_link', '#' )); ?>">
								<?php echo esc_html(get_theme_mod( 'plan3_button_description', 'Get Started Now' )); ?>
							</a>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="section-4">
			<div class="row">
				<div class="col-sm-12">
					<h1 class="aligncenter"><?php esc_html_e('Latest Helpful Articles','pridehost'); ?></h1>
					<?php get_template_part('latest-articles'); ?>
				</div>
			</div>
		</div>

	</div>

	<div class="clients">
		<div class="container">
			<div class="row">
				<div class="col-sm-12">
					<h1 class="aligncenter"><?php echo esc_html(get_theme_mod('call_action_heading', '20,000+ trusted Clients! Be one of them today')); ?></h1>
					<div class="aligncenter plan-button">
						<a class="btn btn-link" href="<?php echo esc_url(get_theme_mod( 'call_action_button_link', '#' )); ?>">
							<?php echo esc_html(get_theme_mod( 'call_action_button_description', 'Get Started Now' )); ?>
						</a>
					</div>
				</div>
			</div>
		</div>
	</div>

</div>


<?php get_footer(); ?>