<?php
/**
 * Title: Testimonial section
 * Slug: pressmono/testimonials
 * Categories: pressmono
 * Description: A testimonial section with headings, quotes, and star ratings.
 * Viewport Width: 1100
 */
?>
<!-- wp:group {"layout":{"type":"constrained","contentSize":"1000px"},"style":{"spacing":{"padding":{"top":"2.75rem","bottom":"2.75rem"}}}} -->
<div class="wp-block-group" style="padding-top:2.75rem;padding-bottom:2.75rem">
	<!-- wp:heading {"textAlign":"center","fontSize":"3xl"} -->
	<h2 class="wp-block-heading has-text-align-center has-3-xl-font-size"><?php esc_html_e( 'What people say', 'pressmono' ); ?></h2>
	<!-- /wp:heading -->
	<!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"0.25rem","bottom":"1.5rem"}}},"textColor":"muted"} -->
	<p class="has-text-align-center has-muted-color has-text-color" style="margin-top:0.25rem;margin-bottom:1.5rem"><?php esc_html_e( 'Real feedback from teams using PressMono in production.', 'pressmono' ); ?></p>
	<!-- /wp:paragraph -->
	<!-- wp:columns {"align":"wide"} -->
	<div class="wp-block-columns alignwide">
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"spacing":{"blockGap":"0.5rem"},"border":{"radius":"0.5rem","color":"var(--wp--preset--color--muted)","width":"1px"},"spacing":{"padding":{"top":"1rem","right":"1rem","bottom":"1rem","left":"1rem"}}}} -->
			<div class="wp-block-group" style="border-color:var(--wp--preset--color--muted);border-width:1px;border-radius:0.5rem;padding-top:1rem;padding-right:1rem;padding-bottom:1rem;padding-left:1rem">
				<!-- wp:paragraph {"style":{"typography":{"letterSpacing":"0.05em"}}} -->
				<p style="letter-spacing:0.05em" aria-label="<?php esc_attr_e( '5 out of 5 stars', 'pressmono' ); ?>">★★★★★</p>
				<!-- /wp:paragraph -->
				<!-- wp:quote -->
				<blockquote class="wp-block-quote"><p><?php esc_html_e( 'PressMono made our site refresh fast and straightforward.', 'pressmono' ); ?></p><cite><?php esc_html_e( 'Alex, Site Owner', 'pressmono' ); ?></cite></blockquote>
				<!-- /wp:quote -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"spacing":{"blockGap":"0.5rem"},"border":{"radius":"0.5rem","color":"var(--wp--preset--color--muted)","width":"1px"},"spacing":{"padding":{"top":"1rem","right":"1rem","bottom":"1rem","left":"1rem"}}}} -->
			<div class="wp-block-group" style="border-color:var(--wp--preset--color--muted);border-width:1px;border-radius:0.5rem;padding-top:1rem;padding-right:1rem;padding-bottom:1rem;padding-left:1rem">
				<!-- wp:paragraph {"style":{"typography":{"letterSpacing":"0.05em"}}} -->
				<p style="letter-spacing:0.05em" aria-label="<?php esc_attr_e( '5 out of 5 stars', 'pressmono' ); ?>">★★★★★</p>
				<!-- /wp:paragraph -->
				<!-- wp:quote -->
				<blockquote class="wp-block-quote"><p><?php esc_html_e( 'The patterns give editors a strong head start for every page.', 'pressmono' ); ?></p><cite><?php esc_html_e( 'Priya, Editor', 'pressmono' ); ?></cite></blockquote>
				<!-- /wp:quote -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"spacing":{"blockGap":"0.5rem"},"border":{"radius":"0.5rem","color":"var(--wp--preset--color--muted)","width":"1px"},"spacing":{"padding":{"top":"1rem","right":"1rem","bottom":"1rem","left":"1rem"}}}} -->
			<div class="wp-block-group" style="border-color:var(--wp--preset--color--muted);border-width:1px;border-radius:0.5rem;padding-top:1rem;padding-right:1rem;padding-bottom:1rem;padding-left:1rem">
				<!-- wp:paragraph {"style":{"typography":{"letterSpacing":"0.05em"}}} -->
				<p style="letter-spacing:0.05em" aria-label="<?php esc_attr_e( '5 out of 5 stars', 'pressmono' ); ?>">★★★★★</p>
				<!-- /wp:paragraph -->
				<!-- wp:quote -->
				<blockquote class="wp-block-quote"><p><?php esc_html_e( 'Clean, accessible, and easy to customize with core blocks.', 'pressmono' ); ?></p><cite><?php esc_html_e( 'Sam, Developer', 'pressmono' ); ?></cite></blockquote>
				<!-- /wp:quote -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
