<?php
/**
 * Title: Services grid
 * Slug: pressmono/services-grid
 * Categories: pressmono, featured
 * Description: A responsive 6-card grid with headings, descriptions, and optional buttons.
 * Viewport Width: 1200
 */
?>
<!-- wp:group {"layout":{"type":"constrained","contentSize":"1100px"},"style":{"spacing":{"padding":{"top":"2.5rem","bottom":"2.5rem"}}}} -->
<div class="wp-block-group" style="padding-top:2.5rem;padding-bottom:2.5rem">
	<!-- wp:heading {"textAlign":"center","fontSize":"3xl"} -->
	<h2 class="wp-block-heading has-text-align-center has-3-xl-font-size"><?php esc_html_e( 'What we do', 'pressmono' ); ?></h2>
	<!-- /wp:heading -->
	<!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"0.25rem","bottom":"1.5rem"}}},"textColor":"muted"} -->
	<p class="has-text-align-center has-muted-color has-text-color" style="margin-top:0.25rem;margin-bottom:1.5rem"><?php esc_html_e( 'Flexible building blocks to cover common sections and layouts.', 'pressmono' ); ?></p>
	<!-- /wp:paragraph -->
	<!-- wp:columns {"align":"wide"} -->
	<div class="wp-block-columns alignwide">
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"spacing":{"blockGap":"0.5rem","padding":{"top":"1.25rem","right":"1.25rem","bottom":"1.25rem","left":"1.25rem"}},"border":{"radius":"0.5rem","color":"var(--wp--preset--color--muted)","width":"1px"}}} -->
			<div class="wp-block-group" style="border-color:var(--wp--preset--color--muted);border-width:1px;border-radius:0.5rem;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem">
				<!-- wp:heading {"level":3,"fontSize":"xl"} -->
				<h3 class="wp-block-heading has-xl-font-size"><?php esc_html_e( 'Fast performance', 'pressmono' ); ?></h3>
				<!-- /wp:heading -->
				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'Lean styles and block-first approach to deliver a speedy experience.', 'pressmono' ); ?></p>
				<!-- /wp:paragraph -->
				<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"0.5rem"}}}} -->
				<div class="wp-block-buttons" style="margin-top:0.5rem">
					<!-- wp:button {"className":"is-style-outline"} -->
					<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e( 'Learn more', 'pressmono' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"spacing":{"blockGap":"0.5rem","padding":{"top":"1.25rem","right":"1.25rem","bottom":"1.25rem","left":"1.25rem"}},"border":{"radius":"0.5rem","color":"var(--wp--preset--color--muted)","width":"1px"}}} -->
			<div class="wp-block-group" style="border-color:var(--wp--preset--color--muted);border-width:1px;border-radius:0.5rem;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem">
				<!-- wp:heading {"level":3,"fontSize":"xl"} -->
				<h3 class="wp-block-heading has-xl-font-size"><?php esc_html_e( 'Accessible by default', 'pressmono' ); ?></h3>
				<!-- /wp:heading -->
				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'Meets WCAG 2.1 AA guidance and uses semantic HTML wherever possible.', 'pressmono' ); ?></p>
				<!-- /wp:paragraph -->
				<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"0.5rem"}}}} -->
				<div class="wp-block-buttons" style="margin-top:0.5rem">
					<!-- wp:button {"className":"is-style-outline"} -->
					<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e( 'Learn more', 'pressmono' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"spacing":{"blockGap":"0.5rem","padding":{"top":"1.25rem","right":"1.25rem","bottom":"1.25rem","left":"1.25rem"}},"border":{"radius":"0.5rem","color":"var(--wp--preset--color--muted)","width":"1px"}}} -->
			<div class="wp-block-group" style="border-color:var(--wp--preset--color--muted);border-width:1px;border-radius:0.5rem;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem">
				<!-- wp:heading {"level":3,"fontSize":"xl"} -->
				<h3 class="wp-block-heading has-xl-font-size"><?php esc_html_e( 'Editor-friendly', 'pressmono' ); ?></h3>
				<!-- /wp:heading -->
				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'Thoughtful defaults and patterns give editors a strong starting point.', 'pressmono' ); ?></p>
				<!-- /wp:paragraph -->
				<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"0.5rem"}}}} -->
				<div class="wp-block-buttons" style="margin-top:0.5rem">
					<!-- wp:button {"className":"is-style-outline"} -->
					<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e( 'Learn more', 'pressmono' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
	<!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"top":"1rem"}}}} -->
	<div class="wp-block-columns alignwide" style="margin-top:1rem">
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"spacing":{"blockGap":"0.5rem","padding":{"top":"1.25rem","right":"1.25rem","bottom":"1.25rem","left":"1.25rem"}},"border":{"radius":"0.5rem","color":"var(--wp--preset--color--muted)","width":"1px"}}} -->
			<div class="wp-block-group" style="border-color:var(--wp--preset--color--muted);border-width:1px;border-radius:0.5rem;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem">
				<!-- wp:heading {"level":3,"fontSize":"xl"} -->
				<h3 class="wp-block-heading has-xl-font-size"><?php esc_html_e( 'Scalable layouts', 'pressmono' ); ?></h3>
				<!-- /wp:heading -->
				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'Columns and groups adapt to your content without extra CSS.', 'pressmono' ); ?></p>
				<!-- /wp:paragraph -->
				<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"0.5rem"}}}} -->
				<div class="wp-block-buttons" style="margin-top:0.5rem">
					<!-- wp:button {"className":"is-style-outline"} -->
					<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e( 'Learn more', 'pressmono' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"spacing":{"blockGap":"0.5rem","padding":{"top":"1.25rem","right":"1.25rem","bottom":"1.25rem","left":"1.25rem"}},"border":{"radius":"0.5rem","color":"var(--wp--preset--color--muted)","width":"1px"}}} -->
			<div class="wp-block-group" style="border-color:var(--wp--preset--color--muted);border-width:1px;border-radius:0.5rem;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem">
				<!-- wp:heading {"level":3,"fontSize":"xl"} -->
				<h3 class="wp-block-heading has-xl-font-size"><?php esc_html_e( 'Global styles', 'pressmono' ); ?></h3>
				<!-- /wp:heading -->
				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'Change colors and typography once, reuse across the site.', 'pressmono' ); ?></p>
				<!-- /wp:paragraph -->
				<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"0.5rem"}}}} -->
				<div class="wp-block-buttons" style="margin-top:0.5rem">
					<!-- wp:button {"className":"is-style-outline"} -->
					<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e( 'Learn more', 'pressmono' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"spacing":{"blockGap":"0.5rem","padding":{"top":"1.25rem","right":"1.25rem","bottom":"1.25rem","left":"1.25rem"}},"border":{"radius":"0.5rem","color":"var(--wp--preset--color--muted)","width":"1px"}}} -->
			<div class="wp-block-group" style="border-color:var(--wp--preset--color--muted);border-width:1px;border-radius:0.5rem;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem">
				<!-- wp:heading {"level":3,"fontSize":"xl"} -->
				<h3 class="wp-block-heading has-xl-font-size"><?php esc_html_e( 'Editor patterns', 'pressmono' ); ?></h3>
				<!-- /wp:heading -->
				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'Drop-in sections like hero, testimonials, and CTAs to move faster.', 'pressmono' ); ?></p>
				<!-- /wp:paragraph -->
				<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"0.5rem"}}}} -->
				<div class="wp-block-buttons" style="margin-top:0.5rem">
					<!-- wp:button {"className":"is-style-outline"} -->
					<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e( 'Learn more', 'pressmono' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
