<?php
/**
 * Title: Hero section
 * Slug: pressmono/hero
 * Categories: pressmono, featured
 * Description: A large hero section with gradient overlay, CTA buttons, search, and quick stats.
 * Viewport Width: 1400
 */
?>
<!-- wp:cover {"gradient":"primary-to-accent","dimRatio":85,"isDark":true,"minHeight":70,"minHeightUnit":"vh"} -->
<div class="wp-block-cover is-light" style="min-height:70vh">
	<span aria-hidden="true" class="wp-block-cover__background has-background-dim-85 has-background-dim has-primary-to-accent-gradient-background"></span>
	<div class="wp-block-cover__inner-container">
		<!-- wp:group {"layout":{"type":"constrained","contentSize":"1000px"},"style":{"spacing":{"padding":{"top":"3.5rem","bottom":"3.5rem"}}}} -->
		<div class="wp-block-group" style="padding-top:3.5rem;padding-bottom:3.5rem">
			<!-- wp:heading {"textAlign":"center","level":1,"fontSize":"5xl","textColor":"background"} -->
			<h1 class="wp-block-heading has-text-align-center has-background-color has-text-color has-5-xl-font-size"><?php esc_html_e( 'Build fast, accessible sites with PressMono', 'pressmono' ); ?></h1>
			<!-- /wp:heading -->
			<!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.7"}},"textColor":"surface"} -->
			<p class="has-text-align-center has-surface-color has-text-color" style="line-height:1.7"><?php esc_html_e( 'A modern Full Site Editing theme that uses only core blocks and follows WordPress coding standards.', 'pressmono' ); ?></p>
			<!-- /wp:paragraph -->
			<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"1.5rem"}}}} -->
			<div class="wp-block-buttons" style="margin-top:1.5rem">
				<!-- wp:button {"backgroundColor":"primary"} -->
				<div class="wp-block-button"><a class="wp-block-button__link has-primary-background-color has-background wp-element-button" href="#get-started"><?php esc_html_e( 'Get started', 'pressmono' ); ?></a></div>
				<!-- /wp:button -->
				<!-- wp:button {"className":"is-style-outline","textColor":"background","style":{"border":{"radius":"0.375rem"}}} -->
				<div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-background-color has-text-color wp-element-button" href="#learn-more"><?php esc_html_e( 'Learn more', 'pressmono' ); ?></a></div>
				<!-- /wp:button -->
			</div>
			<!-- /wp:buttons -->

			<!-- wp:group {"layout":{"type":"constrained","contentSize":"800px"},"style":{"spacing":{"margin":{"top":"1.75rem"}}}} -->
			<div class="wp-block-group" style="margin-top:1.75rem">
				<!-- wp:search {"label":"<?php esc_attr_e( 'Search', 'pressmono' ); ?>","showLabel":false,"buttonText":"<?php esc_attr_e( 'Search', 'pressmono' ); ?>","buttonUseIcon":true,"buttonPosition":"button-inside","style":{"border":{"radius":"0.375rem"}}} /-->
			</div>
			<!-- /wp:group -->

			<!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"top":"2rem"}}}} -->
			<div class="wp-block-columns alignwide" style="margin-top:2rem">
				<!-- wp:column -->
				<div class="wp-block-column">
					<!-- wp:group {"style":{"spacing":{"blockGap":"0.25rem"}},"layout":{"type":"constrained"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"textAlign":"center","level":3,"fontSize":"xl","textColor":"background"} -->
						<h3 class="wp-block-heading has-text-align-center has-background-color has-text-color has-xl-font-size"><?php esc_html_e( '100% core blocks', 'pressmono' ); ?></h3>
						<!-- /wp:heading -->
						<!-- wp:paragraph {"align":"center","textColor":"surface"} -->
						<p class="has-text-align-center has-surface-color has-text-color"><?php esc_html_e( 'No dependencies', 'pressmono' ); ?></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:column -->
				<!-- wp:column -->
				<div class="wp-block-column">
					<!-- wp:group {"style":{"spacing":{"blockGap":"0.25rem"}},"layout":{"type":"constrained"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"textAlign":"center","level":3,"fontSize":"xl","textColor":"background"} -->
						<h3 class="wp-block-heading has-text-align-center has-background-color has-text-color has-xl-font-size"><?php esc_html_e( 'WCAG mindful', 'pressmono' ); ?></h3>
						<!-- /wp:heading -->
						<!-- wp:paragraph {"align":"center","textColor":"surface"} -->
						<p class="has-text-align-center has-surface-color has-text-color"><?php esc_html_e( 'Accessible defaults', 'pressmono' ); ?></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:column -->
				<!-- wp:column -->
				<div class="wp-block-column">
					<!-- wp:group {"style":{"spacing":{"blockGap":"0.25rem"}},"layout":{"type":"constrained"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"textAlign":"center","level":3,"fontSize":"xl","textColor":"background"} -->
						<h3 class="wp-block-heading has-text-align-center has-background-color has-text-color has-xl-font-size"><?php esc_html_e( 'Performance-first', 'pressmono' ); ?></h3>
						<!-- /wp:heading -->
						<!-- wp:paragraph {"align":"center","textColor":"surface"} -->
						<p class="has-text-align-center has-surface-color has-text-color"><?php esc_html_e( 'Lean styles', 'pressmono' ); ?></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:column -->
			</div>
			<!-- /wp:columns -->
		</div>
		<!-- /wp:group -->
	</div>
	<!-- /wp:cover -->
</div>
<!-- /wp:cover -->



