<?php
/**
 * Title: Call to action
 * Slug: pressmono/call-to-action
 * Categories: pressmono, featured
 * Description: A full-width call-to-action band with benefits and dual buttons.
 * Viewport Width: 1200
 */
?>
<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"2.25rem","bottom":"2.25rem"}}},"gradient":"midnight","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-midnight-gradient-background has-background" style="padding-top:2.25rem;padding-bottom:2.25rem">
	<!-- wp:columns {"verticalAlignment":"center"} -->
	<div class="wp-block-columns are-vertically-aligned-center">
		<!-- wp:column {"verticalAlignment":"center"} -->
		<div class="wp-block-column is-vertically-aligned-center">
			<!-- wp:heading {"level":3,"textColor":"background"} -->
			<h3 class="wp-block-heading has-background-color has-text-color"><?php esc_html_e( 'Ready to build with PressMono?', 'pressmono' ); ?></h3>
			<!-- /wp:heading -->
			<!-- wp:paragraph {"textColor":"surface"} -->
			<p class="has-surface-color has-text-color"><?php esc_html_e( 'Start creating beautiful pages using only WordPress core blocks.', 'pressmono' ); ?></p>
			<!-- /wp:paragraph -->
			<!-- wp:list {"textColor":"surface","className":"is-style-checklist","style":{"spacing":{"margin":{"top":"0.5rem"}}}} -->
			<ul class="is-style-checklist has-surface-color has-text-color" style="margin-top:0.5rem">
				<li><?php esc_html_e( 'No plugins required', 'pressmono' ); ?></li>
				<li><?php esc_html_e( 'WCAG-minded defaults', 'pressmono' ); ?></li>
				<li><?php esc_html_e( 'Global styles via theme.json', 'pressmono' ); ?></li>
			</ul>
			<!-- /wp:list -->
		</div>
		<!-- /wp:column -->
		<!-- wp:column {"verticalAlignment":"center"} -->
		<div class="wp-block-column is-vertically-aligned-center">
			<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"right"}} -->
			<div class="wp-block-buttons">
				<!-- wp:button {"backgroundColor":"accent"} -->
				<div class="wp-block-button"><a class="wp-block-button__link has-accent-background-color has-background wp-element-button" href="#get-started"><?php esc_html_e( 'Get started', 'pressmono' ); ?></a></div>
				<!-- /wp:button -->
				<!-- wp:button {"className":"is-style-outline","textColor":"background"} -->
				<div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-background-color has-text-color wp-element-button" href="#learn-more"><?php esc_html_e( 'Learn more', 'pressmono' ); ?></a></div>
				<!-- /wp:button -->
			</div>
			<!-- /wp:buttons -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->



