<?php
/**
 * PressMono functions and definitions
 *
 * @package PressMono
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Setup theme supports and textdomain.
 */
function pressmono_setup() {
	load_theme_textdomain( 'pressmono', get_template_directory() . '/languages' );

	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );

	// FSE / Block themes.
	add_theme_support( 'block-templates' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'editor-styles' );

	// HTML5 support.
	add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption', 'style', 'script', 'navigation-widgets' ) );
}
add_action( 'after_setup_theme', 'pressmono_setup' );

/**
 * Enqueue frontend assets with file modification based versioning.
 */
function pressmono_enqueue_assets() {
	$style_rel_path = 'assets/css/frontend.css';
	$script_rel_path = 'assets/js/frontend.js';

	$style_path = get_theme_file_path( $style_rel_path );
	$script_path = get_theme_file_path( $script_rel_path );

	$style_ver = file_exists( $style_path ) ? (string) filemtime( $style_path ) : wp_get_theme()->get( 'Version' );
	$script_ver = file_exists( $script_path ) ? (string) filemtime( $script_path ) : wp_get_theme()->get( 'Version' );

	if ( file_exists( $style_path ) ) {
		wp_enqueue_style( 'pressmono-frontend', get_theme_file_uri( $style_rel_path ), array(), $style_ver );
	}

	if ( file_exists( $script_path ) ) {
		wp_enqueue_script( 'pressmono-frontend', get_theme_file_uri( $script_rel_path ), array(), $script_ver, true );
	}
}
add_action( 'wp_enqueue_scripts', 'pressmono_enqueue_assets' );

/**
 * Register custom block pattern categories.
 * Patterns in /patterns are auto-registered by WordPress.
 */
function pressmono_register_pattern_categories() {
	if ( function_exists( 'register_block_pattern_category' ) ) {
		register_block_pattern_category(
			'pressmono',
			array(
				'label' => __( 'PressMono', 'pressmono' ),
			)
		);
		register_block_pattern_category(
			'pressmono-sections',
			array(
				'label' => __( 'PressMono Sections', 'pressmono' ),
			)
		);
	}
}
add_action( 'init', 'pressmono_register_pattern_categories' );

/**
 * Register additional block styles.
 */
function pressmono_register_block_styles() {
	if ( ! function_exists( 'register_block_style' ) ) {
		return;
	}

	register_block_style(
		'core/quote',
		array(
			'name'         => 'mono-outline',
			'label'        => __( 'Mono Outline', 'pressmono' ),
			'inline_style' => '.is-style-mono-outline{border:1px solid currentColor;padding:1.25em 1.5em;border-radius:.375rem;}',
		)
	);

	register_block_style(
		'core/image',
		array(
			'name'         => 'mono-shadow',
			'label'        => __( 'Mono Shadow', 'pressmono' ),
			'inline_style' => '.is-style-mono-shadow img{box-shadow:0 4px 10px rgba(0,0,0,.08);border-radius:.375rem;}',
		)
	);
}
add_action( 'init', 'pressmono_register_block_styles' );



