<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Prespa
 */

get_header();
?>
<!--Site wrapper-->
<div class="site-wrapper">
	<main id="primary" class="site-main">

		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<?php
				the_archive_title( '<h1 class="page-title">', '</h1>' );
				the_archive_description( '<div class="archive-description">', '</div>' );
				?>
			</header><!-- .page-header -->
			<div class="prespa-post-container">
				<div class="prespa-post-inner" <?php prespa_schema_microdata( 'blog' )?>>
			<?php
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();

				/*
				 * Include the Post-Type-specific template for the content.
				 * If you want to override this in a child theme, then include a file
				 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
				 */
				if ( prespa_is_excerpt() ) :
					get_template_part( 'template-parts/content-excerpt', get_post_type() );
				else :
					get_template_part( 'template-parts/content', get_post_type() );
				endif;

			endwhile;
				echo '</div>';
			echo '</div>';
			do_action('prespa_pagination_hook');
		else :

			get_template_part( 'template-parts/content', 'none' );

		endif;
		?>

	</main><!-- #main -->
	<?php if( !prespa_is_post_archives_fullwidth() ) : get_sidebar(); endif; ?>
</div>

<?php get_footer();