<?php
/**
  * Title: Lessons
  * Slug: prespa-lms/lessons
  * Categories: prespa-lms
*/
?>

<!-- wp:group {"metadata":{"name":"Lessons","categories":["prespa-lms"],"patternName":"prespa-lms/lessons"},"align":"full","style":{"spacing":{"blockGap":"0","margin":{"top":"var:preset|spacing|small","bottom":"var:preset|spacing|small"},"padding":{"top":"var:preset|spacing|large","bottom":"var:preset|spacing|large"}}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-white-background-color has-background" style="margin-top:var(--wp--preset--spacing--small);margin-bottom:var(--wp--preset--spacing--small);padding-top:var(--wp--preset--spacing--large);padding-bottom:var(--wp--preset--spacing--large)"><!-- wp:spacer {"height":"0px"} -->
<div style="height:0px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"className":"p-animation-text-moveUp","style":{"spacing":{"blockGap":"0","margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium","left":"var:preset|spacing|small","right":"var:preset|spacing|small"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group p-animation-text-moveUp" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--medium);padding-right:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--medium);padding-left:var(--wp--preset--spacing--small)"><!-- wp:heading {"level":6,"style":{"color":{"text":"#356df1"},"elements":{"link":{"color":{"text":"#356df1"}}}}} -->
<h6 class="wp-block-heading has-text-color has-link-color" style="color:#356df1"><?php esc_html_e( 'STUDY SESSIONS', 'prespa-lms' ); ?></h6>
<!-- /wp:heading -->

<!-- wp:heading {"fontSize":"large"} -->
<h2 class="wp-block-heading has-large-font-size"><span style="color:#356df1"><?php esc_html_e( 'Engaging All Learners:', 'prespa-lms' ); ?></span> <?php esc_html_e( 'A Rich Mix of Lesson Formats.', 'prespa-lms' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:heading -->
<h2 class="wp-block-heading"><?php esc_html_e( 'From video to interactive quizzes', 'prespa-lms' ); ?></h2>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:columns {"className":"p-animation-text-moveUp","style":{"spacing":{"padding":{"top":"0.75rem","bottom":"0.75rem"}}}} -->
<div class="wp-block-columns p-animation-text-moveUp" style="padding-top:0.75rem;padding-bottom:0.75rem"><!-- wp:column {"width":"66.66%","style":{"spacing":{"padding":{"top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium","left":"var:preset|spacing|medium","right":"var:preset|spacing|medium"}},"color":{"background":"#f8f8f8"},"border":{"radius":"10px"}}} -->
<div class="wp-block-column has-background" style="border-radius:10px;background-color:#f8f8f8;padding-top:var(--wp--preset--spacing--medium);padding-right:var(--wp--preset--spacing--medium);padding-bottom:var(--wp--preset--spacing--medium);padding-left:var(--wp--preset--spacing--medium);flex-basis:66.66%"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php esc_html_e( 'Lesson Creation Studio', 'prespa-lms' ); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Our advanced editor allows you to easily craft rich lessons with seamless audio and video support, all through a clean, intuitive interface.', 'prespa-lms' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:image {"id":2276,"width":"540px","aspectRatio":"16/9","scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/img/pl-patterns/creation-studio.png" alt="" class="wp-image-2276" style="aspect-ratio:16/9;object-fit:cover;width:540px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"33.33%","style":{"spacing":{"padding":{"top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium","left":"var:preset|spacing|medium","right":"var:preset|spacing|medium"}},"color":{"background":"#f8f8f8"},"border":{"radius":"10px"}}} -->
<div class="wp-block-column has-background" style="border-radius:10px;background-color:#f8f8f8;padding-top:var(--wp--preset--spacing--medium);padding-right:var(--wp--preset--spacing--medium);padding-bottom:var(--wp--preset--spacing--medium);padding-left:var(--wp--preset--spacing--medium);flex-basis:33.33%"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php esc_html_e( 'Video', 'prespa-lms' ); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Boost Engagement with Dynamic Video Lessons. Easily embed videos from YouTube, Vimeo, or your own library directly into your lessons to create a truly captivating and effective learning environment.', 'prespa-lms' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:image {"id":2204,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/img/pl-patterns/video.png" alt="" class="wp-image-2204"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"className":"p-animation-text-moveUp"} -->
<div class="wp-block-columns p-animation-text-moveUp"><!-- wp:column {"width":"33.33%","style":{"spacing":{"padding":{"top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium","left":"var:preset|spacing|medium","right":"var:preset|spacing|medium"}},"color":{"background":"#f8f8f8"},"border":{"radius":"10px"}}} -->
<div class="wp-block-column has-background" style="border-radius:10px;background-color:#f8f8f8;padding-top:var(--wp--preset--spacing--medium);padding-right:var(--wp--preset--spacing--medium);padding-bottom:var(--wp--preset--spacing--medium);padding-left:var(--wp--preset--spacing--medium);flex-basis:33.33%"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php esc_html_e( 'Live Broadcast', 'prespa-lms' ); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Dynamic Video Embedding: Enhance lessons from multiple sources.', 'prespa-lms' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:image {"id":2278,"sizeSlug":"large","linkDestination":"none"} -->
<figure class="wp-block-image size-large"><img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/img/pl-patterns/broadcast.jpg" alt="" class="wp-image-2278"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"66.66%","style":{"spacing":{"padding":{"top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium","left":"var:preset|spacing|medium","right":"var:preset|spacing|medium"}},"color":{"background":"#f8f8f8"},"border":{"radius":"10px"}}} -->
<div class="wp-block-column has-background" style="border-radius:10px;background-color:#f8f8f8;padding-top:var(--wp--preset--spacing--medium);padding-right:var(--wp--preset--spacing--medium);padding-bottom:var(--wp--preset--spacing--medium);padding-left:var(--wp--preset--spacing--medium);flex-basis:66.66%"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php esc_html_e( 'Your Learning Toolkit', 'prespa-lms' ); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Elevate your learning and take key insights with you. Explore our downloadable resources: practical guides, helpful checklists, templates, and summaries designed to support your journey', 'prespa-lms' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:image {"id":2272,"width":"568px","height":"auto","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/assets/img/pl-patterns/toolkit.png" alt="" class="wp-image-2272" style="width:568px;height:auto"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->