<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo( 'charset' ); ?>" />
<title><?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add the blog description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s'), max( $paged, $page ) );

	?></title>
<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div id="header">
<div id="header-content">
<div id="logo"><a href="<?php echo home_url( '/' ); ?>"><?php bloginfo('name'); ?></a></div>
<div id="slogan"><?php if(get_bloginfo('description')): ?><?php bloginfo('description'); ?><?php endif; ?></div>
<div id="header-menu">
<ul id="nav">
<?php mbs_nav_menu(); ?>
</ul>
</div>

</div>
</div>

<div id="pre-wrapp">
<div id="wrapp">
<div id="content">