/* ===============================================
  SLIDER
=============================================== */

const options = {
  slidesToShow: 1,
  slidesToScroll: 1,
  dots: true,
  arrows: false,
  adaptiveHeight: true,
  autoplay: true
};

// my slick slider as constant object
const mySlider = jQuery('.slider').on('init', function(slick) {

  // constant var
  const slider = this;

  // slight delay so init completes render
  setTimeout(function() {

    // dot buttons
    let dots = jQuery('.slick-dots > li > button', slider);

    // each dot button function
    jQuery.each(dots, function(i,e) {

      // slide id
      let slide_id = jQuery(this).attr('aria-controls');

      //console.log(slide_id);

      // custom dot image
      let dot_img = jQuery('#'+slide_id).data('dot-img');
      // console.log(dot_img);

      jQuery(this).html('<img src="' + dot_img + '" alt="" />');

    });

  }, 100);

}).slick(options);

/* ===============================================
  OWL CAROUSEL SLIDER
=============================================== */

jQuery('document').ready(function(){
  var owl = jQuery('.project .owl-carousel');
    owl.owlCarousel({
    margin:20,
    nav: false,
    autoplay : true,
    lazyLoad: true,
    autoplayTimeout: 3000,
    loop: false,
    dots: true,
    navText : ['<i class="fas fa-chevron-up"></i>','<i class="fas fa-chevron-down"></i>'],
    responsive: {
      0: {
        items: 1
      },
      600: {
        items: 2
      },
      1000: {
        items: 3
      }
    },
    autoplayHoverPause : true,
    mouseDrag: true
  });
});

/* ===============================================
  SCROLL TOP
============================================= */

jQuery(window).scroll(function () {
  if (jQuery(this).scrollTop() > 100) {
    jQuery('.scroll-up').fadeIn();
  } else {
    jQuery('.scroll-up').fadeOut();
  }
});

jQuery('a[href="#tobottom"]').click(function () {
  jQuery('html, body').animate({scrollTop: 0}, 'slow');
  return false;
});

/*===============================================
 PRELOADER
=============================================== */

jQuery('document').ready(function($){
  setTimeout(function () {
    jQuery(".cssloader").fadeOut("slow");
  },1000);
});

/* ===============================================
  STICKY-HEADER
============================================= */

jQuery(window).scroll(function () {
  var sticky = jQuery('.sticky-header'),
  scroll = jQuery(window).scrollTop();

  if (scroll >= 100) sticky.addClass('fixed-header');
  else sticky.removeClass('fixed-header');
});

/* ===============================================
  TABS
=============================================== */

jQuery(document).ready(function () {
  jQuery( ".tablinks" ).first().addClass( "active" );
  jQuery( ".tabcontent" ).first().addClass( "active" );
});

function pr_services_projects_tab(evt, cityName) {
  var i, tabcontent, tablinks;
  tabcontent = document.getElementsByClassName("tabcontent");
  for (i = 0; i < tabcontent.length; i++) {
    tabcontent[i].style.display = "none";
  }
  tablinks = document.getElementsByClassName("tablinks");
  for (i = 0; i < tablinks.length; i++) {
    tablinks[i].className = tablinks[i].className.replace(" active", "");
  }
  jQuery('#'+ cityName).show()
  evt.currentTarget.className += " active";
}
