<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

<meta http-equiv="Content-Type" content="<?php echo esc_attr(get_bloginfo('html_type')); ?>; charset=<?php echo esc_attr(get_bloginfo('charset')); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.2, user-scalable=yes" />

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php
	if ( function_exists( 'wp_body_open' ) )
	{
		wp_body_open();
	}else{
		do_action('wp_body_open');
	}
?>

<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'pr-services' ); ?></a>

<?php if ( get_theme_mod('pr_services_site_loader', false) == true ) : ?>
	<div class="cssloader">
    	<div class="sh1"></div>
    	<div class="sh2"></div>
    	<h1 class="lt"><?php esc_html_e( 'loading',  'pr-services' ); ?></h1>
    </div>
<?php endif; ?>

<div class="<?php if( get_theme_mod( 'pr_services_sticky_header', false) != '') { ?>sticky-header<?php } else { ?>close-sticky main-menus<?php } ?>">
	<header id="site-navigation">
		<div class="header-inner py-2">
			<div class="container">
				<div class="row">
					<div class="col-xl-5 col-lg-6 col-md-6 col-sm-12 align-self-center contact-box text-md-start">
						<div class="row">
							<div class="col-lg-5 col-md-6 col-sm-6 align-self-center">
								<?php if ( get_theme_mod('pr_services_header_inner_phone_number')) : ?>
									<p class="mb-0 text-inner"><i class="fas fa-phone me-2"></i><a href="tell:<?php echo esc_attr(get_theme_mod('pr_services_header_inner_phone_number'));?>"><?php echo esc_html(get_theme_mod('pr_services_header_inner_phone_number'));?></a></p>
								<?php endif; ?>
							</div>
							<div class="col-lg-6 col-md-6 col-sm-6 align-self-center">
								<?php if ( get_theme_mod('pr_services_header_inner_emial')) : ?>
									<p class="mb-0 text-inner"><i class="fas fa-envelope me-2"></i><a href="mailto:<?php echo esc_attr(get_theme_mod('pr_services_header_inner_emial'));?>"><?php echo esc_html(get_theme_mod('pr_services_header_inner_emial'));?></a></p>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="col-xl-3 col-lg-3 col-md-3 col-sm-6 align-self-center translation-box text-center">
						<?php if ( shortcode_exists('google-translator') ) : ?>
						    <span>
						        <?php echo do_shortcode('[google-translator]'); ?>
						    </span>
						<?php endif; ?>
					</div>
					<div class="col-xl-4 col-lg-3 col-md-3 col-sm-6 align-self-center">
						<?php $pr_services_settings = get_theme_mod( 'pr_services_social_links_settings' ); ?>
						<div class="social-links text-center text-md-end">
							<?php if ( is_array($pr_services_settings) || is_object($pr_services_settings) ){ ?>
							    	<?php foreach( $pr_services_settings as $pr_services_setting ) { ?>
								        <a href="<?php echo esc_url( $pr_services_setting['link_url'] ); ?>">
								            <i class="<?php echo esc_attr( $pr_services_setting['link_text'] ); ?> me-2"></i>
								        </a>
							    	<?php } ?>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="header-outter py-2">
			<div class="container">
				<div class="row">
					<div class="col-lg-2 col-md-4 col-sm-6  align-self-center">
						<div class="logo">
				    		<div class="logo-image">
				    			<?php the_custom_logo(); ?>
					    	</div>
					    	<div class="logo-content">
						    	<?php
						    		if ( get_theme_mod('pr_services_display_header_title', true) == true ) :
							      		echo '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr(get_bloginfo('name')) . '">';
							      			echo esc_html(get_bloginfo('name'));
							      		echo '</a>';
							      	endif;

							      	if ( get_theme_mod('pr_services_display_header_text', false) == true ) :
						      			echo '<span>'. esc_html(get_bloginfo('description')) . '</span>';
						      		endif;
					    		?>
							</div>
						</div>
					</div>					
					<div class="col-lg-10 col-md-8 col-sm-6 align-self-center nav-main-box">
						<div class="row">
							<div class="col-lg-9 col-md-7 col-sm-6 col-2 align-self-center text-start">
								<div class="top-menu-wrapper">
								    <div class="navigation_header">
								        <div class="toggle-nav mobile-menu">
								            <button onclick="pr_services_openNav()">
								                <span class="dashicons dashicons-menu"></span>
								            </button>
								        </div>
								        <div id="mySidenav" class="nav sidenav">
								            <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'pr-services' ); ?>">
								                <?php {
								                    wp_nav_menu(
								                        array(
								                            'theme_location' => 'main-menu',
								                            'container_class' => 'navi clearfix navbar-nav',
								                            'menu_class'     => 'menu clearfix',
								                            'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
								                            'fallback_cb'    => 'wp_page_menu',
								                        )
								                    );
								                } ?>
								            </nav>
								            <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="pr_services_closeNav()">
								                <span class="dashicons dashicons-no"></span>
								            </a>
								        </div>
								    </div>
								</div>
							</div>
							<div class="col-lg-3 col-md-5 col-sm-6 col-10 align-self-center">
								<div class="header-search text-center py-3 py-md-0">
									<form method="get" class="wordpress-post-search" action="<?php echo esc_url(home_url('/')); ?>">
										<label class="screen-reader-text" for="wordpress-post-search-field"><?php esc_html_e('Search for:', 'pr-services'); ?></label>
										<input type="search" id="wordpress-post-search-field" class="search-field" placeholder="<?php echo esc_html('Search Here','pr-services'); ?>" value="<?php echo get_search_query(); ?>" name="s" />
										<button type="submit" value="" class="search-button"><i class="fas fa-search"></i></button>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</header>
</div>