<?php
/**
* Get started notice
*/
add_action( 'wp_ajax_pr_services_dismissed_notice_handler', 'pr_services_ajax_notice_handler' );

function pr_services_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function pr_services_deprecated_hook_admin_notice() {
    // Check if it's been dismissed...
    if ( ! get_option( 'dismissed-get_started', false ) ) {
        $current_screen = get_current_screen();

        // Check screen ID correctly
        if ( 
            $current_screen && 
            $current_screen->id !== 'appearance_page_pr-services-guide-page' &&
            $current_screen->id !== 'appearance_page_prservices-wizard'
        ) {
            $pr_services_comments_theme = wp_get_theme();
            ?>
            <div class="pr-services-notice-wrapper updated notice notice-get-started-class is-dismissible" data-notice="get_started">
                <div class="pr-services-notice">
                    <div class="pr-services-notice-content">
                        <div class="pr-services-notice-heading">
                            <h2>
                                <?php esc_html_e('Thanks For Installing ', 'pr-services'); ?>
                                <?php echo esc_html( $pr_services_comments_theme ); ?>
                                <?php esc_html_e('Theme', 'pr-services'); ?>
                            </h2>
                            <p>
                                <?php
                                /* translators: %s: theme name */
                                printf(
                                    esc_html__("%s is now installed and ready to use. We've provided some links to get you started.", 'pr-services'),
                                    $pr_services_comments_theme
                                );
                                ?>
                            </p>
                        </div>
                        <div class="diplay-flex-btn">
                            <a class="button button-primary" href="<?php echo esc_url( admin_url( 'themes.php?page=pr-services-guide-page' ) ); ?>">
                                <?php echo esc_html__('GET STARTED', 'pr-services'); ?>
                            </a>
                            <a class="button button-primary" target="_blank" href="<?php echo esc_url( PR_SERVICES_BUY_NOW ); ?>">
                                <?php echo esc_html__('GO TO PREMIUM', 'pr-services'); ?>
                            </a>
                            <a class="button button-primary import" href="<?php echo esc_url( admin_url( 'themes.php?page=prservices-wizard' ) ); ?>">
                                <?php echo esc_html__('ONE CLICK DEMO IMPORTER', 'pr-services'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="pr-services-notice-img">
                        <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/notification.png' ); ?>" alt="<?php esc_attr_e('logo', 'pr-services'); ?>">
                    </div>
                </div>
            </div>
            <?php
        }
    }
}
add_action( 'admin_notices', 'pr_services_deprecated_hook_admin_notice' );

add_action( 'admin_menu', 'pr_services_getting_started' );
function pr_services_getting_started() {
	add_theme_page( esc_html__('Get Started', 'pr-services'), esc_html__('Get Started', 'pr-services'), 'edit_theme_options', 'pr-services-guide-page', 'pr_services_test_guide');	
}

function pr_services_admin_enqueue_scripts() {
	wp_enqueue_style( 'pr-services-admin-style', esc_url( get_template_directory_uri() ).'/css/main.css' );
	wp_enqueue_script( 'pr-services-admin-script', get_template_directory_uri() . '/js/pr-services-admin-script.js', array( 'jquery' ), '', true );
    wp_localize_script( 'pr-services-admin-script', 'pr_services_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
}
add_action( 'admin_enqueue_scripts', 'pr_services_admin_enqueue_scripts' );


if ( ! defined( 'PR_SERVICES_DOCS_FREE' ) ) {
define('PR_SERVICES_DOCS_FREE',__('https://demo.misbahwp.com/docs/pr-services-free-docs/','pr-services'));
}
 if ( ! defined( 'PR_SERVICES_DOCS_PRO' ) ) {
define('PR_SERVICES_DOCS_PRO',__('https://demo.misbahwp.com/docs/pr-services-pro-docs/','pr-services'));
}
if ( ! defined( 'PR_SERVICES_BUY_NOW' ) ) {
define('PR_SERVICES_BUY_NOW',__('https://www.misbahwp.com/products/pr-wordpress-theme','pr-services'));
}
if ( ! defined( 'PR_SERVICES_SUPPORT_FREE' ) ) {
define('PR_SERVICES_SUPPORT_FREE',__('https://wordpress.org/support/theme/pr-services','pr-services'));
}
if ( ! defined( 'PR_SERVICES_REVIEW_FREE' ) ) {
define('PR_SERVICES_REVIEW_FREE',__('https://wordpress.org/support/theme/pr-services/reviews/#new-post','pr-services'));
}
if ( ! defined( 'PR_SERVICES_DEMO_PRO' ) ) {
define('PR_SERVICES_DEMO_PRO',__('https://demo.misbahwp.com/pr-services/','pr-services'));
}
if( ! defined( 'PR_SERVICES_THEME_BUNDLE' ) ) {
define('PR_SERVICES_THEME_BUNDLE',__('https://www.misbahwp.com/products/wordpress-bundle','pr-services'));
}

function pr_services_test_guide() { 
	$pr_services_theme = wp_get_theme();?>
	<div class="wrap" id="main-page">
		<div id="lefty">
			<div id="admin_links">
				<a href="<?php echo esc_url( PR_SERVICES_DOCS_FREE ); ?>" target="_blank" class="blue-button-1"><?php esc_html_e( 'Documentation', 'pr-services' ) ?></a>
				<a href="<?php echo esc_url( admin_url('customize.php') ); ?>" id="customizer" target="_blank"><?php esc_html_e( 'Customize', 'pr-services' ); ?> </a>
				<a class="blue-button-1" href="<?php echo esc_url( PR_SERVICES_SUPPORT_FREE ); ?>" target="_blank" class="btn3"><?php esc_html_e( 'Support', 'pr-services' ) ?></a>
				<a class="blue-button-2" href="<?php echo esc_url( PR_SERVICES_REVIEW_FREE ); ?>" target="_blank" class="btn4"><?php esc_html_e( 'Review', 'pr-services' ) ?></a>
			</div>
			<div id="description">
				<h3><?php esc_html_e('Welcome! Thank you for choosing ','pr-services'); ?><?php echo esc_html( $pr_services_theme ); ?>  <span><?php esc_html_e('Version: ', 'pr-services'); ?><?php echo esc_html($pr_services_theme['Version']);?></span></h3>
				<div class="demo-import-box">
					<h4><?php echo esc_html__('Import homepage demo in just one click.','pr-services'); ?></h4>
					<p><?php echo esc_html__('Get started with the wordpress theme installation','pr-services'); ?></p>
					<a class="button button-primary import" href="themes.php?page=prservices-wizard"><?php echo esc_html__('ONE CLICK DEMO IMPORTER','pr-services'); ?></a>
				</div>
				<img class="img_responsive" style="width: 100%;" src="<?php echo esc_url( $pr_services_theme->get_screenshot() ); ?>" />
				<div id="description-insidee">
					<?php
						$pr_services_theme = wp_get_theme();
						echo wp_kses_post( apply_filters( 'misbah_theme_description', esc_html( $pr_services_theme->get( 'Description' ) ) ) );
					?>
				</div>
			</div>
		</div>

		<div id="righty">
			<div class="volleyball-postboxx">
				<h3 class="hndle"><?php esc_html_e( 'Upgrade to Premium', 'pr-services' ); ?></h3>
				<div class="volleyball-insidee">
					<p><?php esc_html_e('Discover upgraded pro features with premium version click to upgrade.','pr-services'); ?></p>
					<div id="admin_pro_links">
						<a class="blue-button-2" href="<?php echo esc_url( PR_SERVICES_BUY_NOW ); ?>" target="_blank"><?php esc_html_e( 'Go Pro', 'pr-services' ); ?></a>
						<a class="blue-button-1" href="<?php echo esc_url( PR_SERVICES_DEMO_PRO ); ?>" target="_blank"><?php esc_html_e( 'Live Demo', 'pr-services' ) ?></a>
						<a class="blue-button-2" href="<?php echo esc_url( PR_SERVICES_DOCS_PRO ); ?>" target="_blank"><?php esc_html_e( 'Pro Docs', 'pr-services' ) ?></a>
					</div>
				</div>

				<h3 class="hndle bundle"><?php esc_html_e( 'Get All Themes', 'pr-services' ); ?></h3>
				<div class="insidee theme-bundle">
					<img width="100%" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/bundle-image.png' ); ?>" alt="<?php esc_attr_e('logo', 'pr-services'); ?>">
					<p class="offer"><?php esc_html_e('Get 100+ Perfect WordPress Theme In A Single Package at just $89."','pr-services'); ?></p>
					<p class="coupon"><?php esc_html_e('Get Our Theme Pack of 100+ WordPress Themes At 15% Off','pr-services'); ?><span class="coupon-code"><?php esc_html_e('"Bundleup15"','pr-services'); ?></span></p>
				<div id="admin_pro_linkss">
					<a class="blue-button-1" href="<?php echo esc_url( PR_SERVICES_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e( 'Buy All Themes - $89', 'pr-services' ) ?></a>
				</div>
				<div class="d-table">
			    <ul class="d-column">
			      <li class="feature"><?php esc_html_e('Features','pr-services'); ?></li>
			      <li class="free"><?php esc_html_e('Pro','pr-services'); ?></li>
			      <li class="plus"><?php esc_html_e('Free','pr-services'); ?></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('24hrs Priority Support','pr-services'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('LearnPress Campatiblity','pr-services'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Kirki Framework','pr-services'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Posttype','pr-services'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('One Click Demo Import','pr-services'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Reordering','pr-services'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Enable / Disable Option','pr-services'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Multiple Sections','pr-services'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Color Pallete','pr-services'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Widgets','pr-services'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Page Templates','pr-services'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Typography','pr-services'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Background Image / Color ','pr-services'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
	  		</div>
			</div>
		</div>
	</div>
<?php } ?>
