<?php
if (isset($_GET['import-demo']) && $_GET['import-demo'] == true) {
    class PRServicesDemoImporter {

        public function pr_services_customizer_primary_menu() {
            // Create Primary Menu
            $pr_services_themename = 'PR Services'; // Define the theme name
            $pr_services_menuname = $pr_services_themename . 'Main Menus';
            $pr_services_bpmenulocation = 'main-menu';
            $pr_services_menu_exists = wp_get_nav_menu_object($pr_services_menuname);

            if (!$pr_services_menu_exists) {
                $pr_services_menu_id = wp_create_nav_menu($pr_services_menuname);

                wp_update_nav_menu_item($pr_services_menu_id, 0, array(
                    'menu-item-title' => __('Home', 'pr-services'),
                    'menu-item-classes' => 'home',
                    'menu-item-url' => home_url('/'),
                    'menu-item-status' => 'publish',
                ));

            wp_update_nav_menu_item($pr_services_menu_id, 0, array(
                'menu-item-title' =>  __('Blogs','pr-services'),
                'menu-item-classes' => 'blog',
                'menu-item-url' => get_permalink(pr_services_get_page_id_by_title('blog')), 
                'menu-item-status' => 'publish'));

            wp_update_nav_menu_item($pr_services_menu_id, 0, array(
                'menu-item-title' =>  __('Pages','pr-services'),
                'menu-item-classes' => 'pages',
                'menu-item-url' => get_permalink(pr_services_get_page_id_by_title('pages')), 
                'menu-item-status' => 'publish'));

            wp_update_nav_menu_item($pr_services_menu_id, 0, array(
                'menu-item-title' =>  __('Shop','pr-services'),
                'menu-item-classes' => 'shop',
                'menu-item-url' => get_permalink(pr_services_get_page_id_by_title('shop')), 
                'menu-item-status' => 'publish'));

            wp_update_nav_menu_item($pr_services_menu_id, 0, array(
                'menu-item-title' =>  __('Gallery','pr-services'),
                'menu-item-classes' => 'gallery',
                'menu-item-url' => get_permalink(pr_services_get_page_id_by_title('gallery')), 
                'menu-item-status' => 'publish'));

                if (!has_nav_menu($pr_services_bpmenulocation)) {
                    $locations = get_theme_mod('nav_menu_locations');
                    $locations[$pr_services_bpmenulocation] = $pr_services_menu_id;
                    set_theme_mod('nav_menu_locations', $locations);
                }
            }
        }

        public function setup_widgets() {

        $pr_services_home_id='';
        $pr_services_home_content = '';
        $pr_services_home_title = 'Home';
        $pr_services_home = array(
            'post_type' => 'page',
            'post_title' => $pr_services_home_title,
            'post_content' => $pr_services_home_content,
            'post_status' => 'publish',
            'post_author' => 1,
            'post_slug' => 'home'
        );
        $pr_services_home_id = wp_insert_post($pr_services_home);

        add_post_meta( $pr_services_home_id, '_wp_page_template', 'frontpage.php' );

        update_option( 'page_on_front', $pr_services_home_id );
        update_option( 'show_on_front', 'page' );

                        // Create a Posts Page
            $pr_services_blog_title = 'All jobs';
            $pr_services_blog_check = pr_services_get_page_id_by_title($pr_services_blog_title);

            if ($pr_services_blog_check == 1) {
                $pr_services_blog = array(
                    'post_type' => 'page',
                    'post_title' => $pr_services_blog_title,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_name' => 'jobs',
                    'post_content' => '"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."',
                );
                $pr_services_blog_id = wp_insert_post($pr_services_blog);

                if (!is_wp_error($pr_services_blog_id)) {
                    // update_option('page_for_posts', $pr_services_blog_id);
                }
            }

                        // Create a Posts Page
            $pr_services_blog_title = 'Pages';
            $pr_services_blog_check = pr_services_get_page_id_by_title($pr_services_blog_title);

            if ($pr_services_blog_check  == 1) {
                $pr_services_blog = array(
                    'post_type' => 'page',
                    'post_title' => $pr_services_blog_title,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_name' => 'pages',
                    'post_content' => '"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."',
                );
                $pr_services_blog_id = wp_insert_post($pr_services_blog);

                if (!is_wp_error($pr_services_blog_id)) {
                    // update_option('page_for_posts', $pr_services_blog_id);
                }
            }

                         // Create a Posts Page
            $pr_services_blog_title = 'Shop';
            $pr_services_blog_check = pr_services_get_page_id_by_title($pr_services_blog_title);

            if ($pr_services_blog_check  == 1) {
                $pr_services_blog = array(
                    'post_type' => 'page',
                    'post_title' => $pr_services_blog_title,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_name' => 'pricing',
                    'post_content' => '"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."',
                );
                $pr_services_blog_id = wp_insert_post($pr_services_blog);

                if (!is_wp_error($pr_services_blog_id)) {
                    // update_option('page_for_posts', $pr_services_blog_id);
                }
            }

             // Create a Posts Page
            $pr_services_blog_title = 'Blogs';
            $pr_services_blog_check = pr_services_get_page_id_by_title($pr_services_blog_title);

            if ($pr_services_blog_check  == 1) {
                $pr_services_blog = array(
                    'post_type' => 'page',
                    'post_title' => $pr_services_blog_title,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_name' => 'blogs',
                    'post_content' => '"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."',
                );
                $pr_services_blog_id = wp_insert_post($pr_services_blog);

                if (!is_wp_error($pr_services_blog_id)) {
                    // update_option('page_for_posts', $pr_services_blog_id);
                }
            }

                         // Create a Posts Page
            $pr_services_blog_title = 'Gallery';
            $pr_services_blog_check = pr_services_get_page_id_by_title($pr_services_blog_title);

            if ($pr_services_blog_check  == 1) {
                $pr_services_blog = array(
                    'post_type' => 'page',
                    'post_title' => $pr_services_blog_title,
                    'post_status' => 'publish',
                    'post_author' => 1,
                    'post_name' => 'contact',
                    'post_content' => '"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."',
                );
                $pr_services_blog_id = wp_insert_post($pr_services_blog);

                if (!is_wp_error($pr_services_blog_id)) {
                    // update_option('page_for_posts', $pr_services_blog_id);
                }
            }

		//-----Header -----//

        set_theme_mod( 'pr_services_header_inner_phone_number', '(123) 4567890 ' );
        set_theme_mod( 'pr_services_header_inner_emial', 'support@example.com ' );

        set_theme_mod('pr_services_social_links_settings', array(
            array(
                "link_text" => "fab fa-facebook-f",
                "link_url" => "#"
            ),
            array(
                "link_text" => "fab fa-twitter-square",
                "link_url" => "#"
            ),
            array(
                "link_text" => "fab fa-linkedin",
                "link_url" => "#"
            ),
            array(
                "link_text" => "fab fa-instagram",
                "link_url" => "#"
            ),
            array(
                "link_text" => "fab fa-pinterest-p",
                "link_url" => "#"
            )
        ));

		

		//-----Slider-----//

		set_theme_mod( 'pr_services_slider_box_enable', true);

        set_theme_mod( 'pr_services_slider_counter', '3' );

        for($i=1; $i<=3; $i++) {
            set_theme_mod( 'pr_services_slider_sub_heading'.$i, 'WELCOME TO' );
            set_theme_mod( 'pr_services_slider_main_heading'.$i, 'PERFECT PR SOLUTION' );
            set_theme_mod( 'pr_services_slider_image' . $i, get_template_directory_uri() . '/assets/images/slider' . $i . '.png' );
            set_theme_mod( 'pr_services_slider_button_url'.$i, '#' );
            set_theme_mod( 'pr_services_slider_button_text'.$i, 'Read More' );
            set_theme_mod( 'pr_services_slider_rating_heading'.$i, 'TrustScore' );
            set_theme_mod( 'pr_services_slider_rating_total_number'.$i, '234' );
            set_theme_mod( 'pr_services_slider_rating_score'.$i, '4.9 out of 5' );
        }

		//-----Categories-----//
		set_theme_mod( 'pr_services_projects_section_enable', true);

        set_theme_mod( 'pr_services_projects_heading', 'Latest Blog Post');
        set_theme_mod( 'pr_services_projects_number', '3');
        set_theme_mod( 'pr_services_about_button_text', 'View More');
        set_theme_mod( 'pr_services_about_button_url', '#');

        $title_theme =   array('Show ALL','Public Relations','Digital Marketing','Media Relations','Branding');

        set_theme_mod( 'pr_services_projects_number', '5' );
        $pr_services_latest_post_category = wp_create_category('Slider Post');
        set_theme_mod( 'pr_services_blog_slide_category', 'Slider Post' ); 

        for($i=1; $i<=5; $i++) {

            set_theme_mod( 'pr_services_projects_text'.$i, $title_theme[ $i - 1 ]);

            $title =   'Lorem proiegeteu molesti';
            $content = 'Boso Over-Ear Headphone Wifi, Voice Assistant, Low Latency Game Mde';

            // Create post object
            $pr_services_my_post = array(
                'post_title'    => wp_strip_all_tags( $title ),
                'post_content'  => $content,
                'post_status'   => 'publish',
                'post_type'     => 'post',
                'post_category' => array($pr_services_latest_post_category) 
            );

            // Insert the post into the database
            $pr_services_post_id = wp_insert_post( $pr_services_my_post );

            $pr_services_image_url = get_template_directory_uri().'/assets/images/post' . $i . '.png';

            $pr_services_image_name= 'post.png';
            $pr_services_upload_dir       = wp_upload_dir(); 
            // Set upload folder
            $pr_services_image_data       = file_get_contents($pr_services_image_url); 
             
            // Get image data
            $pr_services_unique_file_name = wp_unique_filename( $pr_services_upload_dir['path'], $pr_services_image_name ); 
            // Generate unique name
            $filename= basename( $pr_services_unique_file_name ); 
            // Create image file name
            // Check folder permission and define file location
            if( wp_mkdir_p( $pr_services_upload_dir['path'] ) ) {
                $file = $pr_services_upload_dir['path'] . '/' . $filename;
            } else {
                $file = $pr_services_upload_dir['basedir'] . '/' . $filename;
            }

                        if ( ! function_exists( 'WP_Filesystem' ) ) {
                    require_once( ABSPATH . 'wp-admin/includes/file.php' );
                }
                
                WP_Filesystem();
                global $wp_filesystem;
                
                if ( ! $wp_filesystem->put_contents( $file, $pr_services_image_data, FS_CHMOD_FILE ) ) {
                    wp_die( 'Error saving file!' );
                }

            $pr_services_wp_filetype = wp_check_filetype( $filename, null );
            $pr_services_attachment = array(
                'post_mime_type' => $pr_services_wp_filetype['type'],
                'post_title'     => sanitize_file_name( $filename ),
                'post_content'   => '',
                'post_type'     => 'post',
                'post_status'    => 'inherit'
            );
            $pr_services_attach_id = wp_insert_attachment( $pr_services_attachment, $file, $pr_services_post_id );
            require_once(ABSPATH . 'wp-admin/includes/image.php');
            $pr_services_attach_data = wp_generate_attachment_metadata( $pr_services_attach_id, $file );
                wp_update_attachment_metadata( $pr_services_attach_id, $pr_services_attach_data );
                set_post_thumbnail( $pr_services_post_id, $pr_services_attach_id );
        }
        }
    }
	// Instantiate the class and call its methods
    $demo_importer = new PRServicesDemoImporter();
    $demo_importer->setup_widgets();
    $demo_importer->pr_services_customizer_primary_menu();
	}
?>