<?php

if ( ! defined( 'PR_SERVICES_BUY_NOW_1' ) ) {
define('PR_SERVICES_BUY_NOW_1',__('https://www.misbahwp.com/products/pr-wordpress-theme','pr-services'));
}

if ( class_exists("Kirki")){
	// LOGO

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'pr_services_logo_resizer',
		'label'       => esc_html__( 'Adjust Your Logo Size ', 'pr-services' ),
		'section'     => 'title_tagline',
		'choices'     => [
			'min'  => 10,
			'max'  => 300,
			'step' => 10,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_enable_logo_text',
		'section'     => 'title_tagline',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Site Title and Tagline', 'pr-services' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'pr_services_display_header_title',
		'label'       => esc_html__( 'Site Title Enable / Disable Button', 'pr-services' ),
		'section'     => 'title_tagline',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'pr-services' ),
			'off' => esc_html__( 'Disable', 'pr-services' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'pr_services_display_header_text',
		'label'       => esc_html__( 'Tagline Enable / Disable Button', 'pr-services' ),
		'section'     => 'title_tagline',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'pr-services' ),
			'off' => esc_html__( 'Disable', 'pr-services' ),
		],
	] );

	// FONT STYLE TYPOGRAPHY

	Kirki::add_panel( 'pr_services_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Typography', 'pr-services' ),
	) );

	Kirki::add_section( 'pr_services_font_style_section', array(
		'title'      => esc_html__( 'Typography Option',  'pr-services' ),
		'priority'   => 2,
		'capability' => 'edit_theme_options',
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'pr-services' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( PR_SERVICES_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'pr-services' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'pr_services_font_style_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'pr-services' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_all_headings_typography',
		'section'     => 'pr_services_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading Of All Sections',  'pr-services' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'pr_services_all_headings_typography',
		'label'       => esc_html__( 'Heading Typography',  'pr-services' ),
		'description' => esc_html__( 'Select the typography options for your heading.',  'pr-services' ),
		'section'     => 'pr_services_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'h1','h2','h3','h4','h5','h6', ),
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_body_content_typography',
		'section'     => 'pr_services_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Body Content',  'pr-services' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'pr_services_body_content_typography',
		'label'       => esc_html__( 'Content Typography',  'pr-services' ),
		'description' => esc_html__( 'Select the typography options for your content.',  'pr-services' ),
		'section'     => 'pr_services_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'body', ),
			),
		),
	) );

		// PANEL
	Kirki::add_panel( 'pr_services_panel_id_5', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Animations', 'pr-services' ),
	) );

	// ANIMATION SECTION
	Kirki::add_section( 'pr_services_section_animation', array(
	    'title'          => esc_html__( 'Animations', 'pr-services' ),
	    'priority'       => 2,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'pr-services' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( PR_SERVICES_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'pr-services' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'pr_services_section_animation',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'pr-services' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'pr_services_animation_enabled',
		'label'       => esc_html__( 'Turn To Show Animation', 'pr-services' ),
		'section'     => 'pr_services_section_animation',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'pr-services' ),
			'off' => esc_html__( 'Disable', 'pr-services' ),
		],
	] );

	// PANEL
	Kirki::add_panel( 'pr_services_panel_id_2', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Dark Mode', 'pr-services' ),
	) );

	// DARK MODE SECTION
	Kirki::add_section( 'pr_services_section_dark_mode', array(
	    'title'          => esc_html__( 'Dark Mode', 'pr-services' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'pr-services' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( PR_SERVICES_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'pr-services' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'pr_services_section_dark_mode',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'pr-services' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'pr_services_dark_colors',
	    'section'     => 'pr_services_section_dark_mode',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Dark Appearance', 'pr-services' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'pr_services_is_dark_mode_enabled',
		'label'       => esc_html__( 'Turn To Dark Mode', 'pr-services' ),
		'section'     => 'pr_services_section_dark_mode',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'pr-services' ),
			'off' => esc_html__( 'Disable', 'pr-services' ),
		],
	] );

	// PANEL
	Kirki::add_panel( 'pr_services_panel_id_3', array(
	    'priority'    => 10,
	    'title'       => esc_html__( '404 Settings', 'pr-services' ),
	) );

	// 404 SECTION
	Kirki::add_section( 'pr_services_section_404', array(
	    'title'          => esc_html__( '404 Settings', 'pr-services' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'pr-services' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( PR_SERVICES_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'pr-services' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'pr_services_section_404',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'pr-services' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'pr_services_not_found_heading',
	    'section'     => 'pr_services_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Not Found Heading', 'pr-services' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'pr_services_404_page_title',
		'section'  => 'pr_services_section_404',
		'default'  => esc_html__('404 Not Found', 'pr-services'),
		'priority' => 10,
	] );

		Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'pr_services_not_found_text',
	    'section'     => 'pr_services_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Not Found Content', 'pr-services' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'pr_services_404_page_content',
		'section'  => 'pr_services_section_404',
		'default'  => esc_html__('Sorry, no posts matched your criteria.', 'pr-services'),
		'priority' => 10,
	] );
	// PANEL

	Kirki::add_panel( 'pr_services_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Options', 'pr-services' ),
	) );

	//COLOR SECTION

	Kirki::add_section( 'pr_services_section_color', array(
	    'title'          => esc_html__( 'Global Color', 'pr-services' ),
	    'panel'          => 'pr_services_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'pr-services' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( PR_SERVICES_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'pr-services' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'pr_services_section_color',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'pr-services' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_global_colors',
		'section'     => 'pr_services_section_color',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Here you can change your theme color on one click.', 'pr-services' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'pr_services_first_color',
		'label'       => __( 'Choose Your First Color', 'pr-services' ),
		'section'     => 'pr_services_section_color',
		'default'     => '#FE7A71',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'pr_services_second_color',
		'label'       => __( 'Choose Your Second Color', 'pr-services' ),
		'section'     => 'pr_services_section_color',
		'default'     => '#FFD233',
	] );

	// Additional Settings

	Kirki::add_section( 'pr_services_additional_settings', array(
	    'title'          => esc_html__( 'Additional Settings', 'pr-services' ),
	    'panel'          => 'pr_services_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'pr-services' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( PR_SERVICES_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'pr-services' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'pr_services_additional_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'pr-services' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'pr_services_scroll_enable_setting',
		'label'       => esc_html__( 'Here you can enable or disable your scroller.', 'pr-services' ),
		'section'     => 'pr_services_additional_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	new \Kirki\Field\Radio_Buttonset(
	[
		'settings'    => 'pr_services_scroll_top_position',
		'label'       => esc_html__( 'Alignment for Scroll To Top', 'pr-services' ),
		'section'     => 'pr_services_additional_settings',
		'default'     => 'Right',
		'priority'    => 10,
		'choices'     => [
			'Left'   => esc_html__( 'Left', 'pr-services' ),
			'Center' => esc_html__( 'Center', 'pr-services' ),
			'Right'  => esc_html__( 'Right', 'pr-services' ),
		],
	]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'dashicons',
		'settings' => 'pr_services_scroll_top_icon',
		'label'    => esc_html__( 'Select Appropriate Scroll Top Icon', 'pr-services' ),
		'section'  => 'pr_services_additional_settings',
		'default'  => 'dashicons dashicons-arrow-up-alt',
		'priority' => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'menu_text_transform_pr_services',
		'label'       => esc_html__( 'Menus Text Transform', 'pr-services' ),
		'section'     => 'pr_services_additional_settings',
		'default'     => 'CAPITALISE',
		'placeholder' => esc_html__( 'Choose an option', 'pr-services' ),
		'choices'     => [
			'CAPITALISE' => esc_html__( 'CAPITALISE', 'pr-services' ),
			'UPPERCASE' => esc_html__( 'UPPERCASE', 'pr-services' ),
			'LOWERCASE' => esc_html__( 'LOWERCASE', 'pr-services' ),

		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'pr_services_menu_zoom',
		'label'       => esc_html__( 'Menu Transition', 'pr-services' ),
		'section'     => 'pr_services_additional_settings',
		'default' => 'Zoom Out',
		'placeholder' => esc_html__( 'Choose an option', 'pr-services' ),
		'choices'     => [
			'Zoomout' => __('Zoom Out','pr-services'),
            'Zoominn' => __('Zoom Inn','pr-services'),
            
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'pr_services_container_width',
		'label'       => esc_html__( 'Theme Container Width', 'pr-services' ),
		'section'     => 'pr_services_additional_settings',
		'default'     => 100,
		'choices'     => [
			'min'  => 50,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'pr_services_site_loader',
		'label'       => esc_html__( 'Here you can enable or disable your Site Loader.', 'pr-services' ),
		'section'     => 'pr_services_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'pr_services_sticky_header',
		'label'       => esc_html__( 'Here you can enable or disable your Sticky Header.', 'pr-services' ),
		'section'     => 'pr_services_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'pr_services_page_layout',
		'label'       => esc_html__( 'Page Layout Setting', 'pr-services' ),
		'section'     => 'pr_services_additional_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'pr-services' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','pr-services'),
            'Right Sidebar' => __('Right Sidebar','pr-services'),
            'One Column' => __('One Column','pr-services')
		],
	] );

	if ( class_exists("woocommerce")){

	// Woocommerce Settings

	Kirki::add_section( 'pr_services_woocommerce_settings', array(
		'title'          => esc_html__( 'Woocommerce Settings', 'pr-services' ),
		'panel'          => 'pr_services_panel_id',
		'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'pr-services' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( PR_SERVICES_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'pr-services' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'pr_services_woocommerce_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'pr-services' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'pr_services_shop_sidebar',
		'label'       => esc_html__( 'Here you can enable or disable shop page sidebar.', 'pr-services' ),
		'section'     => 'pr_services_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'pr_services_product_sidebar',
		'label'       => esc_html__( 'Here you can enable or disable product page sidebar.', 'pr-services' ),
		'section'     => 'pr_services_woocommerce_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'pr_services_related_product_setting',
		'label'       => esc_html__( 'Here you can enable or disable your related products.', 'pr-services' ),
		'section'     => 'pr_services_woocommerce_settings',
		'default'     => true,
		'priority'    => 10,
	] );

	new \Kirki\Field\Number(
		[
			'settings' => 'pr_services_per_columns',
			'label'    => esc_html__( 'Product Per Row', 'pr-services' ),
			'section'  => 'pr_services_woocommerce_settings',
			'default'  => 3,
			'choices'  => [
				'min'  => 1,
				'max'  => 4,
				'step' => 1,
			],
		]
	);

	new \Kirki\Field\Number(
		[
			'settings' => 'pr_services_product_per_page',
			'label'    => esc_html__( 'Product Per Page', 'pr-services' ),
			'section'  => 'pr_services_woocommerce_settings',
			'default'  => 9,
			'choices'  => [
				'min'  => 1,
				'max'  => 15,
				'step' => 1,
			],
		]
	);

	new \Kirki\Field\Number(
	[
		'settings' => 'custom_related_products_number_per_row',
		'label'    => esc_html__( 'Related Product Per Column', 'pr-services' ),
		'section'  => 'pr_services_woocommerce_settings',
		'default'  => 3,
		'choices'  => [
			'min'  => 1,
			'max'  => 4,
			'step' => 1,
		],
	]
	);

	new \Kirki\Field\Number(
	[
		'settings' => 'custom_related_products_number',
		'label'    => esc_html__( 'Related Product Per Page', 'pr-services' ),
		'section'  => 'pr_services_woocommerce_settings',
		'default'  => 3,
		'choices'  => [
			'min'  => 1,
			'max'  => 10,
			'step' => 1,
		],
	]
	);

	new \Kirki\Field\Select(
	[
		'settings'    => 'pr_services_shop_page_layout',
		'label'       => esc_html__( 'Shop Page Layout Setting', 'pr-services' ),
		'section'     => 'pr_services_woocommerce_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'pr-services' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','pr-services'),
            'Right Sidebar' => __('Right Sidebar','pr-services')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'pr_services_product_page_layout',
		'label'       => esc_html__( 'Product Page Layout Setting', 'pr-services' ),
		'section'     => 'pr_services_woocommerce_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'pr-services' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','pr-services'),
            'Right Sidebar' => __('Right Sidebar','pr-services')
		],
	] );

	new \Kirki\Field\Radio_Buttonset( [
		'settings'    => 'pr_services_woocommerce_pagination_position',
		'label'       => esc_html__( 'Woocommerce Pagination Alignment', 'pr-services' ),
		'section'     => 'pr_services_woocommerce_settings',
		'default'     => 'Center',
		'priority'    => 10,
		'choices'     => [
			'Left'   => esc_html__( 'Left', 'pr-services' ),
			'Center' => esc_html__( 'Center', 'pr-services' ),
			'Right'  => esc_html__( 'Right', 'pr-services' ),
		],
	]
	);

}

	// POST SECTION

	Kirki::add_section( 'pr_services_section_post', array(
	    'title'          => esc_html__( 'Post Settings', 'pr-services' ),
	    'panel'          => 'pr_services_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'pr-services' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( PR_SERVICES_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'pr-services' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'pr_services_section_post',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'pr-services' ) . '</div>',
	] );

	new \Kirki\Field\Sortable(
	[
		'settings' => 'pr_services_archive_element_sortable',
		'label'    => __( 'Archive Post Page Element Reordering', 'pr-services' ),
		'description'    => esc_html__( 'This setting is not favorable with post format.', 'pr-services' ),
		'section'  => 'pr_services_section_post',
		'default'  => [ 'option1', 'option2', 'option3', 'option4', 'option5' ],
		'choices'  => [
			'option1' => esc_html__( 'Post Image', 'pr-services' ),
			'option2' => esc_html__( 'Post Meta', 'pr-services' ),
			'option3' => esc_html__( 'Post Title', 'pr-services' ),
			'option4' => esc_html__( 'Post Content', 'pr-services' ),
			'option5' => esc_html__( 'Post Button', 'pr-services' ),
		],
	]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'pr_services_post_excerpt_number',
		'label'       => esc_html__( 'Post Content Range', 'pr-services' ),
		'section'     => 'pr_services_section_post',
		'default'     => 15,
		'choices'     => [
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'pr_services_pagination_setting',
		'label'       => esc_html__( 'Here you can enable or disable your Pagination.', 'pr-services' ),
		'section'     => 'pr_services_section_post',
		'default'     => true,
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'pr_services_archive_sidebar_layout',
		'label'       => esc_html__( 'Archive Post Sidebar Layout Setting', 'pr-services' ),
		'section'     => 'pr_services_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'pr-services' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','pr-services'),
            'Right Sidebar' => __('Right Sidebar','pr-services'),
            'Three Column' => __('Three Column','pr-services'),
            'Four Column' => __('Four Column','pr-services'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','pr-services'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','pr-services'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','pr-services')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'pr_services_single_post_sidebar_layout',
		'label'       => esc_html__( 'Single Post Sidebar Layout Setting', 'pr-services' ),
		'section'     => 'pr_services_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'pr-services' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','pr-services'),
            'Right Sidebar' => __('Right Sidebar','pr-services'),
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'pr_services_search_sidebar_layout',
		'label'       => esc_html__( 'Search Page Sidebar Layout Setting', 'pr-services' ),
		'section'     => 'pr_services_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'pr-services' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','pr-services'),
            'Right Sidebar' => __('Right Sidebar','pr-services'),
            'Three Column' => __('Three Column','pr-services'),
            'Four Column' => __('Four Column','pr-services'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','pr-services'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','pr-services'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','pr-services')
		],
	] );

	// Breadcrumb
	Kirki::add_section( 'pr_services_bradcrumb', array(
	    'title'          => esc_html__( 'Breadcrumb Settings', 'pr-services' ),
	    'panel'          => 'pr_services_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'pr-services' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( PR_SERVICES_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'pr-services' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'pr_services_bradcrumb',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'pr-services' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_enable_breadcrumb_heading',
		'section'     => 'pr_services_bradcrumb',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Single Page Breadcrumb', 'pr-services' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'pr_services_breadcrumb_enable',
		'label'       => esc_html__( 'Breadcrumb Enable / Disable', 'pr-services' ),
		'section'     => 'pr_services_bradcrumb',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'pr-services' ),
			'off' => esc_html__( 'Disable', 'pr-services' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'default'     => '/',
        'settings' => 'pr_services_breadcrumb_separator' ,
        'label'    => esc_html__( 'Breadcrumb Separator',  'pr-services' ),
        'section'  => 'pr_services_bradcrumb',
    ] );

	// HEADER SECTION

	Kirki::add_section( 'pr_services_header_section', array(
        'title'          => esc_html__( 'Header Settings', 'pr-services' ),
        'panel'          => 'pr_services_panel_id',
        'priority'       => 160,
    ) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'pr-services' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( PR_SERVICES_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'pr-services' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'pr_services_header_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'pr-services' ) . '</div>',
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_header_inner_emial_heading',
		'section'     => 'pr_services_header_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Header Email',  'pr-services' ) . '</h3>',
	] );

    Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'settings' => 'pr_services_header_inner_emial' ,
        'section'  => 'pr_services_header_section',
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_header_inner_phone_number_heading',
		'section'     => 'pr_services_header_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Header Phone Number',  'pr-services' ) . '</h3>',
	] );

    Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'settings' => 'pr_services_header_inner_phone_number' ,
        'section'  => 'pr_services_header_section',
    ] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_enable_socail_link',
		'section'     => 'pr_services_header_section',
		'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'pr-services' ) . '</h3>',
		'priority'    => 11,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'pr_services_header_section',
		'priority'    => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Social Icon', 'pr-services' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'pr-services' ),
		'settings'     => 'pr_services_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'pr-services' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'pr-services' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'pr-services' ),
				'description' => esc_html__( 'Add the social icon url here.', 'pr-services' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );

	// SLIDER SECTION

	Kirki::add_section( 'pr_services_slider_section', array(
	    'title'          => esc_html__( 'Slider Settings', 'pr-services' ),
	    'panel'          => 'pr_services_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'pr-services' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( PR_SERVICES_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'pr-services' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'pr_services_slider_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'pr-services' ) . '</div>',
	] );

	 Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_enable_heading1',
		'section'     => 'pr_services_slider_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Slider',  'pr-services' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'pr_services_slider_box_enable',
		'label'       => esc_html__( 'Section Enable / Disable',  'pr-services' ),
		'section'     => 'pr_services_slider_section',
		'default'     => 'true',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable',  'pr-services' ),
			'off' => esc_html__( 'Disable',  'pr-services' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_slider_heading',
		'section'     => 'pr_services_slider_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Slider Section ',  'pr-services' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'number',
        'settings'    => 'pr_services_slider_counter',
        'label'       => esc_html__( 'Slider Counter Section',  'pr-services' ),
        'section'     => 'pr_services_slider_section',
        'default'     => '0',
        'choices'     => [
            'min'  => 1,
            'max'  => 5,
            'step' => 1,
        ],
    ] );

    $pr_services_slider_image = get_theme_mod('pr_services_slider_counter','');
        for ( $pr_services_i = 1; $pr_services_i <= $pr_services_slider_image; $pr_services_i++ ) :

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'image',
        'settings'    => 'pr_services_slider_image'.$pr_services_i,
        'label'       => esc_html__( 'Slider Image ', 'pr-services' ).$pr_services_i,
        'description' => esc_html__( 'Image Dimension (1400 x 650)', 'pr-services' ),
        'section'     => 'pr_services_slider_section',
        'default'     => '',
    ] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'text',
        'settings'    => 'pr_services_slider_sub_heading' .$pr_services_i,
        'label'       => esc_html__( 'Sub Heading ', 'pr-services' ).$pr_services_i,
        'section'     => 'pr_services_slider_section',
        'default'     => '',
    ] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'text',
        'settings'    => 'pr_services_slider_main_heading' .$pr_services_i,
        'label'       => esc_html__( 'Main Heading ', 'pr-services' ).$pr_services_i,
        'section'     => 'pr_services_slider_section',
        'default'     => '',
    ] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'text',
        'settings'    => 'pr_services_slider_button_text' .$pr_services_i,
        'label'       => esc_html__( 'Button Text ', 'pr-services' ).$pr_services_i,
        'section'     => 'pr_services_slider_section',
        'default'     => '',
    ] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'link',
        'settings'    => 'pr_services_slider_button_url' .$pr_services_i,
        'label'       => esc_html__( 'Button Url ', 'pr-services' ).$pr_services_i,
        'section'     => 'pr_services_slider_section',
        'default'     => '',
    ] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'text',
        'settings'    => 'pr_services_slider_rating_heading' .$pr_services_i,
        'label'       => esc_html__( 'Rating Heading', 'pr-services' ).$pr_services_i,
        'section'     => 'pr_services_slider_section',
        'default'     => '',
    ] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'text',
        'settings'    => 'pr_services_slider_rating_total_number' .$pr_services_i,
        'label'       => esc_html__( 'Rating Total Number ', 'pr-services' ).$pr_services_i,
        'section'     => 'pr_services_slider_section',
        'default'     => '',
    ] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'text',
        'settings'    => 'pr_services_slider_rating_score' .$pr_services_i,
        'label'       => esc_html__( 'Rating Score ', 'pr-services' ).$pr_services_i,
        'section'     => 'pr_services_slider_section',
        'default'     => '',
    ] );

	endfor;

	//PROJECTS SECTION

	Kirki::add_section( 'pr_services_project_section', array(
	    'title'          => esc_html__( 'Our Project Settings', 'pr-services' ),
	    'panel'          => 'pr_services_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'pr-services' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( PR_SERVICES_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'pr-services' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'pr_services_project_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'pr-services' ) . '</div>',
	    'priority'    => 1,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_enable_heading',
		'section'     => 'pr_services_project_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Our Project',  'pr-services' ) . '</h3>',
		'priority'    => 1,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'pr_services_projects_section_enable',
		'label'       => esc_html__( 'Section Enable / Disable',  'pr-services' ),
		'section'     => 'pr_services_project_section',
		'default'     => true,
		'priority'    => 2,
		'choices'     => [
			'on'  => esc_html__( 'Enable',  'pr-services' ),
			'off' => esc_html__( 'Disable',  'pr-services' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_projects_text_heading',
		'section'     => 'pr_services_project_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Project', 'pr-services' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'       => esc_html__( 'Heading', 'pr-services' ),
		'settings' => 'pr_services_projects_heading',
		'section'  => 'pr_services_project_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'settings'    => 'pr_services_projects_number',
		'label'       => esc_html__( 'Number of tabs to show', 'pr-services' ),
		'section'     => 'pr_services_project_section',
		'default'     => '',
		'choices'     => [
			'min'  => 0,
			'max'  => 8,
			'step' => 1,
		],
	] );

	$featured_post = get_theme_mod('pr_services_projects_number','');
    	for ( $j = 1; $j <= $featured_post; $j++ ) :

    	Kirki::add_field( 'theme_config_id', [
	        'type'        => 'text',
	        'settings'    => 'pr_services_projects_text' .$j,
	        'label'       => esc_html__( 'Tab Text ', 'pr-services' ).$j,
	        'section'     => 'pr_services_project_section',
	        'default'     => '',
	    ] );

		Kirki::add_field( 'theme_config_id', [
			'type'        => 'select',
			'settings'    => 'pr_services_projects_category'.$j,
			'label'       => esc_html__( 'Select the category to show project ', 'pr-services' ).$j,
			'section'     => 'pr_services_project_section',
			'default'     => '',
			'placeholder' => esc_html__( 'Select an category...', 'pr-services' ),
			'priority'    => 10,
			'choices'     => pr_services_get_categories_select(),
		] );

	endfor;

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'text',
        'settings'    => 'pr_services_about_button_text',
        'label'       => esc_html__( 'Button Text ', 'pr-services') ,
        'section'     => 'pr_services_project_section',
        'default'     => '',
    ] );

    Kirki::add_field( 'theme_config_id', [
        'type'        => 'link',
        'settings'    => 'pr_services_about_button_url',
        'label'       => esc_html__( 'Button Url ', 'pr-services' ) ,
        'section'     => 'pr_services_project_section',
        'default'     => '',
    ] );

	// FOOTER SECTION

	Kirki::add_section( 'pr_services_footer_section', array(
        'title'          => esc_html__( 'Footer Settings', 'pr-services' ),
        'description'    => esc_html__( 'Here you can change copyright text', 'pr-services' ),
        'panel'          => 'pr_services_panel_id',
        'priority'       => 160,
    ) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'pr-services' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( PR_SERVICES_BUY_NOW_1 ) . '">' . __( 'GO TO PREMIUM', 'pr-services' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'pr_services_footer_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'pr-services' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_footer_enable_heading',
		'section'     => 'pr_services_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Footer Link', 'pr-services' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'pr_services_copyright_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'pr-services' ),
		'section'     => 'pr_services_footer_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'pr-services' ),
			'off' => esc_html__( 'Disable', 'pr-services' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_footer_text_heading',
		'section'     => 'pr_services_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Text', 'pr-services' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'pr_services_footer_text',
		'section'  => 'pr_services_footer_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'pr_services_footer_text_heading_2',
	'section'     => 'pr_services_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Alignment', 'pr-services' ) . '</h3>',
	'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'pr_services_copyright_text_alignment',
		'label'       => esc_html__( 'Copyright text Alignment', 'pr-services' ),
		'section'     => 'pr_services_footer_section',
		'default'     => 'LEFT-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'pr-services' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'pr-services' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'pr-services' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'pr-services' ),

		],
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'pr_services_footer_text_heading_1',
	'section'     => 'pr_services_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Background Color', 'pr-services' ) . '</h3>',
	'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'pr_services_copyright_bg',
		'label'       => __( 'Choose Your Copyright Background Color', 'pr-services' ),
		'section'     => 'pr_services_footer_section',
		'default'     => '#000000',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'pr_services_enable_footer_socail_link',
		'section'     => 'pr_services_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'pr-services' ) . '</h3>',
		'priority'    => 11,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'pr_services_footer_section',
		'priority'    => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Footer Social Icon', 'pr-services' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'pr-services' ),
		'settings'     => 'pr_services_footer_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'pr-services' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'pr-services' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'pr-services' ),
				'description' => esc_html__( 'Add the social icon url here.', 'pr-services' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );
}