<?php
get_header();
?>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<div <?php post_class() ?> id="post-<?php the_ID(); ?>">
<?php if (!empty($post->post_title)): ?>
	 <h3 class="storytitle"><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></h3>
<?php endif; ?>
	<div class="meta">Posted by <?php the_author_posts_link(); ?> on <?php the_time('F j, Y'); ?> at <?php the_time() ?>
<?php if ($post->post_type == 'post'): ?>
 in <?php the_category(', ', 'multiple'); ?>
<?php endif; ?>
<?php if (empty($post->post_title)): ?>
 - <a href="<?php the_permalink() ?>" rel="bookmark">Permalink</a>
<?php endif; ?>

<?php if ($post->post_type == 'post'): ?>
<div class="tags"><?php echo get_the_tag_list('Tags: ',', ',''); ?></div>
<?php endif; ?>
</div>

	<div class="storycontent">
		<?php the_content(__('(more...)')); ?>
	</div>

	<div class="feedback">
		<?php wp_link_pages(); ?>
		<?php comments_popup_link(__('Comments (0)'), __('Comments (1)'), __('Comments (%)')); ?> <?php edit_post_link(__('Edit')); ?>
	</div>

</div>

<div class="hr"></div>

<?php comments_template(); // Get wp-comments.php template ?>

<?php endwhile; else: ?>
<p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
<?php endif; ?>

<?php posts_nav_link(' &#8212; ', __('&laquo; Newer Posts'), __('Older Posts &raquo;')); ?>

<?php get_footer(); ?>
