<?php
/**
 * Title: Services Numbered List
 * Slug: portfolio-wp/services-numbered-list
 * Categories: portfolio-wp-services
 *
 * @package Portfolio WP
 * @since Portfolio WP 1.0
 */

 if ( ! PWP_EDD::is_valid() ){ return; };
?>

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"className":"services-pattern is-style-default","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull services-pattern is-style-default" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"0"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:heading {"textAlign":"left","align":"wide","fontSize":"gigantic"} -->
<h2 class="wp-block-heading alignwide has-text-align-left has-gigantic-font-size"><?php echo esc_html__( 'Services.', 'portfolio-wp' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"40px"} -->
<div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"border":{"bottom":{"width":"0px","style":"none"},"top":{"color":"var:preset|color|light-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide" style="border-top-color:var(--wp--preset--color--light-gray);border-top-width:1px;border-bottom-style:none;border-bottom-width:0px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"15%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:15%"><!-- wp:paragraph {"fontSize":"medium-large"} -->
<p class="has-medium-large-font-size">01.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Information architecture', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"45%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:45%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'We assess your site\'s content, determining what\'s essential and how it should be organized. Our focused approach in Information Architecture maps out a user-friendly path, leading visitors effectively towards conversion.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"border":{"bottom":{"width":"0px","style":"none"},"top":{"color":"var:preset|color|light-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide" style="border-top-color:var(--wp--preset--color--light-gray);border-top-width:1px;border-bottom-style:none;border-bottom-width:0px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"15%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:15%"><!-- wp:paragraph {"fontSize":"medium-large"} -->
<p class="has-medium-large-font-size">02.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Web Design', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"45%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:45%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'We\'ll enhance your existing visual identity in our web design process or provide art direction for new projects, starting with the homepage. Rest assured, our designs are always optimized for both desktop and mobile.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"border":{"bottom":{"width":"0px","style":"none"},"top":{"color":"var:preset|color|light-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide" style="border-top-color:var(--wp--preset--color--light-gray);border-top-width:1px;border-bottom-style:none;border-bottom-width:0px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"15%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:15%"><!-- wp:paragraph {"fontSize":"medium-large"} -->
<p class="has-medium-large-font-size">03.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Interactive ', 'portfolio-wp' ); ?><br><?php echo esc_html__( 'Animation', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"45%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:45%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'We craft engaging animations for your site, from page transitions to button hovers and scroll effects, all aligned with your brand\'s strategic direction for a seamless interactive experience.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"border":{"bottom":{"width":"0px","style":"none"},"top":{"color":"var:preset|color|light-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide" style="border-top-color:var(--wp--preset--color--light-gray);border-top-width:1px;border-bottom-style:none;border-bottom-width:0px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"15%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:15%"><!-- wp:paragraph {"fontSize":"medium-large"} -->
<p class="has-medium-large-font-size">04.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Web ', 'portfolio-wp' ); ?><br><?php echo esc_html__( 'Development', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"45%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:45%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'Our web development process brings designs to life, ensuring functionality across all devices and browsers, with a keen focus on performance and user experience.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"border":{"bottom":{"width":"0px","style":"none"},"top":{"color":"var:preset|color|light-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide" style="border-top-color:var(--wp--preset--color--light-gray);border-top-width:1px;border-bottom-style:none;border-bottom-width:0px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"15%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:15%"><!-- wp:paragraph {"fontSize":"medium-large"} -->
<p class="has-medium-large-font-size">05.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Launch and', 'portfolio-wp' ); ?><br><?php echo esc_html__( 'Support', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"45%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:45%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'We guide you through every step of your website\'s launch, ensuring a flawless process. Post-launch, our support continues, providing you with updates, optimizations, and assistance to maintain a great online presence.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->