<?php
/**
 * Title: Services List
 * Slug: portfolio-wp/services-list
 * Categories: portfolio-wp-services
 *
 * @package Portfolio WP
 * @since Portfolio WP 1.0
 */

 if ( ! PWP_EDD::is_valid() ){ return; };
?>

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"className":"services-pattern","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull services-pattern" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:group {"align":"wide","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:group {"align":"wide","layout":{"type":"default"}} -->
<div class="wp-block-group alignwide"><!-- wp:heading {"align":"wide","fontSize":"gigantic"} -->
<h2 class="wp-block-heading alignwide has-gigantic-font-size"><?php echo esc_html__( 'Available for:', 'portfolio-wp' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'Hello. This is what I do and what I can do for your business.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"80px"} -->
<div style="height:80px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->

<!-- wp:columns {"isStackedOnMobile":false,"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"},"margin":{"top":"0","bottom":"0"}},"border":{"bottom":{"color":"var:preset|color|dark-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide is-not-stacked-on-mobile" style="border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Content Strategy', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"60%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:60%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'I specialize in crafting bespoke content strategies that amplify my brand\'s voice and engage my target audience, driving meaningful interactions and conversions.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"isStackedOnMobile":false,"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"},"margin":{"top":"0","bottom":"0"}},"border":{"bottom":{"color":"var:preset|color|dark-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide is-not-stacked-on-mobile" style="border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Photography', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"60%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:60%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'I capture compelling images that tell your story, highlight your brand\'s essence, and visually engage your audience with every shot.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"isStackedOnMobile":false,"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"},"margin":{"top":"0","bottom":"0"}},"border":{"bottom":{"color":"var:preset|color|dark-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide is-not-stacked-on-mobile" style="border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Building Information Modeling', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"60%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:60%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'I leverage Building Information Modeling (BIM) to create detailed, digital representations of physical and functional characteristics, streamlining the architecture and construction process for efficiency and precision.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"isStackedOnMobile":false,"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"},"margin":{"top":"0","bottom":"0"}},"border":{"bottom":{"color":"var:preset|color|dark-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide is-not-stacked-on-mobile" style="border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Schematic Design (SD)', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"60%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:60%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'I craft schematic designs that serve as the blueprint for your vision, translating ideas into tangible, strategic plans that set the foundation for successful projects.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"isStackedOnMobile":false,"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"},"margin":{"top":"0","bottom":"0"}},"border":{"bottom":{"color":"var:preset|color|dark-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide is-not-stacked-on-mobile" style="border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'UI / UX Design', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"60%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:60%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'I create intuitive UI/UX designs that enhance user satisfaction by improving the usability, accessibility, and pleasure provided in the interaction.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"isStackedOnMobile":false,"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"},"margin":{"top":"0","bottom":"0"}},"border":{"bottom":{"color":"var:preset|color|dark-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide is-not-stacked-on-mobile" style="border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Javascript Development', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"60%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:60%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'I specialize in JavaScript development, crafting dynamic and responsive web applications tailored to meet your unique needs.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"isStackedOnMobile":false,"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"},"margin":{"top":"0","bottom":"0"}},"border":{"bottom":{"color":"var:preset|color|dark-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide is-not-stacked-on-mobile" style="border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'UI / UX Design', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"60%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:60%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'I conduct content workshops to empower teams with the strategies and skills needed to create impactful, audience-engaging content.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->