<?php
/**
 * Title: Services Capabilities
 * Slug: portfolio-wp/services-capabilities
 * Categories: portfolio-wp-services
 *
 * @package Portfolio WP
 * @since Portfolio WP 1.0
 */

?>

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"}}},"className":"services-pattern","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull services-pattern" style="padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:group {"align":"wide","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:heading {"align":"wide","style":{"typography":{"textTransform":"uppercase"}},"fontSize":"humongous"} -->
<h2 class="wp-block-heading alignwide has-humongous-font-size" style="text-transform:uppercase"><?php echo esc_html__( 'Capabilities', 'portfolio-wp' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"10rem"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"border":{"top":{"color":"var:preset|color|light-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide" style="border-top-color:var(--wp--preset--color--light-gray);border-top-width:1px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"level":6,"fontFamily":"helvetica-now-variable"} -->
<h6 class="wp-block-heading has-helvetica-now-variable-font-family">01</h6>
<!-- /wp:heading -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray"} -->
<h3 class="wp-block-heading has-dark-gray-color has-text-color has-link-color"><?php echo esc_html__( 'Customizable Design', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.65"}}} -->
<p style="line-height:1.65"><?php echo esc_html__( 'Tailor every aspect of your portfolio to match your unique style. You have the freedom to personalize layouts, color schemes, and typography, ensuring that your website reflects your individual brand and artistic vision.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"level":6,"fontFamily":"helvetica-now-variable"} -->
<h6 class="wp-block-heading has-helvetica-now-variable-font-family">02</h6>
<!-- /wp:heading -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray"} -->
<h3 class="wp-block-heading has-dark-gray-color has-text-color has-link-color"><?php echo esc_html__( 'Tailored Design Blocks & Patterns', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.65"}}} -->
<p style="line-height:1.65"><?php echo esc_html__( 'Unlock your creative potential with our diverse range of custom Blocks and Patterns, designed specifically for creatives. Easily add, modify, and arrange elements to bring your unique vision to life.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"level":6,"fontFamily":"helvetica-now-variable"} -->
<h6 class="wp-block-heading has-helvetica-now-variable-font-family">03</h6>
<!-- /wp:heading -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray"} -->
<h3 class="wp-block-heading has-dark-gray-color has-text-color has-link-color"><?php echo esc_html__( 'Versatile Media Support', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.65"}}} -->
<p style="line-height:1.65"><?php echo esc_html__( 'Showcase your work in stunning detail. Portfolio WP effortlessly handles images, videos, and interactive content, perfect for artists, designers, and multimedia creatives.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"10rem"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"border":{"top":{"color":"var:preset|color|light-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide" style="border-top-color:var(--wp--preset--color--light-gray);border-top-width:1px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"level":6,"fontFamily":"helvetica-now-variable"} -->
<h6 class="wp-block-heading has-helvetica-now-variable-font-family">04</h6>
<!-- /wp:heading -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray"} -->
<h3 class="wp-block-heading has-dark-gray-color has-text-color has-link-color"><?php echo esc_html__( 'Responsive and Mobile-Optimized', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.65"}}} -->
<p style="line-height:1.65"><?php echo esc_html__( 'In today\'s mobile-first world, having a responsive site is crucial. Portfolio WP ensures that your portfolio looks stunning all-around, providing an optimal viewing experience for your audience, regardless of the screen size.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"level":6,"fontFamily":"helvetica-now-variable"} -->
<h6 class="wp-block-heading has-helvetica-now-variable-font-family">05</h6>
<!-- /wp:heading -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray"} -->
<h3 class="wp-block-heading has-dark-gray-color has-text-color has-link-color"><?php echo esc_html__( 'User-Friendly Interface', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.65"}}} -->
<p style="line-height:1.65"><?php echo esc_html__( 'Navigate the WordPress dashboard of your website with ease. Even without technical expertise, managing and updating your portfolio is a breeze with PortfolioWP.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"level":6,"fontFamily":"helvetica-now-variable"} -->
<h6 class="wp-block-heading has-helvetica-now-variable-font-family">06</h6>
<!-- /wp:heading -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray"} -->
<h3 class="wp-block-heading has-dark-gray-color has-text-color has-link-color"><?php echo esc_html__( 'Regular Updates + Support', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.65"}}} -->
<p style="line-height:1.65"><?php echo esc_html__( 'Stay ahead with continuous updates that keep your site running smoothly with the latest WordPress versions, complemented by reliable support for any queries or assistance.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->