<?php
/**
 * Title: Portfolio Filtered Posts
 * Slug: portfolio-wp/portfolio-filtered-posts
 * Categories: portfolio-wp-portfolios
 *
 * @package Portfolio WP
 * @since Portfolio WP 1.0
 */

 if ( ! PWP_EDD::is_valid() || ! class_exists( 'PWP_Portfolio_Block' ) ) { return; };
?>

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"className":"portfolio-pattern is-style-default","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull portfolio-pattern is-style-default" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"border":{"radius":"16px"},"spacing":{"padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20"}}},"backgroundColor":"accent-primary","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-accent-primary-background-color has-background" style="border-radius:16px;padding-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20)"><!-- wp:heading {"textAlign":"center","level":6,"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}},"typography":{"fontStyle":"normal","fontWeight":"500"}},"textColor":"dark-gray","className":"highlighter","fontSize":"normal"} -->
<h6 class="wp-block-heading has-text-align-center highlighter has-dark-gray-color has-text-color has-link-color has-normal-font-size" style="padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);font-style:normal;font-weight:500"><?php echo esc_html__( 'An Area For Your Best Work', 'portfolio-wp' ); ?></h6>
<!-- /wp:heading --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:heading {"textAlign":"center","fontSize":"huge"} -->
<h2 class="wp-block-heading has-text-align-center has-huge-font-size"><?php echo esc_html__( 'A few samples of my work, ', 'portfolio-wp' ); ?><br><?php echo esc_html__( 'photography, designs, and artwork.', 'portfolio-wp' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","fontSize":"medium-large"} -->
<p class="has-text-align-center has-medium-large-font-size"><?php echo esc_html__( 'Crafting culture-aware interactions with a crisp eye for ', 'portfolio-wp' ); ?><br><?php echo esc_html__( 'engaging artistic, brand and websites.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:pwp/portfolio-block {"editMode":false,"position":"center left","textalignment":"left","postcategory":["Animation","Copywriting","Design","Development","Film","Illustration","Photography","Strategy","UX Design"],"posttype":"jetpack-portfolio","posttaxonomy":"jetpack-portfolio-type","portstyle":"rounded","portlayout":"position-below-image","portheadingsize":"18px","portexcerpt":false,"portpagination":false,"filternav":true,"portcolumns":4,"maxposts":"8","gutterwidth":"16","porttitlecolor":"#0D0D0D","porttextcolor":"#5A5A5A","buttoncolor":"#0D0D0D","porthoveropacity":0,"align":"wide"} /--></div>
<!-- /wp:group -->