<?php
/**
 * Title: Pricing Tables
 * Slug: portfolio-wp/misc-pricing-tables
 * Categories: portfolio-wp-misc
 *
 * @package Portfolio WP
 * @since Portfolio WP 1.0
 */

 if( ! PWP_EDD::is_valid() ){ return; };
?>

<!-- wp:group {"metadata":{"name":"Pricing Tables"},"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"}}},"backgroundColor":"bg-light","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-bg-light-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:heading {"textAlign":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"typography":{"lineHeight":"1.1"}},"textColor":"dark-gray","fontSize":"pwp-huge"} -->
<h2 class="wp-block-heading has-text-align-center has-dark-gray-color has-text-color has-link-color has-pwp-huge-font-size" style="line-height:1.1"><?php echo esc_html__( 'Check out these packages.', 'portfolio-wp' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"typography":{"fontSize":"1.15rem"}}} -->
<p class="has-text-align-center" style="font-size:1.15rem"><?php echo esc_html__( 'Embark with our free version and unlock more features as you grow. The decision to upgrade is yours - we\'ll be here when you\'re ready. What\'s the difference between our plans? More Blocks and Patterns with Pro. And Premium Support.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"60px"} -->
<div style="height:60px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns {"align":"wide"} -->
<div class="wp-block-columns alignwide"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"className":"pricing-table","style":{"spacing":{"padding":{"top":"32px","bottom":"32px","left":"32px","right":"32px"},"blockGap":"var:preset|spacing|30"},"border":{"radius":"32px","width":"1px"}},"backgroundColor":"white","borderColor":"light-gray","layout":{"type":"constrained"}} -->
<div class="wp-block-group pricing-table has-border-color has-light-gray-border-color has-white-background-color has-background" style="border-width:1px;border-radius:32px;padding-top:32px;padding-right:32px;padding-bottom:32px;padding-left:32px"><!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"margin":{"top":"0","bottom":"0"}}},"textColor":"dark-gray","fontSize":"medium","fontFamily":"helvetica-now-disp-bold"} -->
<p class="has-dark-gray-color has-text-color has-link-color has-helvetica-now-disp-bold-font-family has-medium-font-size" style="margin-top:0;margin-bottom:0"><?php echo esc_html__( 'Basic + Free', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontStyle":"normal","fontWeight":"600"}},"textColor":"dark-gray","fontSize":"extra-large","fontFamily":"helvetica-now-disp-bold"} -->
<p class="has-dark-gray-color has-text-color has-link-color has-helvetica-now-disp-bold-font-family has-extra-large-font-size" style="margin-top:0;margin-bottom:0;font-style:normal;font-weight:600"><?php echo esc_html__( '$0', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"small"} -->
<p class="has-small-font-size" style="margin-top:0;margin-bottom:0"><?php echo esc_html__( 'It\'s free, yeah, but it includes everything you need to get started on your PortfolioWP site. Our free library of starter Blocks, load of Patterns, demo content, and Basic Support.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:separator {"className":"is-style-wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}},"backgroundColor":"light-gray"} -->
<hr class="wp-block-separator has-text-color has-light-gray-color has-alpha-channel-opacity has-light-gray-background-color has-background is-style-wide" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)"/>
<!-- /wp:separator -->

<!-- wp:list {"fontFamily":"helvetica-now-disp-bold"} -->
<ul class="wp-block-list has-helvetica-now-disp-bold-font-family"><!-- wp:list-item -->
<li><?php echo esc_html__( '10 Blocks', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( '20 Patterns', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Basic Support', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"32px"}}}} -->
<div class="wp-block-buttons" style="margin-top:32px"><!-- wp:button {"textAlign":"center","width":100,"className":"is-style-outline","style":{"border":{"width":"1px"}},"fontSize":"normal"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size is-style-outline has-normal-font-size"><a class="wp-block-button__link has-text-align-center wp-element-button" style="border-width:1px"><?php echo esc_html__( 'Download For Free', 'portfolio-wp' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"className":"pricing-table","style":{"spacing":{"padding":{"top":"32px","bottom":"32px","left":"32px","right":"32px"},"blockGap":"var:preset|spacing|30"},"border":{"radius":"32px","width":"1px"}},"backgroundColor":"white","borderColor":"light-gray","layout":{"type":"constrained"}} -->
<div class="wp-block-group pricing-table has-border-color has-light-gray-border-color has-white-background-color has-background" style="border-width:1px;border-radius:32px;padding-top:32px;padding-right:32px;padding-bottom:32px;padding-left:32px"><!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"margin":{"top":"0","bottom":"0"}}},"textColor":"dark-gray","fontSize":"medium","fontFamily":"helvetica-now-disp-bold"} -->
<p class="has-dark-gray-color has-text-color has-link-color has-helvetica-now-disp-bold-font-family has-medium-font-size" style="margin-top:0;margin-bottom:0"><?php echo esc_html__( 'Pro', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontStyle":"normal","fontWeight":"600","lineHeight":"1.1"}},"textColor":"dark-gray","fontSize":"extra-large","fontFamily":"helvetica-now-disp-bold"} -->
<p class="has-dark-gray-color has-text-color has-link-color has-helvetica-now-disp-bold-font-family has-extra-large-font-size" style="margin-top:0;margin-bottom:0;font-style:normal;font-weight:600;line-height:1.1"><?php echo esc_html__( '$4.49', 'portfolio-wp' ); ?><sub>/<?php echo esc_html__( 'month', 'portfolio-wp' ); ?></sub></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|medium-gray"}}}},"textColor":"medium-gray","fontSize":"extra-small"} -->
<p class="has-medium-gray-color has-text-color has-link-color has-extra-small-font-size" style="margin-top:0;margin-bottom:0"><em><?php echo esc_html__( 'Billed Annually ', 'portfolio-wp' ); ?></em></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"spacing":{"margin":{"top":"var:preset|spacing|40","bottom":"0"}}},"fontSize":"small"} -->
<p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:0"><?php echo esc_html__( 'It\'s not free. But it includes even more than our free theme. Bunches of more Patterns, the Portfolio Block, Premium Support, and access to ', 'portfolio-wp' ); ?><strong><span style="text-decoration: underline;"><?php echo esc_html__( 'Portfolio Feedback', 'portfolio-wp' ); ?></span></strong><?php echo esc_html__( ' from our team of expert designers.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:separator {"className":"is-style-wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}},"backgroundColor":"light-gray"} -->
<hr class="wp-block-separator has-text-color has-light-gray-color has-alpha-channel-opacity has-light-gray-background-color has-background is-style-wide" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)"/>
<!-- /wp:separator -->

<!-- wp:list {"className":"wp-block-list","fontFamily":"helvetica-now-disp-bold"} -->
<ul class="wp-block-list has-helvetica-now-disp-bold-font-family"><!-- wp:list-item -->
<li><?php echo esc_html__( '20 Blocks', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( '40 Patterns', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Premium Portfolio Block', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Premium Demo Content', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Premium Support', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Portfolio Feedback', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"32px"}}}} -->
<div class="wp-block-buttons" style="margin-top:32px"><!-- wp:button {"textAlign":"center","width":100,"fontSize":"normal"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size has-normal-font-size"><a class="wp-block-button__link has-text-align-center wp-element-button"><?php echo esc_html__( 'Buy Pro, Get More', 'portfolio-wp' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"className":"pricing-table","style":{"spacing":{"padding":{"top":"32px","bottom":"32px","left":"32px","right":"32px"},"blockGap":"var:preset|spacing|30"},"border":{"radius":"32px","width":"1px"}},"backgroundColor":"white","borderColor":"light-gray","layout":{"type":"constrained"}} -->
<div class="wp-block-group pricing-table has-border-color has-light-gray-border-color has-white-background-color has-background" style="border-width:1px;border-radius:32px;padding-top:32px;padding-right:32px;padding-bottom:32px;padding-left:32px"><!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"margin":{"top":"0","bottom":"0"}}},"textColor":"dark-gray","fontSize":"medium","fontFamily":"helvetica-now-disp-bold"} -->
<p class="has-dark-gray-color has-text-color has-link-color has-helvetica-now-disp-bold-font-family has-medium-font-size" style="margin-top:0;margin-bottom:0"><?php echo esc_html__( 'Pro + Hosted', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontStyle":"normal","fontWeight":"600","lineHeight":"1.1"}},"textColor":"dark-gray","fontSize":"extra-large","fontFamily":"helvetica-now-disp-bold"} -->
<p class="has-dark-gray-color has-text-color has-link-color has-helvetica-now-disp-bold-font-family has-extra-large-font-size" style="margin-top:0;margin-bottom:0;font-style:normal;font-weight:600;line-height:1.1"><?php echo esc_html__( '$18.99', 'portfolio-wp' ); ?><sub>/<?php echo esc_html__( 'month', 'portfolio-wp' ); ?></sub></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"spacing":{"margin":{"top":"var:preset|spacing|40","bottom":"0"}}},"fontSize":"small"} -->
<p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:0"><?php echo esc_html__( 'Get everything in the Pro version, plus we\'ll setup and host your portfolio website. So you can get started showcasing your work right away!', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:separator {"className":"is-style-wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}},"backgroundColor":"light-gray"} -->
<hr class="wp-block-separator has-text-color has-light-gray-color has-alpha-channel-opacity has-light-gray-background-color has-background is-style-wide" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)"/>
<!-- /wp:separator -->

<!-- wp:list {"className":"wp-block-list","fontFamily":"helvetica-now-disp-bold"} -->
<ul class="wp-block-list has-helvetica-now-disp-bold-font-family"><!-- wp:list-item -->
<li><?php echo esc_html__( 'Free SSL Certificate', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Staging Domain', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Automatic Theme Setup', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Unlimited Uploads', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Managed WordPress', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Premium Support', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Portfolio Feedback', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"32px"}}}} -->
<div class="wp-block-buttons" style="margin-top:32px"><!-- wp:button {"textAlign":"center","width":100,"fontSize":"normal"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size has-normal-font-size"><a class="wp-block-button__link has-text-align-center wp-element-button"><?php echo esc_html__( 'Start My Website', 'portfolio-wp' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->