<?php
/**
 * Title: Hero Centered
 * Slug: portfolio-wp/hero-centered
 * Categories: portfolio-wp-hero
 *
 * @package Portfolio WP
 * @since Portfolio WP 1.0
 */

?>

<!-- wp:group {"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"0","bottom":"0","left":"0","right":"0"}}},"className":"hero-pattern is-style-default","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull hero-pattern is-style-default" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/gradient-accent.png","id":175,"dimRatio":0,"overlayColor":"white","isUserOverlayColor":true,"isDark":false,"align":"full","layout":{"type":"constrained"}} -->
<div class="wp-block-cover alignfull is-light"><span aria-hidden="true" class="wp-block-cover__background has-white-background-color has-background-dim-0 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-175" alt="" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/gradient-accent.png" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:spacer {"height":"120px"} -->
<div style="height:120px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"layout":{"type":"default"}} -->
<div class="wp-block-group"><!-- wp:heading {"textAlign":"center","style":{"typography":{"fontSize":"5.8rem","lineHeight":"1.1","letterSpacing":"0px"}}} -->
<h2 class="wp-block-heading has-text-align-center" style="font-size:5.8rem;letter-spacing:0px;line-height:1.1"><?php echo esc_html__( 'I am Michael,', 'portfolio-wp' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:heading {"textAlign":"center","style":{"typography":{"fontSize":"5.8rem","lineHeight":"1.1","letterSpacing":"0px","fontStyle":"normal","fontWeight":"400"}},"fontFamily":"lora"} -->
<h2 class="wp-block-heading has-text-align-center has-lora-font-family" style="font-size:5.8rem;font-style:normal;font-weight:400;letter-spacing:0px;line-height:1.1"><em><?php echo esc_html__( 'Senior Product Designer', 'portfolio-wp' ); ?></em></h2>
<!-- /wp:heading -->

<!-- wp:heading {"textAlign":"center","style":{"typography":{"fontSize":"5.8rem","lineHeight":"1.1","letterSpacing":"0px"}}} -->
<h2 class="wp-block-heading has-text-align-center" style="font-size:5.8rem;letter-spacing:0px;line-height:1.1"><?php echo esc_html__( 'Based in New York', 'portfolio-wp' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"40px"} -->
<div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:paragraph {"align":"center","placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"typography":{"fontSize":"1.25rem"}}} -->
<p class="has-text-align-center" style="font-size:1.25rem"><?php echo esc_html__( 'I\'m an Innovative Designer with skills in Branding, UI/UX Design, ', 'portfolio-wp' ); ?><br><?php echo esc_html__( 'Web Development, and Strategy.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"40px"} -->
<div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons"><!-- wp:button {"fontSize":"normal"} -->
<div class="wp-block-button has-custom-font-size has-normal-font-size"><a class="wp-block-button__link wp-element-button"><?php echo esc_html__( 'Get in Touch', 'portfolio-wp' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->

<!-- wp:spacer {"height":"120px"} -->
<div style="height:120px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->
