<?php
/**
 * Title: Services Template
 * Slug: portfolio-wp/full-page-services-pro
 * Categories: portfolio-wp-pages
 *
 * @package Portfolio WP
 * @since Portfolio WP 1.0
 */

 if ( ! PWP_EDD::is_valid() ){ return; };
?>

<!-- wp:group {"metadata":{"categories":["portfolio-wp-services"],"patternName":"portfolio-wp/services-numbered-list","name":"Services Numbered List"},"align":"full","className":"services-pattern is-style-default","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull services-pattern is-style-default" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:html -->
<div id="bg-wrap" style="top: -50%">
      <svg viewBox="0 0 100 100" preserveAspectRatio="xMidYMid slice">
      <defs>
      <radialGradient id="Gradient1" cx="50%" cy="50%" fx="0.441602%" fy="50%" r=".5"><animate attributeName="fx" dur="68s" values="0%;3%;0%" repeatCount="indefinite"></animate><stop offset="0%" stop-color="rgba(255, 0, 255, 1)"></stop><stop offset="100%" stop-color="rgba(255, 0, 255, 0)"></stop></radialGradient>
      <radialGradient id="Gradient2" cx="50%" cy="50%" fx="2.68147%" fy="50%" r=".5"><animate attributeName="fx" dur="47s" values="0%;3%;0%" repeatCount="indefinite"></animate><stop offset="0%" stop-color="rgba(255, 255, 0, 1)"></stop><stop offset="100%" stop-color="rgba(255, 255, 0, 0)"></stop></radialGradient>
      <radialGradient id="Gradient3" cx="50%" cy="50%" fx="0.836536%" fy="50%" r=".5"><animate attributeName="fx" dur="43s" values="0%;3%;0%" repeatCount="indefinite"></animate><stop offset="0%" stop-color="rgba(0, 255, 255, 1)"></stop><stop offset="100%" stop-color="rgba(0, 255, 255, 0)"></stop></radialGradient>
      <radialGradient id="Gradient4" cx="50%" cy="50%" fx="4.56417%" fy="50%" r=".5"><animate attributeName="fx" dur="46s" values="0%;5%;0%" repeatCount="indefinite"></animate><stop offset="0%" stop-color="rgba(0, 255, 0, 1)"></stop><stop offset="100%" stop-color="rgba(0, 255, 0, 0)"></stop></radialGradient>
      <radialGradient id="Gradient5" cx="50%" cy="50%" fx="2.65405%" fy="50%" r=".5"><animate attributeName="fx" dur="49s" values="0%;5%;0%" repeatCount="indefinite"></animate><stop offset="0%" stop-color="rgba(0,0,255, 1)"></stop><stop offset="100%" stop-color="rgba(0,0,255, 0)"></stop></radialGradient>
      <radialGradient id="Gradient6" cx="50%" cy="50%" fx="0.981338%" fy="50%" r=".5"><animate attributeName="fx" dur="51s" values="0%;5%;0%" repeatCount="indefinite"></animate><stop offset="0%" stop-color="rgba(255,0,0, 1)"></stop><stop offset="100%" stop-color="rgba(255,0,0, 0)"></stop></radialGradient>
      </defs>
      <rect x="13.744%" y="1.18473%" width="100%" height="100%" fill="url(#Gradient1)" transform="rotate(334.41 50 50)"><animate attributeName="x" dur="40s" values="25%;0%;25%" repeatCount="indefinite"></animate><animate attributeName="y" dur="42s" values="0%;25%;0%" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="rotate" from="0 50 50" to="360 50 50" dur="14s" repeatCount="indefinite"></animateTransform></rect>
      <rect x="-2.17916%" y="35.4267%" width="100%" height="100%" fill="url(#Gradient2)" transform="rotate(255.072 50 50)"><animate attributeName="x" dur="46s" values="-25%;0%;-25%" repeatCount="indefinite"></animate><animate attributeName="y" dur="48s" values="0%;50%;0%" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="rotate" from="0 50 50" to="360 50 50" dur="24s" repeatCount="indefinite"></animateTransform>
      </rect>
      <rect x="9.00483%" y="14.5733%" width="100%" height="100%" fill="url(#Gradient3)" transform="rotate(139.903 50 50)"><animate attributeName="x" dur="50s" values="0%;25%;0%" repeatCount="indefinite"></animate><animate attributeName="y" dur="24s" values="0%;25%;0%" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="rotate" from="360 50 50" to="0 50 50" dur="18s" repeatCount="indefinite"></animateTransform>
      </rect>
      </svg>
    </div>
<!-- /wp:html -->

<!-- wp:group {"align":"wide","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"default"}} -->
<div class="wp-block-group alignwide" style="margin-top:0;margin-bottom:0"><!-- wp:heading {"textAlign":"left","align":"wide","fontSize":"gigantic"} -->
<h2 class="wp-block-heading alignwide has-text-align-left has-gigantic-font-size"><?php echo esc_html__( 'Services.', 'portfolio-wp' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|40"}}}} -->
<p style="margin-top:var(--wp--preset--spacing--40)"><?php echo esc_html__( 'I offer a range of creative services listed below to bring your vision to life. Each project is tailored to meet your unique needs. ', 'portfolio-wp' ); ?><br><?php echo esc_html__( 'Let\'s collaborate to create something extraordinary that you will love and cherish.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:spacer {"height":"40px"} -->
<div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"border":{"bottom":{"width":"0px","style":"none"},"top":{"color":"var:preset|color|light-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide" style="border-top-color:var(--wp--preset--color--light-gray);border-top-width:1px;border-bottom-style:none;border-bottom-width:0px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"15%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:15%"><!-- wp:paragraph {"fontSize":"medium-large"} -->
<p class="has-medium-large-font-size">01.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Information architecture', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"45%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:45%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'We assess your site\'s content, determining what\'s essential and how it should be organized. Our focused approach in Information Architecture maps out a user-friendly path, leading visitors effectively towards conversion.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"border":{"bottom":{"width":"0px","style":"none"},"top":{"color":"var:preset|color|light-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide" style="border-top-color:var(--wp--preset--color--light-gray);border-top-width:1px;border-bottom-style:none;border-bottom-width:0px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"15%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:15%"><!-- wp:paragraph {"fontSize":"medium-large"} -->
<p class="has-medium-large-font-size">02.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Web Design', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"45%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:45%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'We\'ll enhance your existing visual identity in our web design process or provide art direction for new projects, starting with the homepage. Rest assured, our designs are always optimized for both desktop and mobile.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"border":{"bottom":{"width":"0px","style":"none"},"top":{"color":"var:preset|color|light-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide" style="border-top-color:var(--wp--preset--color--light-gray);border-top-width:1px;border-bottom-style:none;border-bottom-width:0px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"15%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:15%"><!-- wp:paragraph {"fontSize":"medium-large"} -->
<p class="has-medium-large-font-size">03.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Interactive ', 'portfolio-wp' ); ?><br><?php echo esc_html__( 'Animation', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"45%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:45%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'We craft engaging animations for your site, from page transitions to button hovers and scroll effects, all aligned with your brand\'s strategic direction for a seamless interactive experience.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"border":{"bottom":{"width":"0px","style":"none"},"top":{"color":"var:preset|color|light-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide" style="border-top-color:var(--wp--preset--color--light-gray);border-top-width:1px;border-bottom-style:none;border-bottom-width:0px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"15%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:15%"><!-- wp:paragraph {"fontSize":"medium-large"} -->
<p class="has-medium-large-font-size">04.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Web ', 'portfolio-wp' ); ?><br><?php echo esc_html__( 'Development', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"45%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:45%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'Our web development process brings designs to life, ensuring functionality across all devices and browsers, with a keen focus on performance and user experience.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}},"border":{"bottom":{"width":"0px","style":"none"},"top":{"color":"var:preset|color|light-gray","width":"1px"}}}} -->
<div class="wp-block-columns alignwide" style="border-top-color:var(--wp--preset--color--light-gray);border-top-width:1px;border-bottom-style:none;border-bottom-width:0px;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column {"verticalAlignment":"top","width":"15%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:15%"><!-- wp:paragraph {"fontSize":"medium-large"} -->
<p class="has-medium-large-font-size">05.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"40%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:40%"><!-- wp:heading {"level":3,"fontSize":"extra-large"} -->
<h3 class="wp-block-heading has-extra-large-font-size"><?php echo esc_html__( 'Launch and ', 'portfolio-wp' ); ?><br><?php echo esc_html__( 'Support', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"top","width":"45%","fontSize":"small"} -->
<div class="wp-block-column is-vertically-aligned-top has-small-font-size" style="flex-basis:45%"><!-- wp:paragraph {"align":"left","fontSize":"normal"} -->
<p class="has-text-align-left has-normal-font-size"><?php echo esc_html__( 'We guide you through every step of your website\'s launch, ensuring a flawless process. Post-launch, our support continues, providing you with updates, optimizations, and assistance to maintain a great online presence.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"metadata":{"name":"Pricing Tables"},"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"}}},"backgroundColor":"bg-light","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-bg-light-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:heading {"textAlign":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"typography":{"lineHeight":"1.1"}},"textColor":"dark-gray","fontSize":"pwp-huge"} -->
<h2 class="wp-block-heading has-text-align-center has-dark-gray-color has-text-color has-link-color has-pwp-huge-font-size" style="line-height:1.1"><?php echo esc_html__( 'Check out these packages.', 'portfolio-wp' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"typography":{"fontSize":"1.15rem"}}} -->
<p class="has-text-align-center" style="font-size:1.15rem"><?php echo esc_html__( 'Embark with our free version and unlock more features as you grow. The decision to upgrade is yours - we\'ll be here when you\'re ready. What\'s the difference between our plans? More Blocks and Patterns with Pro. And Premium Support.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"60px"} -->
<div style="height:60px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns {"align":"wide"} -->
<div class="wp-block-columns alignwide"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"className":"pricing-table","style":{"spacing":{"padding":{"top":"32px","bottom":"32px","left":"32px","right":"32px"},"blockGap":"var:preset|spacing|30"},"border":{"radius":"32px","width":"1px"}},"backgroundColor":"white","borderColor":"light-gray","layout":{"type":"constrained"}} -->
<div class="wp-block-group pricing-table has-border-color has-light-gray-border-color has-white-background-color has-background" style="border-width:1px;border-radius:32px;padding-top:32px;padding-right:32px;padding-bottom:32px;padding-left:32px"><!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"margin":{"top":"0","bottom":"0"}}},"textColor":"dark-gray","fontSize":"medium","fontFamily":"helvetica-now-disp-bold"} -->
<p class="has-dark-gray-color has-text-color has-link-color has-helvetica-now-disp-bold-font-family has-medium-font-size" style="margin-top:0;margin-bottom:0"><?php echo esc_html__( 'Basic + Free', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontStyle":"normal","fontWeight":"600"}},"textColor":"dark-gray","fontSize":"extra-large","fontFamily":"helvetica-now-disp-bold"} -->
<p class="has-dark-gray-color has-text-color has-link-color has-helvetica-now-disp-bold-font-family has-extra-large-font-size" style="margin-top:0;margin-bottom:0;font-style:normal;font-weight:600"><?php echo esc_html__( '$0', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"small"} -->
<p class="has-small-font-size" style="margin-top:0;margin-bottom:0"><?php echo esc_html__( 'It\'s free, yeah, but it includes everything you need to get started on your PortfolioWP site. Our free library of starter Blocks, load of Patterns, demo content, and Basic Support.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:separator {"className":"is-style-wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}},"backgroundColor":"light-gray"} -->
<hr class="wp-block-separator has-text-color has-light-gray-color has-alpha-channel-opacity has-light-gray-background-color has-background is-style-wide" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)"/>
<!-- /wp:separator -->

<!-- wp:list {"fontFamily":"helvetica-now-disp-bold"} -->
<ul class="wp-block-list has-helvetica-now-disp-bold-font-family"><!-- wp:list-item -->
<li><?php echo esc_html__( '10 Blocks', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( '20 Patterns', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Basic Support', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"32px"}}}} -->
<div class="wp-block-buttons" style="margin-top:32px"><!-- wp:button {"textAlign":"center","width":100,"className":"is-style-outline","style":{"border":{"width":"1px"}},"fontSize":"normal"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size is-style-outline has-normal-font-size"><a class="wp-block-button__link has-text-align-center wp-element-button" style="border-width:1px"><?php echo esc_html__( 'Download For Free', 'portfolio-wp' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"className":"pricing-table","style":{"spacing":{"padding":{"top":"32px","bottom":"32px","left":"32px","right":"32px"},"blockGap":"var:preset|spacing|30"},"border":{"radius":"32px","width":"1px"}},"backgroundColor":"white","borderColor":"light-gray","layout":{"type":"constrained"}} -->
<div class="wp-block-group pricing-table has-border-color has-light-gray-border-color has-white-background-color has-background" style="border-width:1px;border-radius:32px;padding-top:32px;padding-right:32px;padding-bottom:32px;padding-left:32px"><!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"margin":{"top":"0","bottom":"0"}}},"textColor":"dark-gray","fontSize":"medium","fontFamily":"helvetica-now-disp-bold"} -->
<p class="has-dark-gray-color has-text-color has-link-color has-helvetica-now-disp-bold-font-family has-medium-font-size" style="margin-top:0;margin-bottom:0"><?php echo esc_html__( 'Pro', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontStyle":"normal","fontWeight":"600","lineHeight":"1.1"}},"textColor":"dark-gray","fontSize":"extra-large","fontFamily":"helvetica-now-disp-bold"} -->
<p class="has-dark-gray-color has-text-color has-link-color has-helvetica-now-disp-bold-font-family has-extra-large-font-size" style="margin-top:0;margin-bottom:0;font-style:normal;font-weight:600;line-height:1.1"><?php echo esc_html__( '$4.49', 'portfolio-wp' ); ?><sub>/<?php echo esc_html__( 'month', 'portfolio-wp' ); ?></sub></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}},"elements":{"link":{"color":{"text":"var:preset|color|medium-gray"}}}},"textColor":"medium-gray","fontSize":"extra-small"} -->
<p class="has-medium-gray-color has-text-color has-link-color has-extra-small-font-size" style="margin-top:0;margin-bottom:0"><em><?php echo esc_html__( 'Billed Annually ', 'portfolio-wp' ); ?></em></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"spacing":{"margin":{"top":"var:preset|spacing|40","bottom":"0"}}},"fontSize":"small"} -->
<p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:0"><?php echo esc_html__( 'It\'s not free. But it includes even more than our free theme. Bunches of more Patterns, the Portfolio Block, Premium Support, and access to ', 'portfolio-wp' ); ?><strong><span style="text-decoration: underline;"><?php echo esc_html__( 'Portfolio Feedback', 'portfolio-wp' ); ?></span></strong><?php echo esc_html__( ' from our team of expert designers.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:separator {"className":"is-style-wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}},"backgroundColor":"light-gray"} -->
<hr class="wp-block-separator has-text-color has-light-gray-color has-alpha-channel-opacity has-light-gray-background-color has-background is-style-wide" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)"/>
<!-- /wp:separator -->

<!-- wp:list {"className":"wp-block-list","fontFamily":"helvetica-now-disp-bold"} -->
<ul class="wp-block-list has-helvetica-now-disp-bold-font-family"><!-- wp:list-item -->
<li><?php echo esc_html__( '20 Blocks', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( '40 Patterns', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Premium Portfolio Block', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Premium Demo Content', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Premium Support', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Portfolio Feedback', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"32px"}}}} -->
<div class="wp-block-buttons" style="margin-top:32px"><!-- wp:button {"textAlign":"center","width":100,"fontSize":"normal"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size has-normal-font-size"><a class="wp-block-button__link has-text-align-center wp-element-button"><?php echo esc_html__( 'Buy Pro, Get More', 'portfolio-wp' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"className":"pricing-table","style":{"spacing":{"padding":{"top":"32px","bottom":"32px","left":"32px","right":"32px"},"blockGap":"var:preset|spacing|30"},"border":{"radius":"32px","width":"1px"}},"backgroundColor":"white","borderColor":"light-gray","layout":{"type":"constrained"}} -->
<div class="wp-block-group pricing-table has-border-color has-light-gray-border-color has-white-background-color has-background" style="border-width:1px;border-radius:32px;padding-top:32px;padding-right:32px;padding-bottom:32px;padding-left:32px"><!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"margin":{"top":"0","bottom":"0"}}},"textColor":"dark-gray","fontSize":"medium","fontFamily":"helvetica-now-disp-bold"} -->
<p class="has-dark-gray-color has-text-color has-link-color has-helvetica-now-disp-bold-font-family has-medium-font-size" style="margin-top:0;margin-bottom:0"><?php echo esc_html__( 'Pro + Hosted', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontStyle":"normal","fontWeight":"600","lineHeight":"1.1"}},"textColor":"dark-gray","fontSize":"extra-large","fontFamily":"helvetica-now-disp-bold"} -->
<p class="has-dark-gray-color has-text-color has-link-color has-helvetica-now-disp-bold-font-family has-extra-large-font-size" style="margin-top:0;margin-bottom:0;font-style:normal;font-weight:600;line-height:1.1"><?php echo esc_html__( '$18.99', 'portfolio-wp' ); ?><sub>/<?php echo esc_html__( 'month', 'portfolio-wp' ); ?></sub></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"placeholder":"Type / to choose a block, or press space to summon the AI Copilot","style":{"spacing":{"margin":{"top":"var:preset|spacing|40","bottom":"0"}}},"fontSize":"small"} -->
<p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:0"><?php echo esc_html__( 'Get everything in the Pro version, plus we\'ll setup and host your portfolio website. So you can get started showcasing your work right away!', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:separator {"className":"is-style-wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}},"backgroundColor":"light-gray"} -->
<hr class="wp-block-separator has-text-color has-light-gray-color has-alpha-channel-opacity has-light-gray-background-color has-background is-style-wide" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)"/>
<!-- /wp:separator -->

<!-- wp:list {"className":"wp-block-list","fontFamily":"helvetica-now-disp-bold"} -->
<ul class="wp-block-list has-helvetica-now-disp-bold-font-family"><!-- wp:list-item -->
<li><?php echo esc_html__( 'Free SSL Certificate', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Staging Domain', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Automatic Theme Setup', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Unlimited Uploads', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Managed WordPress', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Premium Support', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><?php echo esc_html__( 'Portfolio Feedback', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"32px"}}}} -->
<div class="wp-block-buttons" style="margin-top:32px"><!-- wp:button {"textAlign":"center","width":100,"fontSize":"normal"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 has-custom-font-size has-normal-font-size"><a class="wp-block-button__link has-text-align-center wp-element-button"><?php echo esc_html__( 'Start My Website', 'portfolio-wp' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"tagName":"section","metadata":{"categories":["portfolio-wp-misc"],"patternName":"portfolio-wp/misc-marquee","name":"Scroll Marquee"},"align":"full","className":"marquee","style":{"spacing":{"padding":{"right":"0px","left":"0px"},"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"black","layout":{"type":"constrained"}} -->
<section class="wp-block-group alignfull marquee has-black-background-color has-background" style="margin-top:0;margin-bottom:0;padding-right:0px;padding-left:0px"><!-- wp:group {"className":"marquee__group","layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group marquee__group"><!-- wp:heading {"textAlign":"center","level":4,"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-primary"}}},"typography":{"fontStyle":"normal","fontWeight":"600"}},"textColor":"accent-primary","fontSize":"extra-large"} -->
<h4 class="wp-block-heading has-text-align-center has-accent-primary-color has-text-color has-link-color has-extra-large-font-size" style="font-style:normal;font-weight:600"><?php echo esc_html__( 'Creative solutions.', 'portfolio-wp' ); ?></h4>
<!-- /wp:heading --></div>
<!-- /wp:group --></section>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"}}},"backgroundColor":"accent-primary","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-accent-primary-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:columns {"verticalAlignment":"center","align":"wide"} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray","fontSize":"gigantic"} -->
<h2 class="wp-block-heading has-dark-gray-color has-text-color has-link-color has-gigantic-font-size"><?php echo esc_html__( 'Get a quote.', 'portfolio-wp' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray","fontSize":"medium"} -->
<p class="has-dark-gray-color has-text-color has-link-color has-medium-font-size"><?php echo esc_html__( 'Need some help with your project? I\'m your guy!', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}},"fontSize":"small"} -->
<p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"><?php echo esc_html__( 'Just fill out the form with your project details, and I\'ll get back to you asap.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:jetpack/contact-form {"subject":"A new quote from your website","textColor":"dark-gray","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"padding":{"right":"0","left":"0"}}},"metadata":{"categories":["forms"],"patternName":"registration-form","name":"Quote Form"}} -->
<div class="wp-block-jetpack-contact-form has-dark-gray-color has-text-color has-link-color" style="padding-right:0;padding-left:0"><!-- wp:jetpack/field-name {"required":true,"width":50,"fieldBackgroundColor":"#ffffff"} /-->

<!-- wp:jetpack/field-email {"required":true,"width":50,"fieldBackgroundColor":"#ffffff"} /-->

<!-- wp:jetpack/field-telephone {"label":"Phone Number","width":50,"fieldBackgroundColor":"#ffffff"} /-->

<!-- wp:jetpack/field-select {"label":"Service Needed","options":["Web Design","Logo Design","Interactive Animation","Web Development"],"width":50,"fieldBackgroundColor":"#ffffff","toggleLabel":"Select one option"} /-->

<!-- wp:jetpack/field-textarea {"label":"Project Details","fieldBackgroundColor":"#ffffff"} /-->

<!-- wp:jetpack/button {"element":"button","text":"Get A Quote","textColor":"accent-primary","backgroundColor":"dark-gray","width":"50%","lock":{"remove":true},"fontSize":"medium"} /--></div>
<!-- /wp:jetpack/contact-form --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->