<?php
/**
 * Title: Home Template - Pro
 * Slug: portfolio-wp/full-page-home-pro
 * Categories: portfolio-wp-pages
 *
 * @package Portfolio WP
 * @since Portfolio WP 1.0
 */

 if ( ! PWP_EDD::is_valid() ){ return; };
?>

<!-- wp:group {"align":"full","className":"about-pattern is-style-default","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull about-pattern is-style-default" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:html -->
<div id="bg-wrap" style="top: -50%">
      <svg viewBox="0 0 100 100" preserveAspectRatio="xMidYMid slice">
      <defs>
      <radialGradient id="Gradient1" cx="50%" cy="50%" fx="0.441602%" fy="50%" r=".5"><animate attributeName="fx" dur="68s" values="0%;3%;0%" repeatCount="indefinite"></animate><stop offset="0%" stop-color="rgba(255, 0, 255, 1)"></stop><stop offset="100%" stop-color="rgba(255, 0, 255, 0)"></stop></radialGradient>
      <radialGradient id="Gradient2" cx="50%" cy="50%" fx="2.68147%" fy="50%" r=".5"><animate attributeName="fx" dur="47s" values="0%;3%;0%" repeatCount="indefinite"></animate><stop offset="0%" stop-color="rgba(255, 255, 0, 1)"></stop><stop offset="100%" stop-color="rgba(255, 255, 0, 0)"></stop></radialGradient>
      <radialGradient id="Gradient3" cx="50%" cy="50%" fx="0.836536%" fy="50%" r=".5"><animate attributeName="fx" dur="43s" values="0%;3%;0%" repeatCount="indefinite"></animate><stop offset="0%" stop-color="rgba(0, 255, 255, 1)"></stop><stop offset="100%" stop-color="rgba(0, 255, 255, 0)"></stop></radialGradient>
      <radialGradient id="Gradient4" cx="50%" cy="50%" fx="4.56417%" fy="50%" r=".5"><animate attributeName="fx" dur="46s" values="0%;5%;0%" repeatCount="indefinite"></animate><stop offset="0%" stop-color="rgba(0, 255, 0, 1)"></stop><stop offset="100%" stop-color="rgba(0, 255, 0, 0)"></stop></radialGradient>
      <radialGradient id="Gradient5" cx="50%" cy="50%" fx="2.65405%" fy="50%" r=".5"><animate attributeName="fx" dur="49s" values="0%;5%;0%" repeatCount="indefinite"></animate><stop offset="0%" stop-color="rgba(0,0,255, 1)"></stop><stop offset="100%" stop-color="rgba(0,0,255, 0)"></stop></radialGradient>
      <radialGradient id="Gradient6" cx="50%" cy="50%" fx="0.981338%" fy="50%" r=".5"><animate attributeName="fx" dur="51s" values="0%;5%;0%" repeatCount="indefinite"></animate><stop offset="0%" stop-color="rgba(255,0,0, 1)"></stop><stop offset="100%" stop-color="rgba(255,0,0, 0)"></stop></radialGradient>
      </defs>
      <!--<rect x="0" y="0" width="100%" height="100%" fill="url(#Gradient4)">
      <animate attributeName="x" dur="40s" values="25%;0%;25%" repeatCount="indefinite" />
      <animate attributeName="y" dur="42s" values="0%;25%;0%" repeatCount="indefinite" />
      <animateTransform attributeName="transform" type="rotate" from="0 50 50" to="360 50 50" dur="34s" repeatCount="indefinite"/>
      </rect>
      <rect x="0" y="0" width="100%" height="100%" fill="url(#Gradient5)">
      <animate attributeName="x" dur="46s" values="0%;-25%;0%" repeatCount="indefinite" />
      <animate attributeName="y" dur="48s" values="25%;-25%;25%" repeatCount="indefinite" />
      <animateTransform attributeName="transform" type="rotate" from="0 50 50" to="360 50 50" dur="36s" repeatCount="indefinite"/>
      </rect>
      <rect x="0" y="0" width="100%" height="100%" fill="url(#Gradient6)">
      <animate attributeName="x" dur="50s" values="-25%;0%;-25%" repeatCount="indefinite" />
      <animate attributeName="y" dur="52s" values="0%;-25%;0%" repeatCount="indefinite" />
      <animateTransform attributeName="transform" type="rotate" from="360 50 50" to="0 50 50" dur="38s" repeatCount="indefinite"/>
      </rect>-->
      <rect x="13.744%" y="1.18473%" width="100%" height="100%" fill="url(#Gradient1)" transform="rotate(334.41 50 50)"><animate attributeName="x" dur="40s" values="25%;0%;25%" repeatCount="indefinite"></animate><animate attributeName="y" dur="42s" values="0%;25%;0%" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="rotate" from="0 50 50" to="360 50 50" dur="14s" repeatCount="indefinite"></animateTransform></rect>
      <rect x="-2.17916%" y="35.4267%" width="100%" height="100%" fill="url(#Gradient2)" transform="rotate(255.072 50 50)"><animate attributeName="x" dur="46s" values="-25%;0%;-25%" repeatCount="indefinite"></animate><animate attributeName="y" dur="48s" values="0%;50%;0%" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="rotate" from="0 50 50" to="360 50 50" dur="24s" repeatCount="indefinite"></animateTransform>
      </rect>
      <rect x="9.00483%" y="14.5733%" width="100%" height="100%" fill="url(#Gradient3)" transform="rotate(139.903 50 50)"><animate attributeName="x" dur="50s" values="0%;25%;0%" repeatCount="indefinite"></animate><animate attributeName="y" dur="24s" values="0%;25%;0%" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="rotate" from="360 50 50" to="0 50 50" dur="18s" repeatCount="indefinite"></animateTransform>
      </rect>
      </svg>
    </div>
<!-- /wp:html -->

<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"center","fontSize":"medium-large"} -->
<p class="has-text-align-center has-medium-large-font-size">Hello, my name is Inigo Montoya. A designer based in NYC, <br>looking for rad projects and new opportunities.</p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"40px"} -->
<div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:heading {"textAlign":"center","fontSize":"humongous"} -->
<h2 class="wp-block-heading has-text-align-center has-humongous-font-size">I can help you stand out <span style="text-decoration: underline;">with an awesome website.</span></h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"80px"} -->
<div style="height:80px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center">This website is a harmonious blend of WordPress and React.js, brought to life through the versatility of Portfolio WP, showcasing a perfect melding of content management and modern web technologies.</p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-outline","style":{"border":{"width":"2px"}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-font-size is-style-outline has-medium-font-size"><a class="wp-block-button__link wp-element-button" href="https://portfoliowp.com/demo/contact/" style="border-width:2px">Get In Touch</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","className":"portfolio-pattern is-style-default","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"bg-light","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull portfolio-pattern is-style-default has-bg-light-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"border":{"radius":"16px"},"spacing":{"padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20"}}},"backgroundColor":"accent-primary","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-accent-primary-background-color has-background" style="border-radius:16px;padding-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20)"><!-- wp:heading {"textAlign":"center","level":6,"className":"highlighter","style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}},"typography":{"fontStyle":"normal","fontWeight":"500"}},"textColor":"dark-gray","fontSize":"normal"} -->
<h6 class="wp-block-heading has-text-align-center highlighter has-dark-gray-color has-text-color has-link-color has-normal-font-size" style="padding-top:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);font-style:normal;font-weight:500">An Area For Your Best Work</h6>
<!-- /wp:heading --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:heading {"textAlign":"center","fontSize":"huge"} -->
<h2 class="wp-block-heading has-text-align-center has-huge-font-size">A few samples of my work, <br>photography, designs, and artwork.</h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","fontSize":"medium-large"} -->
<p class="has-text-align-center has-medium-large-font-size">Crafting culture-aware interactions with a crisp eye for <br>engaging artistic, brand and websites.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:pwp/portfolio-block {"editMode":false,"position":"center left","textalignment":"left","postcategory":["Animation","Copywriting","Design","Development","Film","Illustration","Photography","Strategy","UX Design"],"posttype":"jetpack-portfolio","posttaxonomy":"jetpack-portfolio-type","portlayout":"position-below-image","portheadingsize":"18px","masonrylayout":true,"filternav":true,"portcolumns":4,"maxposts":"8","porttitlecolor":"#0D0D0D","porttextcolor":"#5A5A5A","buttoncolor":"#0D0D0D","buttonbg":"#FDF800","porthoveropacity":0,"align":"wide"} /-->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-outline","style":{"border":{"width":"2px"}},"fontSize":"medium","borderColor":"dark-gray"} -->
<div class="wp-block-button has-custom-font-size is-style-outline has-medium-font-size"><a class="wp-block-button__link has-border-color has-dark-gray-border-color wp-element-button" style="border-width:2px">View Full Portfolio</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"}}},"backgroundColor":"bg-dark","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-bg-dark-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:woocommerce/product-collection {"queryId":1,"query":{"perPage":6,"pages":1,"offset":0,"postType":"product","order":"desc","orderBy":"popularity","search":"","exclude":[],"inherit":false,"taxQuery":{},"isProductCollectionBlock":true,"featured":false,"woocommerceOnSale":false,"woocommerceStockStatus":["instock","outofstock","onbackorder"],"woocommerceAttributes":[],"woocommerceHandPickedProducts":[],"filterable":false},"tagName":"div","displayLayout":{"type":"flex","columns":3,"shrinkColumns":true},"collection":"woocommerce/product-collection/best-sellers","hideControls":["inherit","order","filterable"],"queryContextIncludes":["collection"],"__privatePreviewState":{"isPreview":false,"previewMessage":"Actual products will vary depending on the page being viewed."},"align":"wide"} -->
<div class="wp-block-woocommerce-product-collection alignwide"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"default"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"default"}} -->
<div class="wp-block-group"><!-- wp:heading {"textAlign":"left","style":{"spacing":{"margin":{"bottom":"1rem"}},"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white","fontSize":"gigantic"} -->
<h2 class="wp-block-heading has-text-align-left has-white-color has-text-color has-link-color has-gigantic-font-size" style="margin-bottom:1rem">Shop Art.</h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|light-gray"}}}},"textColor":"light-gray"} -->
<p class="has-light-gray-color has-text-color has-link-color">Check out these recent additions to our shop. <strong><a href="https://portfoliowp.com/pricing/"><mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-accent-primary-color">PortfolioWP Pro</mark></a></strong> features full WooCommerce compatibility.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"right"}} -->
<div class="wp-block-buttons"><!-- wp:button {"fontSize":"medium"} -->
<div class="wp-block-button has-custom-font-size has-medium-font-size"><a class="wp-block-button__link wp-element-button" href="https://portfoliowp.com/demo/shop/">Shop Art Prints</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:woocommerce/product-template -->
<!-- wp:group {"style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"}},"border":{"radius":"12px"}},"backgroundColor":"white","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-white-background-color has-background" style="border-radius:12px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:woocommerce/product-image {"imageSizing":"thumbnail","isDescendentOfQueryLoop":true,"style":{"border":{"radius":{"topLeft":"12px","topRight":"12px","bottomLeft":"0px","bottomRight":"0px"}}}} /-->

<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"0","left":"var:preset|spacing|40"},"margin":{"top":"0","bottom":"0"},"padding":{"right":"var:preset|spacing|40","left":"var:preset|spacing|40","top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}}} -->
<div class="wp-block-columns" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--40)"><!-- wp:column {"width":"75%"} -->
<div class="wp-block-column" style="flex-basis:75%"><!-- wp:post-title {"textAlign":"left","level":3,"isLink":true,"style":{"spacing":{"margin":{"bottom":"0.75rem","top":"0"}},"typography":{"letterSpacing":"0px"},"elements":{"link":{":hover":{"color":{"text":"var:preset|color|accent-secondary"}}}}},"fontSize":"small","__woocommerceNamespace":"woocommerce/product-collection/product-title"} /--></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"right"}} -->
<div class="wp-block-group"><!-- wp:woocommerce/product-price {"isDescendentOfQueryLoop":true,"textAlign":"center","fontSize":"small","style":{"typography":{"fontStyle":"normal","fontWeight":"700"}}} /--></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:woocommerce/product-button {"textAlign":"center","isDescendentOfQueryLoop":true,"fontSize":"small","style":{"border":{"radius":{"topLeft":"0px","topRight":"0px","bottomLeft":"12px","bottomRight":"12px"}},"spacing":{"margin":{"top":"0","bottom":"0"}}}} /--></div>
<!-- /wp:group -->
<!-- /wp:woocommerce/product-template -->

<!-- wp:paragraph {"align":"right","style":{"elements":{"link":{"color":{"text":"var:preset|color|medium-gray"}}}},"textColor":"medium-gray"} -->
<p class="has-text-align-right has-medium-gray-color has-text-color has-link-color">Art provided courtesy of <a href="https://swellscenes.com">Swell Scenes</a>.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:woocommerce/product-collection --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","className":"services-pattern","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull services-pattern" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:group {"align":"wide","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:heading {"align":"wide","fontSize":"humongous"} -->
<h2 class="wp-block-heading alignwide has-humongous-font-size">Capabilities.</h2>
<!-- /wp:heading -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"10rem"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}}}} -->
<div class="wp-block-columns alignwide" style="padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"level":6,"fontFamily":"helvetica-now-light"} -->
<h6 class="wp-block-heading has-helvetica-now-light-font-family">01</h6>
<!-- /wp:heading -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray"} -->
<h3 class="wp-block-heading has-dark-gray-color has-text-color has-link-color">Customizable Design</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.65"}}} -->
<p style="line-height:1.65">Tailor every aspect of your portfolio to match your unique style. You have the freedom to personalize layouts, color schemes, and typography, ensuring that your website reflects your individual brand and artistic vision.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"level":6,"fontFamily":"helvetica-now-light"} -->
<h6 class="wp-block-heading has-helvetica-now-light-font-family">02</h6>
<!-- /wp:heading -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray"} -->
<h3 class="wp-block-heading has-dark-gray-color has-text-color has-link-color">Tailored Design Blocks &amp; Patterns</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.65"}}} -->
<p style="line-height:1.65">Unlock your creative potential with our diverse range of custom Blocks and Patterns, designed specifically for creatives. Easily add, modify, and arrange elements to bring your unique vision to life.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"level":6,"fontFamily":"helvetica-now-light"} -->
<h6 class="wp-block-heading has-helvetica-now-light-font-family">03</h6>
<!-- /wp:heading -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray"} -->
<h3 class="wp-block-heading has-dark-gray-color has-text-color has-link-color">Versatile Media Support</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.65"}}} -->
<p style="line-height:1.65">Showcase your work in stunning detail. Portfolio WP effortlessly handles images, videos, and interactive content, perfect for artists, designers, and multimedia creatives.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"10rem"},"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"},"margin":{"top":"0","bottom":"0"}}}} -->
<div class="wp-block-columns alignwide" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"level":6,"fontFamily":"helvetica-now-light"} -->
<h6 class="wp-block-heading has-helvetica-now-light-font-family">04</h6>
<!-- /wp:heading -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray"} -->
<h3 class="wp-block-heading has-dark-gray-color has-text-color has-link-color">Responsive and Mobile-Optimized</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.65"}}} -->
<p style="line-height:1.65">In today’s mobile-first world, having a responsive site is crucial. Portfolio WP ensures that your portfolio looks stunning all-around, providing an optimal viewing experience for your audience, regardless of the screen size.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"level":6,"fontFamily":"helvetica-now-light"} -->
<h6 class="wp-block-heading has-helvetica-now-light-font-family">05</h6>
<!-- /wp:heading -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray"} -->
<h3 class="wp-block-heading has-dark-gray-color has-text-color has-link-color">User-Friendly Interface</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.65"}}} -->
<p style="line-height:1.65">Navigate the WordPress dashboard of your website with ease. Even without technical expertise, managing and updating your portfolio is a breeze with Portfolio WP.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:heading {"level":6,"fontFamily":"helvetica-now-light"} -->
<h6 class="wp-block-heading has-helvetica-now-light-font-family">06</h6>
<!-- /wp:heading -->

<!-- wp:heading {"level":3,"style":{"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray"} -->
<h3 class="wp-block-heading has-dark-gray-color has-text-color has-link-color">Regular Updates + Support</h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.65"}}} -->
<p style="line-height:1.65">Stay ahead with continuous updates that keep your site running smoothly with the latest WordPress versions, complemented by reliable support for any queries or assistance.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","className":"portfolio-pattern portfolio-list hidden-overflow","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"bg-light","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull portfolio-pattern portfolio-list hidden-overflow has-bg-light-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:group {"align":"wide","layout":{"type":"default"}} -->
<div class="wp-block-group alignwide"><!-- wp:heading {"align":"wide","fontSize":"humongous"} -->
<h2 class="wp-block-heading alignwide has-humongous-font-size">Projects.</h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>These are recent samples of the rad projects I’ve been working on.</p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"40px"} -->
<div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull" style="margin-top:0;margin-bottom:0"><!-- wp:query {"queryId":0,"query":{"perPage":"8","pages":0,"offset":0,"postType":"jetpack-portfolio","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false,"parents":[],"taxQuery":{"jetpack-portfolio-type":[]}},"align":"full","layout":{"type":"default"}} -->
<div class="wp-block-query alignfull"><!-- wp:post-template {"align":"full","style":{"typography":{"lineHeight":"0"}},"layout":{"type":"default"}} -->
<!-- wp:group {"align":"full","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}},"border":{"top":{"color":"var:preset|color|dark-gray","width":"1px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull" style="border-top-color:var(--wp--preset--color--dark-gray);border-top-width:1px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50)"><!-- wp:columns {"verticalAlignment":"center","align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|50"},"margin":{"top":"0","bottom":"0"},"padding":{"top":"0","bottom":"0","left":"0","right":"0"}}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:column {"verticalAlignment":"center","width":"40%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40%"><!-- wp:post-title {"isLink":true,"fontSize":"x-large"} /-->

<!-- wp:post-featured-image {"className":"hidden"} /--></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"25%","className":"categories"} -->
<div class="wp-block-column is-vertically-aligned-center categories" style="flex-basis:25%"><!-- wp:post-terms {"term":"jetpack-portfolio-type","separator":"","style":{"typography":{"lineHeight":1.6},"elements":{"link":{"color":{"text":"var:preset|color|dark-gray"}}}},"textColor":"dark-gray","fontSize":"normal"} /--></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"25%","className":"tags"} -->
<div class="wp-block-column is-vertically-aligned-center tags" style="flex-basis:25%"><!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"right"}} -->
<div class="wp-block-group"><!-- wp:post-terms {"term":"jetpack-portfolio-tag","separator":"","style":{"typography":{"lineHeight":"3.2","textTransform":"uppercase"}}} /--></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"10%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:10%"><!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"right"}} -->
<div class="wp-block-group"><!-- wp:read-more {"content":"\u003cimg class=\u0022wp-image-319\u0022 style=\u0022width: 36px;\u0022 src=\u0022https://portfoliowp.com/demo/wp-content/themes/portfolio-wp/assets/images/arrow.png\u0022 alt=\u0022\u0022\u003e"} /--></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->
<!-- /wp:post-template -->

<!-- wp:group {"style":{"spacing":{"padding":{"right":"var:preset|spacing|50","left":"var:preset|spacing|50","top":"0","bottom":"0"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:var(--wp--preset--spacing--50);padding-bottom:0;padding-left:var(--wp--preset--spacing--50)"><!-- wp:query-no-results -->
<!-- wp:spacer {"height":"40px"} -->
<div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:heading -->
<h2 class="wp-block-heading">No Results</h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Try creating posts or changing the options for the Query Loop block.</p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"40px"} -->
<div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->
<!-- /wp:query-no-results --></div>
<!-- /wp:group --></div>
<!-- /wp:query --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","className":"case-study-pattern is-style-pwp-dark-style","style":{"spacing":{"blockGap":"var:preset|spacing|70","padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull case-study-pattern is-style-pwp-dark-style" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:heading {"align":"wide","fontSize":"humongous"} -->
<h2 class="wp-block-heading alignwide has-humongous-font-size">Case Study.</h2>
<!-- /wp:heading -->

<!-- wp:cover {"url":"https://portfoliowp.com/demo/wp-content/themes/portfolio-wp/assets/images/placeholders/portfolio-03.webp","id":193,"dimRatio":40,"overlayColor":"bg-dark","isUserOverlayColor":true,"minHeight":520,"contentPosition":"center left","align":"wide","style":{"border":{"radius":"16px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover alignwide has-custom-content-position is-position-center-left" style="border-radius:16px;min-height:520px"><img class="wp-block-cover__image-background wp-image-193" alt="" src="https://portfoliowp.com/demo/wp-content/themes/portfolio-wp/assets/images/placeholders/portfolio-03.webp" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-bg-dark-background-color has-background-dim-40 has-background-dim"></span><div class="wp-block-cover__inner-container"><!-- wp:group {"align":"full","style":{"spacing":{"padding":{"right":"48px","left":"48px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull" style="padding-right:48px;padding-left:48px"><!-- wp:heading {"textAlign":"left","fontSize":"huge"} -->
<h2 class="wp-block-heading has-text-align-left has-huge-font-size">Bringing delight<br>to Google</h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"80px"} -->
<div style="height:80px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover -->

<!-- wp:columns {"style":{"spacing":{"blockGap":{"left":"var:preset|spacing|80"}}}} -->
<div class="wp-block-columns"><!-- wp:column {"width":"25%"} -->
<div class="wp-block-column" style="flex-basis:25%"><!-- wp:heading {"textAlign":"right","level":5} -->
<h5 class="wp-block-heading has-text-align-right">Background</h5>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph -->
<p><strong>Project</strong><br>Google Doodles</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph -->
<p><strong>Role</strong><br>UX / UI Designer</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph -->
<p><strong>Year</strong><br>2018 - 2022</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:paragraph -->
<p>In collaboration with the creative minds behind Google Doodles, our goal was to enrich the Google Search landing page with engaging and interactive experiences for users. From whimsical games like Solitaire and Pac-Man to cultural celebrations for Ramadan, we aimed to bring joy and engagement directly to users' fingertips. My role involved working intimately with the doodle team to develop a design framework that seamlessly integrated these experiences into the Google search results page, focusing on intuitive game layouts and controls for an enhanced user interaction.</p>
<!-- /wp:paragraph -->

<!-- wp:image {"id":18,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"16px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="https://portfoliowp.com/demo/wp-content/themes/portfolio-wp/assets/images/placeholders/portfolio-01.webp" alt="" class="wp-image-18" style="border-radius:16px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":5} -->
<h5 class="wp-block-heading">Creating Interactive Joy <br>with Google Doodles.</h5>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Leveraging a blend of art and technology, we aimed to craft doodles that were not just visually appealing but also interactive. From celebrating historical figures to marking significant global events, each doodle was a gateway to a richer, more engaging user experience. </p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>As a creative partner with the Google Doodles team, I embarked on a journey to infuse the Google Search landing page with moments of delight and engagement. Our mission was to transcend traditional search experiences, making each visit to Google a chance to learn, play, and celebrate.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:gallery {"linkTo":"none"} -->
<figure class="wp-block-gallery has-nested-images columns-default is-cropped"><!-- wp:image {"id":188,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="https://portfoliowp.com/demo/wp-content/themes/portfolio-wp/assets/images/placeholders/portfolio-04.webp" alt="" class="wp-image-188" style="border-radius:8px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":187,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="https://portfoliowp.com/demo/wp-content/themes/portfolio-wp/assets/images/placeholders/portfolio-02.webp" alt="" class="wp-image-187" style="border-radius:8px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":186,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="https://portfoliowp.com/demo/wp-content/themes/portfolio-wp/assets/images/placeholders/portfolio-04.webp" alt="" class="wp-image-186" style="border-radius:8px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":200,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="https://portfoliowp.com/demo/wp-content/themes/portfolio-wp/assets/images/placeholders/portfolio-02.webp" alt="" class="wp-image-200" style="border-radius:8px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":198,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="https://portfoliowp.com/demo/wp-content/themes/portfolio-wp/assets/images/placeholders/portfolio-04.webp" alt="" class="wp-image-198" style="border-radius:8px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":196,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="https://portfoliowp.com/demo/wp-content/themes/portfolio-wp/assets/images/placeholders/portfolio-02.webp" alt="" class="wp-image-196" style="border-radius:8px"/></figure>
<!-- /wp:image --></figure>
<!-- /wp:gallery -->

<!-- wp:columns {"style":{"spacing":{"blockGap":{"left":"var:preset|spacing|80"}}}} -->
<div class="wp-block-columns"><!-- wp:column {"width":"25%"} -->
<div class="wp-block-column" style="flex-basis:25%"><!-- wp:heading {"textAlign":"right","level":5} -->
<h5 class="wp-block-heading has-text-align-right">A New Dimension of Engagement</h5>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph -->
<p>Our collaborative efforts led to a significant increase in user interaction with Google Doodles. By turning everyday searches into opportunities for play and education, we contributed to making the Google Search landing page a source of unexpected joy and discovery for millions worldwide. </p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>This project was a testament to the power of collaborative innovation in creating experiences that resonate with users across the globe. It reinforced my belief in the importance of design that not only looks good but also engages, educates, and inspires.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","className":"contact-pattern","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull contact-pattern" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:group {"align":"wide","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:spacer {"height":"60px"} -->
<div style="height:60px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns {"verticalAlignment":"center","align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|80"}}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"50%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:50%"><!-- wp:heading {"textAlign":"left","style":{"typography":{"lineHeight":"1"}},"fontSize":"humongous"} -->
<h2 class="wp-block-heading has-text-align-left has-humongous-font-size" style="line-height:1">Contact.</h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"60px"} -->
<div style="height:60px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:paragraph {"fontSize":"normal"} -->
<p class="has-normal-font-size">Are you ready to create unconventional content that supercharges your business and brand image?</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"fontSize":"normal"} -->
<p class="has-normal-font-size">Fill out this form for a chance to win a free content consultation.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"fontSize":"normal"} -->
<p class="has-normal-font-size">If you would rather just send an email, you can reach us at <a href="mailto:team@portfoliowp.com">team@portfoliowp.com</a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:group {"layout":{"type":"default"}} -->
<div class="wp-block-group"><!-- wp:jetpack/contact-form {"subject":"[Portfolio WP.] Contact Patterns"} -->
<div class="wp-block-jetpack-contact-form"><!-- wp:jetpack/field-name {"required":true,"requiredText":"(required)","borderRadius":8,"borderWidth":0,"fieldBackgroundColor":"#F0F0F0","borderColor":"#ffffff"} /-->

<!-- wp:jetpack/field-email {"required":true,"requiredText":"(required)","borderRadius":8,"borderWidth":0,"fieldBackgroundColor":"#F0F0F0","borderColor":"#ffffff"} /-->

<!-- wp:jetpack/field-textarea {"label":"Message","requiredText":"(required)","borderRadius":8,"borderWidth":0,"fieldBackgroundColor":"#F0F0F0","borderColor":"#ffffff"} /-->

<!-- wp:jetpack/button {"element":"button","text":"Contact Us","textColor":"dark-gray","backgroundColor":"accent-primary","width":"50%","lock":{"remove":true},"className":"is-style-fill"} /--></div>
<!-- /wp:jetpack/contact-form --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:spacer {"height":"60px"} -->
<div style="height:60px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","className":"logo-pattern is-style-default","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"accent-primary","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull logo-pattern is-style-default has-accent-primary-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:heading {"align":"wide","fontSize":"humongous"} -->
<h2 class="wp-block-heading alignwide has-humongous-font-size">Clients.</h2>
<!-- /wp:heading -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"0","left":"0"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:columns {"isStackedOnMobile":false,"align":"wide","style":{"spacing":{"blockGap":{"top":"0","left":"0"}},"layout":{"selfStretch":"fit","flexSize":null}}} -->
<div class="wp-block-columns alignwide is-not-stacked-on-mobile"><!-- wp:column {"style":{"border":{"width":"1px"}},"borderColor":"dark-gray"} -->
<div class="wp-block-column has-border-color has-dark-gray-border-color" style="border-width:1px"><!-- wp:image {"id":633,"sizeSlug":"large","linkDestination":"none","style":{"color":{"duotone":"unset"}}} -->
<figure class="wp-block-image size-large"><img src="https://portfoliowp.com/demo/wp-content/uploads/sites/2/2024/03/stripe-1024x1024.png" alt="" class="wp-image-633"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"border":{"top":{"color":"var:preset|color|dark-gray","width":"1px"},"right":{"color":"var:preset|color|dark-gray","width":"1px"},"bottom":{"color":"var:preset|color|dark-gray","width":"1px"},"left":[]}}} -->
<div class="wp-block-column" style="border-top-color:var(--wp--preset--color--dark-gray);border-top-width:1px;border-right-color:var(--wp--preset--color--dark-gray);border-right-width:1px;border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px"><!-- wp:image {"id":626,"sizeSlug":"large","linkDestination":"none","style":{"color":{"duotone":"unset"}}} -->
<figure class="wp-block-image size-large"><img src="https://portfoliowp.com/demo/wp-content/uploads/sites/2/2024/03/meta-1024x1024.png" alt="" class="wp-image-626"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"border":{"top":{"color":"var:preset|color|dark-gray","width":"1px"},"right":{"color":"var:preset|color|dark-gray","width":"1px"},"bottom":{"color":"var:preset|color|dark-gray","width":"1px"},"left":[]}}} -->
<div class="wp-block-column" style="border-top-color:var(--wp--preset--color--dark-gray);border-top-width:1px;border-right-color:var(--wp--preset--color--dark-gray);border-right-width:1px;border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px"><!-- wp:image {"id":635,"sizeSlug":"large","linkDestination":"none","style":{"color":{"duotone":"unset"}}} -->
<figure class="wp-block-image size-large"><img src="https://portfoliowp.com/demo/wp-content/uploads/sites/2/2024/03/uber-1024x1024.png" alt="" class="wp-image-635"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"border":{"top":{"color":"var:preset|color|dark-gray","width":"1px"},"right":{"color":"var:preset|color|dark-gray","width":"1px"},"bottom":{"color":"var:preset|color|dark-gray","width":"1px"},"left":[]}}} -->
<div class="wp-block-column" style="border-top-color:var(--wp--preset--color--dark-gray);border-top-width:1px;border-right-color:var(--wp--preset--color--dark-gray);border-right-width:1px;border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px"><!-- wp:image {"id":629,"sizeSlug":"large","linkDestination":"none","style":{"color":{"duotone":"unset"}}} -->
<figure class="wp-block-image size-large"><img src="https://portfoliowp.com/demo/wp-content/uploads/sites/2/2024/03/playstation-1024x1024.png" alt="" class="wp-image-629"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:columns {"isStackedOnMobile":false,"align":"wide","style":{"spacing":{"blockGap":{"top":"0","left":"0"},"margin":{"top":"0","bottom":"0"}},"layout":{"selfStretch":"fit","flexSize":null}}} -->
<div class="wp-block-columns alignwide is-not-stacked-on-mobile" style="margin-top:0;margin-bottom:0"><!-- wp:column {"style":{"border":{"top":{"width":"1px","color":"var:preset|color|dark-gray"},"right":{"width":"1px","color":"var:preset|color|dark-gray"},"bottom":{"width":"1px","color":"var:preset|color|dark-gray"},"left":{"width":"1px"}}}} -->
<div class="wp-block-column" style="border-top-color:var(--wp--preset--color--dark-gray);border-top-width:1px;border-right-color:var(--wp--preset--color--dark-gray);border-right-width:1px;border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px;border-left-width:1px"><!-- wp:image {"id":622,"sizeSlug":"large","linkDestination":"none","style":{"color":{"duotone":"unset"}}} -->
<figure class="wp-block-image size-large"><img src="https://portfoliowp.com/demo/wp-content/uploads/sites/2/2024/03/github-1024x1024.png" alt="" class="wp-image-622"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"border":{"top":{"color":"var:preset|color|dark-gray","width":"1px"},"right":{"color":"var:preset|color|dark-gray","width":"1px"},"bottom":{"color":"var:preset|color|dark-gray","width":"1px"},"left":[]}}} -->
<div class="wp-block-column" style="border-top-color:var(--wp--preset--color--dark-gray);border-top-width:1px;border-right-color:var(--wp--preset--color--dark-gray);border-right-width:1px;border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px"><!-- wp:image {"id":634,"sizeSlug":"large","linkDestination":"none","style":{"color":{"duotone":"unset"}}} -->
<figure class="wp-block-image size-large"><img src="https://portfoliowp.com/demo/wp-content/uploads/sites/2/2024/03/twitch-1024x1024.png" alt="" class="wp-image-634"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"border":{"top":{"color":"var:preset|color|dark-gray","width":"1px"},"right":{"color":"var:preset|color|dark-gray","width":"1px"},"bottom":{"color":"var:preset|color|dark-gray","width":"1px"},"left":{"width":"0px","style":"none"}}}} -->
<div class="wp-block-column" style="border-top-color:var(--wp--preset--color--dark-gray);border-top-width:1px;border-right-color:var(--wp--preset--color--dark-gray);border-right-width:1px;border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px;border-left-style:none;border-left-width:0px"><!-- wp:image {"id":631,"sizeSlug":"large","linkDestination":"none","style":{"border":{"width":"0px","style":"none"},"color":{"duotone":"unset"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="https://portfoliowp.com/demo/wp-content/uploads/sites/2/2024/03/sony-1024x1024.png" alt="" class="wp-image-631" style="border-style:none;border-width:0px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"border":{"top":{"color":"var:preset|color|dark-gray","width":"1px"},"right":{"color":"var:preset|color|dark-gray","width":"1px"},"bottom":{"color":"var:preset|color|dark-gray","width":"1px"},"left":[]}}} -->
<div class="wp-block-column" style="border-top-color:var(--wp--preset--color--dark-gray);border-top-width:1px;border-right-color:var(--wp--preset--color--dark-gray);border-right-width:1px;border-bottom-color:var(--wp--preset--color--dark-gray);border-bottom-width:1px"><!-- wp:image {"id":619,"sizeSlug":"large","linkDestination":"none","style":{"color":{"duotone":"unset"}}} -->
<figure class="wp-block-image size-large"><img src="https://portfoliowp.com/demo/wp-content/uploads/sites/2/2024/03/apple-1024x1024.png" alt="" class="wp-image-619"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->