<?php
/**
 * Title: Case Study Template - Free
 * Slug: portfolio-wp/full-page-case-study-free
 * Categories: portfolio-wp-pages
 *
 * @package Portfolio WP
 * @since Portfolio WP 1.0
 */

?>

<!-- wp:group {"metadata":{"categories":["portfolio-wp-case-studies"],"patternName":"portfolio-wp/case-study-two","name":"Case Study Two"},"align":"full","className":"case-study-pattern","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull case-study-pattern" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"textAlign":"left","fontSize":"huge"} -->
<h2 class="wp-block-heading has-text-align-left has-huge-font-size">Netflix</h2>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:paragraph {"align":"right","fontSize":"large"} -->
<p class="has-text-align-right has-large-font-size">2020 -2024</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-03.webp","id":195,"dimRatio":0,"overlayColor":"bg-dark","isUserOverlayColor":true,"minHeight":520,"contentPosition":"center center","align":"wide","style":{"border":{"radius":"16px"}},"layout":{"type":"default"}} -->
<div class="wp-block-cover alignwide" style="border-radius:16px;min-height:520px"><span aria-hidden="true" class="wp-block-cover__background has-bg-dark-background-color has-background-dim-0 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-195" alt="" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-03.webp" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div></div>
<!-- /wp:cover -->

<!-- wp:group {"layout":{"type":"constrained","contentSize":"880px"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php echo esc_html__( 'As the lead designer, I spearheaded the redesign of Netflix\'s platform, focusing on creating a more intuitive and engaging user experience. ', 'portfolio-wp' ); ?><mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-medium-gray-color"><?php echo esc_html__( 'This comprehensive project involved the introduction of advanced search functionalities, a streamlined product catalog, price comparison features, and integrated user reviews, among other enhancements.', 'portfolio-wp' ); ?></mark></h3>
<!-- /wp:heading -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph -->
<p><strong><?php echo esc_html__( 'Key Contributions:', 'portfolio-wp' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:list -->
<ul class="wp-block-list"><!-- wp:list-item -->
<li><strong><?php echo esc_html__( 'Enhanced Search Functionality:', 'portfolio-wp' ); ?></strong><?php echo esc_html__( ' Developed an advanced search system that allows users to easily find content aligned with their preferences.', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><strong><?php echo esc_html__( 'Product Catalog Redesign:', 'portfolio-wp' ); ?></strong><?php echo esc_html__( ' Revamped the browsing interface to showcase Netflix\'s extensive library in a more organized and visually appealing manner.', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><strong><?php echo esc_html__( 'Price Comparison Integration:', 'portfolio-wp' ); ?></strong><?php echo esc_html__( ' Implemented a feature enabling users to compare subscription plans, ensuring transparency and informed decision-making.', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><strong><?php echo esc_html__( 'User Reviews System:', 'portfolio-wp' ); ?></strong><?php echo esc_html__( ' Introduced a platform for user-generated reviews, fostering a community-driven approach to content discovery.', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'This project aimed to not only improve the aesthetics of the Netflix platform but also to significantly enhance usability, making content discovery a seamless and personalized experience for its vast user base.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"25%"} -->
<div class="wp-block-column" style="flex-basis:25%"></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:jetpack/tiled-gallery {"align":"","columns":3,"columnWidths":[["50.00000","50.00000"],["33.33333","33.33333","33.33333"]],"ids":[894,895,893,892,890]} -->
<div class="wp-block-jetpack-tiled-gallery is-style-rectangular"><div class=""><div class="tiled-gallery__gallery"><div class="tiled-gallery__row"><div class="tiled-gallery__col" style="flex-basis:50.00000%"><figure class="tiled-gallery__item"><img alt="" data-height="1371" data-id="894" data-link="https://portfoliowp.com/demo/pages/about-template-pro/post-02/" data-url="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/post-02.webp" data-width="2400" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/post-02.webp" data-amp-layout="responsive" tabindex="0" role="button" aria-label="Open image 1 of 5 in full-screen"/></figure></div><div class="tiled-gallery__col" style="flex-basis:50.00000%"><figure class="tiled-gallery__item"><img alt="" data-height="1371" data-id="895" data-link="https://portfoliowp.com/demo/pages/about-template-pro/post-03/" data-url="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/post-03.webp" data-width="2400" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/post-03.webp" data-amp-layout="responsive" tabindex="0" role="button" aria-label="Open image 2 of 5 in full-screen"/></figure></div></div><div class="tiled-gallery__row"><div class="tiled-gallery__col" style="flex-basis:33.33333%"><figure class="tiled-gallery__item"><img alt="" data-height="1371" data-id="893" data-link="https://portfoliowp.com/demo/pages/about-template-pro/post-01/" data-url="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/post-01.webp" data-width="2400" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/post-01.webp" data-amp-layout="responsive" tabindex="0" role="button" aria-label="Open image 3 of 5 in full-screen"/></figure></div><div class="tiled-gallery__col" style="flex-basis:33.33333%"><figure class="tiled-gallery__item"><img alt="" data-height="1371" data-id="892" data-link="https://portfoliowp.com/demo/pages/about-template-pro/portfolio-08/" data-url="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-08.webp" data-width="2400" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-08.webp" data-amp-layout="responsive" tabindex="0" role="button" aria-label="Open image 4 of 5 in full-screen"/></figure></div><div class="tiled-gallery__col" style="flex-basis:33.33333%"><figure class="tiled-gallery__item"><img alt="" data-height="1371" data-id="890" data-link="https://portfoliowp.com/demo/pages/about-template-pro/portfolio-06/" data-url="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-06.webp" data-width="2400" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-06.webp" data-amp-layout="responsive" tabindex="0" role="button" aria-label="Open image 5 of 5 in full-screen"/></figure></div></div></div></div></div>
<!-- /wp:jetpack/tiled-gallery -->

<!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph -->
<p><strong><?php echo esc_html__( 'Event & notifications.', 'portfolio-wp' ); ?><br></strong><?php echo esc_html__( 'Find all the details for the event, chat with other participants and get important updates.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><strong><?php echo esc_html__( 'Key Contributions:', 'portfolio-wp' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:list -->
<ul class="wp-block-list"><!-- wp:list-item -->
<li><strong><?php echo esc_html__( 'Enhanced Search Functionality:', 'portfolio-wp' ); ?></strong><?php echo esc_html__( ' Developed an advanced search system that allows users to easily find content aligned with their preferences.', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><strong><?php echo esc_html__( 'Product Catalog Redesign:', 'portfolio-wp' ); ?></strong><?php echo esc_html__( ' Revamped the browsing interface to showcase Netflix\'s extensive library in a more organized and visually appealing manner.', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><strong><?php echo esc_html__( 'Price Comparison Integration:', 'portfolio-wp' ); ?></strong><?php echo esc_html__( ' Implemented a feature enabling users to compare subscription plans, ensuring transparency and informed decision-making.', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item -->

<!-- wp:list-item -->
<li><strong><?php echo esc_html__( 'User Reviews System:', 'portfolio-wp' ); ?></strong><?php echo esc_html__( ' Introduced a platform for user-generated reviews, fostering a community-driven approach to content discovery.', 'portfolio-wp' ); ?></li>
<!-- /wp:list-item --></ul>
<!-- /wp:list -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'This project aimed to not only improve the aesthetics of the Netflix platform but also to significantly enhance usability, making content discovery a seamless and personalized experience for its vast user base.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"25%"} -->
<div class="wp-block-column" style="flex-basis:25%"></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->