<?php
/**
 * Title: About Template - Free
 * Slug: portfolio-wp/full-page-about-free
 * Categories: portfolio-wp-pages
 *
 * @package Portfolio WP
 * @since Portfolio WP 1.0
 */

?>

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"className":"about-pattern is-style-default","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull about-pattern is-style-default" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:group {"align":"wide","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:heading {"align":"wide","fontSize":"humongous"} -->
<h2 class="wp-block-heading alignwide has-humongous-font-size"><?php echo esc_html__( 'About Me. ', 'portfolio-wp' ); ?><span style="font-size: 90%;">👋</span></h2>
<!-- /wp:heading -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"9rem"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph {"fontSize":"medium"} -->
<p class="has-medium-font-size"><?php echo esc_html__( 'Hello, I\'m ', 'portfolio-wp' ); ?><strong><?php echo esc_html__( 'Rito Hyrule', 'portfolio-wp' ); ?></strong><?php echo esc_html__( '—a multifaceted creative director, designer, founder, and entrepreneur. For more than ten years, I spearheaded the design systems consultancy, Portfolio WP, guiding designers and creatives in establishing robust design frameworks. My current mission is to democratize design education and portfolio functionality, offering resources and opportunities to those who might not have access otherwise. This vision has led to the creation of Portfolio Review for Good, a platform dedicated to empowering aspiring designers. Dive deeper into my story.<br><br>This website is a harmonious blend of WordPress and React.js, brought to life through the versatility of Portfolio WP, showcasing a perfect melding of content management and modern web technologies.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"60px"} -->
<div style="height:60px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"style":{"border":{"width":"2px"}},"className":"is-style-outline"} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button" style="border-width:2px"><?php echo esc_html__( 'Download My Resume', 'portfolio-wp' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"33%"} -->
<div class="wp-block-column" style="flex-basis:33%"><!-- wp:columns {"style":{"spacing":{"blockGap":{"left":"0"}}}} -->
<div class="wp-block-columns"><!-- wp:column {"width":"46px","style":{"spacing":{"blockGap":"0"}}} -->
<div class="wp-block-column" style="flex-basis:46px"><!-- wp:paragraph -->
<p>EM</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>X</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>IG</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>YT</p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"blockGap":"0"}}} -->
<div class="wp-block-column"><!-- wp:paragraph -->
<p><a href="<?php echo esc_url( 'mailto:team@portfoliowp.com' ); ?>">team@portfoliowp.com</a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><a href="#">@PortfolioWP</a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><a href="#">@press75</a></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><a href="#">@yourchannelhere</a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"className":"services-pattern is-style-default","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull services-pattern is-style-default" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:group {"align":"wide","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:heading {"align":"wide","fontSize":"humongous"} -->
<h2 class="wp-block-heading alignwide has-humongous-font-size"><?php echo esc_html__( 'What I do.', 'portfolio-wp' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"9rem"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"width":"40%"} -->
<div class="wp-block-column" style="flex-basis:40%"><!-- wp:group {"style":{"spacing":{"padding":{"bottom":"var:preset|spacing|40"},"margin":{"top":"0","bottom":"var:preset|spacing|40"}},"border":{"bottom":{"color":"var:preset|color|light-gray","width":"1px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="border-bottom-color:var(--wp--preset--color--light-gray);border-bottom-width:1px;margin-top:0;margin-bottom:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40)"><!-- wp:paragraph -->
<p><?php echo esc_html__( 'Content Strategy', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"bottom":"var:preset|spacing|40"},"margin":{"top":"0","bottom":"var:preset|spacing|40"}},"border":{"bottom":{"color":"var:preset|color|light-gray","width":"1px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="border-bottom-color:var(--wp--preset--color--light-gray);border-bottom-width:1px;margin-top:0;margin-bottom:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40)"><!-- wp:paragraph -->
<p><?php echo esc_html__( 'Content Strategy', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"bottom":"var:preset|spacing|40"},"margin":{"top":"0","bottom":"var:preset|spacing|40"}},"border":{"bottom":{"color":"var:preset|color|light-gray","width":"1px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="border-bottom-color:var(--wp--preset--color--light-gray);border-bottom-width:1px;margin-top:0;margin-bottom:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40)"><!-- wp:paragraph -->
<p><?php echo esc_html__( '3D Modeling', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"bottom":"var:preset|spacing|40"},"margin":{"top":"0","bottom":"var:preset|spacing|40"}},"border":{"bottom":{"color":"var:preset|color|light-gray","width":"1px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="border-bottom-color:var(--wp--preset--color--light-gray);border-bottom-width:1px;margin-top:0;margin-bottom:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40)"><!-- wp:paragraph -->
<p><?php echo esc_html__( 'Photography', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"bottom":"var:preset|spacing|40"},"margin":{"top":"0","bottom":"var:preset|spacing|40"}},"border":{"bottom":{"color":"var:preset|color|light-gray","width":"1px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="border-bottom-color:var(--wp--preset--color--light-gray);border-bottom-width:1px;margin-top:0;margin-bottom:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40)"><!-- wp:paragraph -->
<p><?php echo esc_html__( 'Guest Speaking Engagements', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"bottom":"var:preset|spacing|40"},"margin":{"top":"0","bottom":"var:preset|spacing|40"}},"border":{"bottom":{"color":"var:preset|color|light-gray","width":"1px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="border-bottom-color:var(--wp--preset--color--light-gray);border-bottom-width:1px;margin-top:0;margin-bottom:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40)"><!-- wp:paragraph -->
<p><?php echo esc_html__( 'Digital Strategy Consulting', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"width":"60%"} -->
<div class="wp-block-column" style="flex-basis:60%"><!-- wp:paragraph {"fontSize":"medium"} -->
<p class="has-medium-font-size"><?php echo esc_html__( 'Portfolio WP transcends the ordinary WordPress theme, evolving into an intuitive platform crafted for creative professionals. It stands out with its ease of use, customizable Blocks and Patterns, designed to let creatives showcase their work with elegance and efficiency.<br><br>Rooted in a rich background of content strategy and marketing, Portfolio WP is pivotal in enhancing the digital presence of B2B and B2C companies across various sectors. It empowers users to achieve their business objectives through dynamic and optimized content, redefining the way creatives build their online showcase.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:spacer {"height":"60px"} -->
<div style="height:60px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"style":{"border":{"width":"2px"}},"borderColor":"dark-gray","className":"is-style-outline"} -->
<div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-border-color has-dark-gray-border-color wp-element-button" style="border-width:2px"><?php echo esc_html__( 'Just Get In Touch', 'portfolio-wp' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->