<?php
/**
 * Title: Contact Basic
 * Slug: portfolio-wp/contact-basic
 * Categories: portfolio-wp-contact
 *
 * @package Portfolio WP
 * @since Portfolio WP 1.0
 */

?>

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"className":"contact pattern","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull contact pattern" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:columns {"align":"wide"} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"width":"20%"} -->
<div class="wp-block-column" style="flex-basis:20%"><!-- wp:heading {"level":3} -->
<h3 class="wp-block-heading"><?php echo esc_html__( 'Not another "designer"', 'portfolio-wp' ); ?></h3>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column {"width":""} -->
<div class="wp-block-column"><!-- wp:paragraph -->
<p><?php echo esc_html__( 'In the realm of freelance design, I stand apart. Your project is not just another task on my list—it\'s an opportunity for a true partnership. Expect my full dedication and undivided attention as we embark on this creative journey together.', 'portfolio-wp' ); ?>
<br><br><?php echo esc_html__( 'Forget the exorbitant fees and sluggish timelines you might associate with big design agencies. With me, you\'re not paying for slow, outsourced work. I take pride in rolling up my sleeves and diving into the design work personally, ensuring every detail is crafted to perfection. And on the rare occasion I bring in a collaborator to enhance our project, you\'ll be the first to know. Transparency is key in our partnership.', 'portfolio-wp' ); ?>
<br><br><?php echo esc_html__( 'Move beyond the limitations of design subscription services and their "every few days" task completion. I\'m committed to working tirelessly, delivering top-notch interfaces with remarkable speed. Say goodbye to the endless wait for "small" requests to come to life.', 'portfolio-wp' ); ?>
<br><br><?php echo esc_html__( 'Once our project concludes, the choice is yours: we can discuss future collaborations, part ways with a strong portfolio piece, or simply keep in touch for whatever the future holds.', 'portfolio-wp' ); ?>
<br><br><?php echo esc_html__( 'Ready to transform your vision into reality? ', 'portfolio-wp' ); ?><a href="#"><?php echo esc_html__( 'Let\'s talk.', 'portfolio-wp' ); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->