<?php
/**
 * Title: Case Study One
 * Slug: portfolio-wp/case-study-one
 * Categories: portfolio-wp-case-studies
 *
 * @package Portfolio WP
 * @since Portfolio WP 1.0
 */

 if( ! PWP_EDD::is_valid() ){ return; };
?>

<!-- wp:group {"align":"full","style":{"spacing":{"blockGap":"var:preset|spacing|70","padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|80"},"margin":{"top":"0","bottom":"0"}}},"className":"case-study-pattern is-style-default","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull case-study-pattern is-style-default" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-bottom:var(--wp--preset--spacing--80)"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-03.webp","id":193,"dimRatio":40,"overlayColor":"bg-dark","isUserOverlayColor":true,"minHeight":520,"contentPosition":"center left","align":"wide","style":{"border":{"radius":"16px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover alignwide has-custom-content-position is-position-center-left" style="border-radius:16px;min-height:520px"><span aria-hidden="true" class="wp-block-cover__background has-bg-dark-background-color has-background-dim-40 has-background-dim"></span><img class="wp-block-cover__image-background wp-image-193" alt="" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-03.webp" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"left","fontSize":"huge"} -->
<h2 class="wp-block-heading has-text-align-left has-huge-font-size"><?php echo esc_html__( 'Bringing delight', 'portfolio-wp' ); ?><br><?php echo esc_html__( 'to Google', 'portfolio-wp' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"80px"} -->
<div style="height:80px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer --></div>
<!-- /wp:group --></div></div>
<!-- /wp:cover -->

<!-- wp:columns {"style":{"spacing":{"blockGap":{"left":"var:preset|spacing|80"}}}} -->
<div class="wp-block-columns"><!-- wp:column {"width":"25%"} -->
<div class="wp-block-column" style="flex-basis:25%"><!-- wp:heading {"textAlign":"right","level":5} -->
<h5 class="wp-block-heading has-text-align-right"><?php echo esc_html__( 'Background', 'portfolio-wp' ); ?></h5>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:columns -->
<div class="wp-block-columns"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph -->
<p><strong><?php echo esc_html__( 'Project', 'portfolio-wp' ); ?></strong><br><?php echo esc_html__( 'Google Doodles', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph -->
<p><strong><?php echo esc_html__( 'Role', 'portfolio-wp' ); ?></strong><br><?php echo esc_html__( 'UX / UI Designer', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph -->
<p><strong><?php echo esc_html__( 'Year', 'portfolio-wp' ); ?></strong><br><?php echo esc_html__( '2018 - 2022', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'In collaboration with the creative minds behind Google Doodles, our goal was to enrich the Google Search landing page with engaging and interactive experiences for users. From whimsical games like Solitaire and Pac-Man to cultural celebrations for Ramadan, we aimed to bring joy and engagement directly to users\' fingertips. My role involved working intimately with the doodle team to develop a design framework that seamlessly integrated these experiences into the Google search results page, focusing on intuitive game layouts and controls for an enhanced user interaction.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:image {"id":18,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"16px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-01.webp" alt="" class="wp-image-18" style="border-radius:16px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":5} -->
<h5 class="wp-block-heading"><?php echo esc_html__( 'Creating Interactive Joy', 'portfolio-wp' ); ?><br><?php echo esc_html__( 'with Google Doodles.', 'portfolio-wp' ); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'Leveraging a blend of art and technology, we aimed to craft doodles that were not just visually appealing but also interactive. From celebrating historical figures to marking significant global events, each doodle was a gateway to a richer, more engaging user experience.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'As a creative partner with the Google Doodles team, I embarked on a journey to infuse the Google Search landing page with moments of delight and engagement. Our mission was to transcend traditional search experiences, making each visit to Google a chance to learn, play, and celebrate.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:gallery {"linkTo":"none"} -->
<figure class="wp-block-gallery has-nested-images columns-default is-cropped"><!-- wp:image {"id":188,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-04.webp" alt="" class="wp-image-188" style="border-radius:8px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":187,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-02.webp" alt="" class="wp-image-187" style="border-radius:8px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":186,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-04.webp" alt="" class="wp-image-186" style="border-radius:8px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":200,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-02.webp" alt="" class="wp-image-200" style="border-radius:8px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":198,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-04.webp" alt="" class="wp-image-198" style="border-radius:8px"/></figure>
<!-- /wp:image -->

<!-- wp:image {"id":196,"sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placeholders/portfolio-02.webp" alt="" class="wp-image-196" style="border-radius:8px"/></figure>
<!-- /wp:image --></figure>
<!-- /wp:gallery -->

<!-- wp:columns {"style":{"spacing":{"blockGap":{"left":"var:preset|spacing|80"}}}} -->
<div class="wp-block-columns"><!-- wp:column {"width":"25%"} -->
<div class="wp-block-column" style="flex-basis:25%"><!-- wp:heading {"textAlign":"right","level":5} -->
<h5 class="wp-block-heading has-text-align-right"><?php echo esc_html__( 'A New Dimension of Engagement', 'portfolio-wp' ); ?></h5>
<!-- /wp:heading --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:paragraph -->
<p><?php echo esc_html__( 'Our collaborative efforts led to a significant increase in user interaction with Google Doodles. By turning everyday searches into opportunities for play and education, we contributed to making the Google Search landing page a source of unexpected joy and discovery for millions worldwide.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'This project was a testament to the power of collaborative innovation in creating experiences that resonate with users across the globe. It reinforced my belief in the importance of design that not only looks good but also engages, educates, and inspires.', 'portfolio-wp' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->
