<?php 
/**
 * Template part for displaying Featured Article Section
 *
 * @package Popular Blogger
 */

$popular_blogger_article_setting            = get_theme_mod( 'popular_blogger_article_setting', true );
$popular_blogger_article_text_section       = get_theme_mod( 'popular_blogger_article_text_section' );
$popular_blogger_article_small_text_section = get_theme_mod( 'popular_blogger_article_small_text_section' );
$popular_blogger_selected_post_id           = get_theme_mod( 'popular_blogger_selected_article_post' ); 
?>

<?php if ( $popular_blogger_article_setting ) : ?>
<div class="featured-article our-classes py-5 py-md-3">
    <div class="container">
        <div class="row">
            <div class="col-xl-9 col-lg-8 col-md-12">
                <?php if ( $popular_blogger_article_text_section ) : ?>
                    <h3 class="mb-0"><?php echo esc_html( $popular_blogger_article_text_section ); ?></h3>
                <?php endif; ?>

                <?php if ( $popular_blogger_article_small_text_section ) : ?>
                    <p class="main-text"><?php echo esc_html( $popular_blogger_article_small_text_section ); ?></p>
                <?php endif; ?>

                <?php 
                if ( $popular_blogger_selected_post_id ) :
                    $popular_blogger_args = array(
                        'post_type' => 'post',
                        'p'         => $popular_blogger_selected_post_id,
                    );

                    $popular_blogger_loop = new WP_Query( $popular_blogger_args );

                    if ( $popular_blogger_loop->have_posts() ) :
                        while ( $popular_blogger_loop->have_posts() ) : $popular_blogger_loop->the_post(); ?>
                            <div class="pro-box align-self-center px-0">
                                <div class="box">
                                    <div class="row g-4 align-items-center">
                                        <div class="col-md-8 align-items-center">
                                            <div class="box-content py-3">
                                                <?php 
                                                $popular_blogger_categories = get_the_category();
                                                if ( ! empty( $popular_blogger_categories ) ) {
                                                    echo '<p class="post-category mb-2">' . esc_html( $popular_blogger_categories[0]->name ) . '</p>';
                                                }
                                                ?>

                                                <h4 class="title mb-3">
                                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                </h4>

                                                <p class="article-para excerpt mb-3">
                                                    <?php echo esc_html( wp_trim_words( get_the_excerpt(), 20, '...' ) ); ?>
                                                </p>

                                                <div class="post-meta">
                                                    <div class="row align-items-center">
                                                        <div class="artician">
                                                            <div class="post-meta-author d-flex align-items-center">
                                                                <span class="me-2">
                                                                    <?php echo get_avatar( get_the_author_meta( 'ID' ), 40 ); ?>
                                                                </span>
                                                                <div>
                                                                    <span><?php esc_html_e( 'By', 'popular-blogger' ); ?></span>
                                                                    <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" class="author-name">
                                                                        <?php echo esc_html( get_the_author() ); ?>
                                                                    </a>
                                                                </div>
                                                            </div>
                                                            <div class="blog-date">
                                                                <i class="fa-regular fa-calendar-days me-1"></i>
                                                                <?php echo esc_html( get_the_date() ); ?>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="align-items-center gap-3 mt-3">
                                                        <div class="row">
                                                            <div class="gal-detail d-flex">
                                                                <div class="like-comment">
                                                                    <div class="post-like">
                                                                        <?php echo do_shortcode('[posts_like_dislike]'); ?>
                                                                    </div>
                                                                    <div class="post-meta-comments">
                                                                        <span><i class="fa-regular fa-comments me-2"></i><?php echo get_comments_number(); ?></span>
                                                                    </div>
                                                                </div>
                                                                <div class="bookmark">
                                                                    <i class="fas fa-bookmark"></i>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 align-items-center">
                                            <div class="article-image-blog">
                                                <?php if ( has_post_thumbnail() ) : ?>
                                                    <?php the_post_thumbnail( 'large', array( 'class' => 'img-fluid' ) ); ?>
                                                <?php else : ?>
                                                    <img src="<?php echo esc_url( get_stylesheet_directory_uri() . '/images/article.png' ); ?>" class="img-fluid">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile;
                        wp_reset_postdata();
                    endif;
                endif;
                ?>
            </div>

            <!-- Tags Section -->
            <div class="col-xl-3 col-lg-4 col-md-12">
                <div class="tags-box p-3">
                    <div class="tag-heading d-flex justify-content-between align-items-center mb-3">
                        <h5 class="mb-0"><?php esc_html_e( 'More tags', 'popular-blogger' ); ?></h5>
                        <?php 
                        $popular_blogger_more_tags_url = get_theme_mod( 'popular_blogger_more_tags_url' );
                        if ( ! empty( $popular_blogger_more_tags_url ) ) : ?>
                            <a target="_blank" href="<?php echo esc_url( $popular_blogger_more_tags_url ); ?>" class="text-decoration-none">
                                <?php esc_html_e( 'View all', 'popular-blogger' ); ?>
                            </a>
                        <?php endif; ?>
                    </div>
                    <div class="tag-list flex-wrap gap-2">
                        <?php 
                        $popular_blogger_tags = get_tags( array( 'number' => 10 ) );
                        if ( $popular_blogger_tags ) {
                            foreach ( $popular_blogger_tags as $popular_blogger_tag ) {
                                echo '<a href="' . esc_url( get_tag_link( $popular_blogger_tag->term_id ) ) . '" class="btn btn-outline-secondary btn-sm">' . esc_html( $popular_blogger_tag->name ) . ' (' . intval( $popular_blogger_tag->count ) . ')</a>';
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>
            <!-- End Tags Section -->
        </div>
    </div>
</div>
<?php endif; ?>
